/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class FieldCursorForDelimitedDataParser {
    public char[] buffer;
    public int fStart;
    public int fEnd;
    public int recordCount;
    public int fieldCount;
    public int doubleQuoteCount;
    public boolean isDoubleQuoteIncludedInThisField;
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private static final int INCREMENT = 4096;
    private Reader in;
    private int start;
    private int end;
    private State state;
    private int lastQuotePosition;
    private int lastDoubleQuotePosition;
    private int lastDelimiterPosition;
    private int quoteCount;
    private boolean startedQuote;
    private char quote;
    private char fieldDelimiter;

    public FieldCursorForDelimitedDataParser(Reader in, char fieldDelimiter, char quote) {
        this.in = in;
        if (in != null) {
            this.buffer = new char[4096];
            this.end = 0;
        } else {
            this.end = Integer.MAX_VALUE;
        }
        this.start = 0;
        this.state = State.INIT;
        this.quote = quote;
        this.fieldDelimiter = fieldDelimiter;
        this.lastDelimiterPosition = -99;
        this.lastQuotePosition = -99;
        this.lastDoubleQuotePosition = -99;
        this.quoteCount = 0;
        this.doubleQuoteCount = 0;
        this.startedQuote = false;
        this.isDoubleQuoteIncludedInThisField = false;
        this.recordCount = 0;
        this.fieldCount = 0;
    }

    public void nextRecord(char[] buffer, int recordLength) throws IOException {
        ++this.recordCount;
        this.fieldCount = 0;
        this.start = 0;
        this.end = recordLength;
        this.state = State.IN_RECORD;
        this.buffer = buffer;
    }

    public boolean nextRecord() throws IOException {
        ++this.recordCount;
        this.fieldCount = 0;
        while (true) {
            block0 : switch (this.state) {
                case INIT: {
                    boolean eof;
                    boolean bl = eof = !this.readMore();
                    if (eof) {
                        this.state = State.EOF;
                        return false;
                    }
                    this.state = State.IN_RECORD;
                    return true;
                }
                case IN_RECORD: {
                    char ch;
                    boolean eof;
                    int p = this.start;
                    while (true) {
                        if (p >= this.end) {
                            int s = this.start;
                            boolean bl = eof = !this.readMore();
                            if (eof) {
                                this.state = State.EOF;
                                return this.start < this.end;
                            }
                            p -= s - this.start;
                            this.lastQuotePosition -= s - this.start;
                            this.lastDoubleQuotePosition -= s - this.start;
                            this.lastDelimiterPosition -= s - this.start;
                        }
                        if ((ch = this.buffer[p]) == this.quote) {
                            this.startedQuote = true;
                            if (this.lastQuotePosition == p - 1 && this.start != p - 1 && this.lastDoubleQuotePosition != p - 1) {
                                this.lastDoubleQuotePosition = p;
                            }
                            this.lastQuotePosition = p;
                        } else if (ch == this.fieldDelimiter) {
                            if (this.startedQuote && this.lastQuotePosition == p - 1 && this.lastDoubleQuotePosition != p - 1) {
                                this.startedQuote = false;
                                this.lastDelimiterPosition = p;
                            }
                        } else {
                            if (ch == '\n' && !this.startedQuote) {
                                this.start = p + 1;
                                this.state = State.EOR;
                                this.lastDelimiterPosition = p;
                                break block0;
                            }
                            if (ch == '\r' && !this.startedQuote) {
                                this.start = p + 1;
                                this.state = State.CR;
                                this.lastDelimiterPosition = p;
                                break block0;
                            }
                        }
                        ++p;
                    }
                }
                case CR: {
                    char ch;
                    boolean eof;
                    if (this.start >= this.end) {
                        boolean bl = eof = !this.readMore();
                        if (eof) {
                            this.state = State.EOF;
                            return false;
                        }
                    }
                    if ((ch = this.buffer[this.start]) == '\n' && !this.startedQuote) {
                        ++this.start;
                        this.state = State.EOR;
                    } else {
                        this.state = State.IN_RECORD;
                        return true;
                    }
                }
                case EOR: {
                    boolean eof;
                    if (this.start >= this.end) {
                        boolean bl = eof = !this.readMore();
                        if (eof) {
                            this.state = State.EOF;
                            return false;
                        }
                    }
                    this.state = State.IN_RECORD;
                    this.lastDelimiterPosition = this.start;
                    return this.start < this.end;
                }
                case EOF: {
                    return false;
                }
            }
        }
    }

    public boolean nextField() throws IOException {
        ++this.fieldCount;
        switch (this.state) {
            case INIT: 
            case CR: 
            case EOR: 
            case EOF: {
                return false;
            }
            case IN_RECORD: {
                this.startedQuote = false;
                this.isDoubleQuoteIncludedInThisField = false;
                this.lastQuotePosition = -99;
                this.lastDoubleQuotePosition = -99;
                this.quoteCount = 0;
                this.doubleQuoteCount = 0;
                int p = this.start;
                while (true) {
                    char ch;
                    if (p >= this.end) {
                        int s = this.start;
                        boolean eof = !this.readMore();
                        p -= s - this.start;
                        this.lastQuotePosition -= s - this.start;
                        this.lastDoubleQuotePosition -= s - this.start;
                        this.lastDelimiterPosition -= s - this.start;
                        if (eof) {
                            this.state = State.EOF;
                            if (this.startedQuote && this.lastQuotePosition == p - 1 && this.lastDoubleQuotePosition != p - 1 && this.quoteCount == this.doubleQuoteCount * 2 + 2) {
                                this.fStart = this.start + 1;
                                this.fEnd = p - 1;
                            } else {
                                this.fStart = this.start;
                                this.fEnd = p;
                            }
                            return true;
                        }
                    }
                    if ((ch = this.buffer[p]) == this.quote) {
                        if (!this.startedQuote) {
                            if (this.lastDelimiterPosition == p - 1 || this.lastDelimiterPosition == -99) {
                                this.startedQuote = true;
                            } else {
                                throw new IOException("At record: " + this.recordCount + ", field#: " + this.fieldCount + " - a quote enclosing a field needs to be placed in the beginning of that field.");
                            }
                        }
                        if (this.lastQuotePosition == p - 1 && this.lastDelimiterPosition != p - 2 && this.lastDoubleQuotePosition != p - 1) {
                            this.isDoubleQuoteIncludedInThisField = true;
                            ++this.doubleQuoteCount;
                            this.lastDoubleQuotePosition = p;
                        }
                        this.lastQuotePosition = p;
                        ++this.quoteCount;
                    } else if (ch == this.fieldDelimiter) {
                        if (!this.startedQuote) {
                            this.fStart = this.start;
                            this.fEnd = p;
                            this.start = p + 1;
                            this.lastDelimiterPosition = p;
                            return true;
                        }
                        if (this.startedQuote) {
                            if (this.lastQuotePosition == p - 1 && this.lastDoubleQuotePosition != p - 1) {
                                this.fStart = this.start + 1;
                                this.fEnd = p - 1;
                                this.start = p + 1;
                                this.lastDelimiterPosition = p;
                                this.startedQuote = false;
                                return true;
                            }
                            if (this.lastQuotePosition < p - 1 && this.lastQuotePosition != this.lastDoubleQuotePosition && this.quoteCount == this.doubleQuoteCount * 2 + 2) {
                                throw new IOException("At record: " + this.recordCount + ", field#: " + this.fieldCount + " -  A quote enclosing a field needs to be followed by the delimiter.");
                            }
                        }
                    } else if (ch == '\n') {
                        if (!this.startedQuote) {
                            this.fStart = this.start;
                            this.fEnd = p;
                            this.start = p + 1;
                            this.state = State.EOR;
                            this.lastDelimiterPosition = p;
                            return true;
                        }
                        if (this.startedQuote && this.lastQuotePosition == p - 1 && this.lastDoubleQuotePosition != p - 1 && this.quoteCount == this.doubleQuoteCount * 2 + 2) {
                            this.fStart = this.start + 1;
                            this.fEnd = p - 1;
                            this.lastDelimiterPosition = p;
                            this.start = p + 1;
                            this.state = State.EOR;
                            this.startedQuote = false;
                            return true;
                        }
                    } else if (ch == '\r') {
                        if (!this.startedQuote) {
                            this.fStart = this.start;
                            this.fEnd = p;
                            this.start = p + 1;
                            this.state = State.CR;
                            this.lastDelimiterPosition = p;
                            return true;
                        }
                        if (this.startedQuote && this.lastQuotePosition == p - 1 && this.lastDoubleQuotePosition != p - 1 && this.quoteCount == this.doubleQuoteCount * 2 + 2) {
                            this.fStart = this.start + 1;
                            this.fEnd = p - 1;
                            this.lastDelimiterPosition = p;
                            this.start = p + 1;
                            this.state = State.CR;
                            this.startedQuote = false;
                            return true;
                        }
                    }
                    ++p;
                }
            }
        }
        throw new IllegalStateException();
    }

    protected boolean readMore() throws IOException {
        int n;
        if (this.start > 0) {
            System.arraycopy(this.buffer, this.start, this.buffer, 0, this.end - this.start);
        }
        this.end -= this.start;
        this.start = 0;
        if (this.end == this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + 4096);
        }
        if ((n = this.in.read(this.buffer, this.end, this.buffer.length - this.end)) < 0) {
            return false;
        }
        this.end += n;
        return true;
    }

    public void eliminateDoubleQuote(char[] buffer, int start, int length) {
        int lastDoubleQuotePosition = -99;
        int writepos = start;
        int readpos = start;
        for (int i = 0; i < length; ++i) {
            if (buffer[readpos] == this.quote && lastDoubleQuotePosition != readpos - 1) {
                lastDoubleQuotePosition = readpos++;
                continue;
            }
            if (writepos != readpos) {
                buffer[writepos] = buffer[readpos];
            }
            ++writepos;
            ++readpos;
        }
    }

    private static enum State {
        INIT,
        IN_RECORD,
        EOR,
        CR,
        EOF;

    }
}

