/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.freepage;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrameFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class LinkedMetaDataPageManager
implements IMetadataPageManager {
    private final IBufferCache bufferCache;
    private int fileId = -1;
    private final ITreeIndexMetadataFrameFactory frameFactory;
    private boolean ready = false;

    public LinkedMetaDataPageManager(IBufferCache bufferCache, ITreeIndexMetadataFrameFactory frameFactory) {
        this.bufferCache = bufferCache;
        this.frameFactory = frameFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePage(ITreeIndexMetadataFrame metaFrame, int freePageNum) throws HyracksDataException {
        block8: {
            ICachedPage metaPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.getMetadataPageId()), false);
            metaPage.acquireWriteLatch();
            try {
                metaFrame.setPage(metaPage);
                if (metaFrame.getSpace() > 4) {
                    metaFrame.addFreePage(freePageNum);
                    break block8;
                }
                int newPageNum = metaFrame.getFreePage();
                if (newPageNum < 0) {
                    throw new HyracksDataException("Inconsistent Meta Page State. It has no space, but it also has no entries.");
                }
                ICachedPage newNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)newPageNum), false);
                newNode.acquireWriteLatch();
                try {
                    int metaMaxPage = metaFrame.getMaxPage();
                    System.arraycopy(metaPage.getBuffer().array(), 0, newNode.getBuffer().array(), 0, metaPage.getBuffer().capacity());
                    metaFrame.init();
                    metaFrame.setNextMetadataPage(newPageNum);
                    metaFrame.setMaxPage(metaMaxPage);
                    metaFrame.addFreePage(freePageNum);
                }
                finally {
                    newNode.releaseWriteLatch(true);
                    this.bufferCache.unpin(newNode);
                }
            }
            finally {
                metaPage.releaseWriteLatch(true);
                this.bufferCache.unpin(metaPage);
            }
        }
    }

    @Override
    public void releaseBlock(ITreeIndexMetadataFrame metaFrame, int startingPage, int count) throws HyracksDataException {
        for (int i = 0; i < count; ++i) {
            this.releasePage(metaFrame, startingPage + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int takePage(ITreeIndexMetadataFrame metaFrame) throws HyracksDataException {
        int freePage;
        block9: {
            ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.getMetadataPageId()), false);
            metaNode.acquireWriteLatch();
            freePage = -1;
            try {
                metaFrame.setPage(metaNode);
                freePage = metaFrame.getFreePage();
                if (freePage >= 0) break block9;
                int nextPage = metaFrame.getNextMetadataPage();
                if (nextPage > 0) {
                    ICachedPage nextNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)nextPage), false);
                    nextNode.acquireWriteLatch();
                    try {
                        int maxPage = metaFrame.getMaxPage();
                        System.arraycopy(nextNode.getBuffer().array(), 0, metaNode.getBuffer().array(), 0, nextNode.getBuffer().capacity());
                        metaFrame.setMaxPage(maxPage);
                        freePage = metaFrame.getFreePage();
                        if (freePage < 0) {
                            freePage = nextPage;
                        } else {
                            metaFrame.addFreePage(nextPage);
                        }
                        break block9;
                    }
                    finally {
                        nextNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(nextNode);
                    }
                }
                freePage = metaFrame.getMaxPage();
                metaFrame.setMaxPage(++freePage);
            }
            finally {
                metaNode.releaseWriteLatch(true);
                this.bufferCache.unpin(metaNode);
            }
        }
        return freePage;
    }

    @Override
    public int takeBlock(ITreeIndexMetadataFrame metaFrame, int count) throws HyracksDataException {
        int maxPage = metaFrame.getMaxPage();
        metaFrame.setMaxPage(maxPage + count);
        return maxPage + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxPageId(ITreeIndexMetadataFrame metaFrame) throws HyracksDataException {
        int mdPage = this.getMetadataPageId();
        if (mdPage < 0) {
            return -1;
        }
        ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)mdPage), false);
        metaNode.acquireReadLatch();
        int maxPage = -1;
        try {
            metaFrame.setPage(metaNode);
            maxPage = metaFrame.getMaxPage();
        }
        finally {
            metaNode.releaseReadLatch();
            this.bufferCache.unpin(metaNode);
        }
        return maxPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory) throws HyracksDataException {
        ITreeIndexMetadataFrame metaFrame = this.createMetadataFrame();
        int metaPage = this.getMetadataPageId();
        if (metaPage == -1) {
            throw new HyracksDataException("No valid metadata found in this file.");
        }
        ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.getMetadataPageId()), true);
        metaNode.acquireWriteLatch();
        try {
            metaFrame.setPage(metaNode);
            metaFrame.init();
            metaFrame.setRootPageId(1);
            metaFrame.setMaxPage(1);
        }
        finally {
            metaNode.releaseWriteLatch(true);
            this.bufferCache.flush(metaNode);
            this.bufferCache.unpin(metaNode);
        }
        int rootPage = this.getRootPageId();
        ICachedPage rootNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)rootPage), true);
        rootNode.acquireWriteLatch();
        try {
            ITreeIndexFrame leafFrame = leafFrameFactory.createFrame();
            leafFrame.setPage(rootNode);
            leafFrame.initBuffer((byte)0);
        }
        finally {
            rootNode.releaseWriteLatch(true);
            this.bufferCache.flush(rootNode);
            this.bufferCache.unpin(rootNode);
        }
    }

    @Override
    public ITreeIndexMetadataFrame createMetadataFrame() {
        return this.frameFactory.createFrame();
    }

    @Override
    public void open(int fileId) {
        this.fileId = fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRootPageId(int rootPage) throws HyracksDataException {
        ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.getMetadataPageId()), false);
        ITreeIndexMetadataFrame metaFrame = this.frameFactory.createFrame();
        metaNode.acquireWriteLatch();
        try {
            metaFrame.setPage(metaNode);
            metaFrame.setRootPageId(rootPage);
        }
        finally {
            metaNode.releaseWriteLatch(true);
            this.bufferCache.unpin(metaNode);
            this.ready = true;
        }
    }

    @Override
    public void close() throws HyracksDataException {
        if (this.ready) {
            ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.getMetadataPageId()), false);
            ITreeIndexMetadataFrame metaFrame = this.frameFactory.createFrame();
            metaNode.acquireWriteLatch();
            try {
                metaFrame.setPage(metaNode);
                metaFrame.setValid(true);
            }
            finally {
                metaNode.releaseWriteLatch(true);
                this.bufferCache.flush(metaNode);
                this.bufferCache.unpin(metaNode);
                this.ready = true;
            }
            this.ready = false;
        }
    }

    @Override
    public int getMetadataPageId() throws HyracksDataException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRootPageId() throws HyracksDataException {
        ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.getMetadataPageId()), false);
        ITreeIndexMetadataFrame metaFrame = this.frameFactory.createFrame();
        metaNode.acquireReadLatch();
        try {
            metaFrame.setPage(metaNode);
            int n = metaFrame.getRootPageId();
            return n;
        }
        finally {
            metaNode.releaseReadLatch();
            this.bufferCache.unpin(metaNode);
        }
    }

    @Override
    public int getBulkLoadLeaf() throws HyracksDataException {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(ITreeIndexFrame frame, int rootPage) throws HyracksDataException {
        ICachedPage rootNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)rootPage), false);
        rootNode.acquireReadLatch();
        try {
            frame.setPage(rootNode);
            boolean bl = frame.getLevel() == 0 && frame.getTupleCount() == 0;
            return bl;
        }
        finally {
            rootNode.releaseReadLatch();
            this.bufferCache.unpin(rootNode);
        }
    }

    @Override
    public void put(ITreeIndexMetadataFrame frame, IValueReference key, IValueReference value) throws HyracksDataException {
        throw new HyracksDataException("Unsupported Operation");
    }

    @Override
    public void get(ITreeIndexMetadataFrame frame, IValueReference key, IPointable value) throws HyracksDataException {
        throw new HyracksDataException("Unsupported Operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileOffset(ITreeIndexMetadataFrame frame, IValueReference key) throws HyracksDataException {
        int metadataPageNum = this.getMetadataPageId();
        if (metadataPageNum != -1) {
            ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.getMetadataPageId()), false);
            metaNode.acquireReadLatch();
            try {
                frame.setPage(metaNode);
                long l = (long)metadataPageNum * (long)this.bufferCache.getPageSizeWithHeader() + (long)frame.getOffset(key);
                return l;
            }
            finally {
                metaNode.releaseReadLatch();
                this.bufferCache.unpin(metaNode);
            }
        }
        return -1L;
    }
}

