/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.lang.common.util.MergePolicyUtils;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class CreateFeedStatement
implements Statement {
    private final Pair<Identifier, Identifier> qName;
    private final boolean ifNotExists;
    private final AdmObjectNode withObjectNode;

    public CreateFeedStatement(Pair<Identifier, Identifier> qName, RecordConstructor withRecord, boolean ifNotExists) throws AlgebricksException {
        this.qName = qName;
        this.ifNotExists = ifNotExists;
        this.withObjectNode = withRecord == null ? null : ExpressionUtils.toNode(withRecord);
    }

    public Identifier getDataverseName() {
        return (Identifier)this.qName.first;
    }

    public Identifier getFeedName() {
        return (Identifier)this.qName.second;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_FEED;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 4;
    }

    public Map<String, String> getConfiguration() throws CompilationException {
        return MergePolicyUtils.toProperties(this.withObjectNode);
    }

    public AdmObjectNode getWithObjectNode() {
        return this.withObjectNode;
    }
}

