/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IDataParserFactory;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IRecordDataParserFactory;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.record.converter.IRecordConverterFactory;

public class ExternalDataCompatibilityUtils {
    public static void validateCompatibility(IExternalDataSourceFactory dataSourceFactory, IDataParserFactory dataParserFactory) throws AsterixException {
        if (dataSourceFactory.getDataSourceType() != dataParserFactory.getDataSourceType()) {
            throw new AsterixException("datasource-parser mismatch. datasource produces " + (Object)((Object)dataSourceFactory.getDataSourceType()) + " and parser expects " + (Object)((Object)dataParserFactory.getDataSourceType()));
        }
        if (dataSourceFactory.getDataSourceType() == IExternalDataSourceFactory.DataSourceType.RECORDS) {
            IRecordReaderFactory recordReaderFactory = (IRecordReaderFactory)dataSourceFactory;
            IRecordDataParserFactory recordParserFactory = (IRecordDataParserFactory)dataParserFactory;
            if (!recordParserFactory.getRecordClass().isAssignableFrom(recordReaderFactory.getRecordClass())) {
                throw new AsterixException("datasource-parser mismatch. datasource produces records of type " + recordReaderFactory.getRecordClass() + " and parser expects records of type " + recordParserFactory.getRecordClass());
            }
        }
    }

    public static void validateCompatibility(IRecordDataParserFactory recordParserFactory, IRecordConverterFactory converterFactory) throws AsterixException {
        if (!recordParserFactory.getRecordClass().isAssignableFrom(converterFactory.getOutputClass())) {
            throw new AsterixException("datasource converter-record parser mismatch. converter produces records of type " + converterFactory.getOutputClass() + " and parser expects records of type " + recordParserFactory.getRecordClass());
        }
    }

    public static void prepare(String adapterName, Map<String, String> configuration) {
        if (!configuration.containsKey("reader")) {
            configuration.put("reader", adapterName);
        }
        if (!configuration.containsKey("parser") && configuration.containsKey("format")) {
            configuration.put("parser", configuration.get("format"));
        }
    }
}

