/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.api.IDataParserFactory;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.commons.io.IOUtils;

public class ParserFactoryProvider {
    private static final String RESOURCE = "META-INF/services/org.apache.asterix.external.api.IDataParserFactory";
    private static Map<String, Class> factories = null;

    private ParserFactoryProvider() {
    }

    public static IDataParserFactory getDataParserFactory(ILibraryManager libraryManager, Map<String, String> configuration) throws AsterixException {
        String parserFactoryName = configuration.get("parser");
        if (parserFactoryName != null && ExternalDataUtils.isExternal(parserFactoryName)) {
            return ExternalDataUtils.createExternalParserFactory(libraryManager, ExternalDataUtils.getDataverse(configuration), parserFactoryName);
        }
        String parserFactoryKey = ExternalDataUtils.getRecordFormat(configuration);
        if (parserFactoryKey == null) {
            parserFactoryKey = configuration.get("parser-factory");
        }
        IDataParserFactory parserFactory = ParserFactoryProvider.getDataParserFactory(parserFactoryKey);
        return parserFactory;
    }

    protected static IDataParserFactory getInstance(Class clazz) throws AsterixException {
        try {
            return (IDataParserFactory)clazz.newInstance();
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Cannot create: " + clazz.getSimpleName(), (Throwable)e);
        }
    }

    public static IDataParserFactory getDataParserFactory(String parser) throws AsterixException {
        if (factories == null) {
            factories = ParserFactoryProvider.initFactories();
        }
        if (factories.containsKey(parser)) {
            return ParserFactoryProvider.getInstance(factories.get(parser));
        }
        try {
            return (IDataParserFactory)Class.forName(parser).newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Unknown format: " + parser, (Throwable)e);
        }
    }

    protected static Map<String, Class> initFactories() throws AsterixException {
        HashMap<String, Class> factories = new HashMap<String, Class>();
        ClassLoader cl = ParserFactoryProvider.class.getClassLoader();
        try {
            Enumeration<URL> urls = cl.getResources(RESOURCE);
            for (URL url : Collections.list(urls)) {
                List classNames;
                try (InputStream is = url.openStream();){
                    classNames = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
                }
                for (String className : classNames) {
                    if (className.startsWith("#")) continue;
                    Class<?> clazz = Class.forName(className);
                    List<String> formats = ((IDataParserFactory)clazz.newInstance()).getParserFormats();
                    for (String format : formats) {
                        if (factories.containsKey(format)) {
                            throw new AsterixException("Duplicate format " + format);
                        }
                        factories.put(format, clazz);
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException((Throwable)e);
        }
        return factories;
    }
}

