/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.asterix.builders.AbvsBuilderFactory;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.ListBuilderFactory;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilderFactory;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.parser.AbstractDataParser;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class TweetParser
extends AbstractDataParser
implements IRecordDataParser<String> {
    private final IObjectPool<IARecordBuilder, ATypeTag> recordBuilderPool = new ListObjectPool((IObjectFactory)new RecordBuilderFactory());
    private final IObjectPool<IAsterixListBuilder, ATypeTag> listBuilderPool = new ListObjectPool((IObjectFactory)new ListBuilderFactory());
    private final IObjectPool<IMutableValueStorage, ATypeTag> abvsBuilderPool = new ListObjectPool((IObjectFactory)new AbvsBuilderFactory());
    private ARecordType recordType;
    private UTF8StringWriter utf8Writer = new UTF8StringWriter();

    public TweetParser(ARecordType recordType) {
        this.recordType = recordType;
    }

    private void parseArrayList(JsonNode jArray, DataOutput output) throws IOException {
        ArrayBackedValueStorage itemBuffer = this.getTempBuffer();
        OrderedListBuilder arrayBuilder = (OrderedListBuilder)this.getArrayBuilder();
        arrayBuilder.reset(null);
        for (int iter1 = 0; iter1 < jArray.size(); ++iter1) {
            itemBuffer.reset();
            if (!this.writeField(jArray.get(iter1), null, itemBuffer.getDataOutput())) continue;
            arrayBuilder.addItem((IValueReference)itemBuffer);
        }
        arrayBuilder.write(output, true);
    }

    private boolean writeField(JsonNode fieldObj, IAType originalFieldType, DataOutput out) throws IOException {
        boolean writeResult = true;
        IAType fieldType = originalFieldType;
        if (originalFieldType instanceof AUnionType) {
            fieldType = ((AUnionType)originalFieldType).getActualType();
        }
        if (fieldType != null) {
            switch (fieldType.getTypeTag()) {
                case STRING: {
                    out.write(BuiltinType.ASTRING.getTypeTag().serialize());
                    this.utf8Writer.writeUTF8((CharSequence)fieldObj.asText(), out);
                    break;
                }
                case BIGINT: {
                    this.aInt64.setValue(fieldObj.asLong());
                    this.int64Serde.serialize((Object)this.aInt64, out);
                    break;
                }
                case INTEGER: {
                    out.write(BuiltinType.AINT32.getTypeTag().serialize());
                    out.writeInt(fieldObj.asInt());
                    break;
                }
                case DOUBLE: {
                    out.write(BuiltinType.ADOUBLE.getTypeTag().serialize());
                    out.writeDouble(fieldObj.asDouble());
                    break;
                }
                case BOOLEAN: {
                    out.write(BuiltinType.ABOOLEAN.getTypeTag().serialize());
                    out.writeBoolean(fieldObj.asBoolean());
                    break;
                }
                case OBJECT: {
                    this.writeRecord(fieldObj, out, (ARecordType)fieldType);
                    break;
                }
                case ARRAY: {
                    this.parseArrayList(fieldObj, out);
                    break;
                }
                default: {
                    writeResult = false;
                    break;
                }
            }
        } else if (fieldObj.isNull()) {
            this.nullSerde.serialize((Object)ANull.NULL, out);
        } else if (fieldObj.isInt()) {
            out.write(BuiltinType.AINT32.getTypeTag().serialize());
            out.writeInt(fieldObj.asInt());
        } else if (fieldObj.isBoolean()) {
            out.write(BuiltinType.ABOOLEAN.getTypeTag().serialize());
            out.writeBoolean(fieldObj.asBoolean());
        } else if (fieldObj.isDouble()) {
            out.write(BuiltinType.ADOUBLE.getTypeTag().serialize());
            out.writeDouble(fieldObj.asDouble());
        } else if (fieldObj.isLong()) {
            out.write(BuiltinType.AINT64.getTypeTag().serialize());
            out.writeLong(fieldObj.asLong());
        } else if (fieldObj.isTextual()) {
            out.write(BuiltinType.ASTRING.getTypeTag().serialize());
            this.utf8Writer.writeUTF8((CharSequence)fieldObj.asText(), out);
        } else if (fieldObj.isArray()) {
            if (fieldObj.size() != 0) {
                this.parseArrayList(fieldObj, out);
            } else {
                writeResult = false;
            }
        } else if (fieldObj.isObject()) {
            if (fieldObj.size() != 0) {
                this.writeRecord(fieldObj, out, null);
            } else {
                writeResult = false;
            }
        }
        return writeResult;
    }

    private int checkAttrNameIdx(String[] nameList, String name) {
        int idx = 0;
        if (nameList != null) {
            for (String nln : nameList) {
                if (name.equals(nln)) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    public void writeRecord(JsonNode obj, DataOutput out, ARecordType curRecType) throws IOException {
        IAType[] curTypes = null;
        String[] curFNames = null;
        int expectedFieldsCount = 0;
        ArrayBackedValueStorage fieldValueBuffer = this.getTempBuffer();
        ArrayBackedValueStorage fieldNameBuffer = this.getTempBuffer();
        IARecordBuilder recBuilder = this.getRecordBuilder();
        if (curRecType != null) {
            curTypes = curRecType.getFieldTypes();
            curFNames = curRecType.getFieldNames();
            for (IAType curType : curTypes) {
                if (curType instanceof AUnionType) continue;
                ++expectedFieldsCount;
            }
        }
        recBuilder.reset(curRecType);
        recBuilder.init();
        if (curRecType != null && !curRecType.isOpen()) {
            int fieldN = curFNames.length;
            for (int iter1 = 0; iter1 < fieldN; ++iter1) {
                fieldValueBuffer.reset();
                DataOutput fieldOutput = fieldValueBuffer.getDataOutput();
                if (obj.get(curFNames[iter1]).isNull() && !(curTypes[iter1] instanceof AUnionType)) {
                    if (!curRecType.isClosedField(curFNames[iter1])) continue;
                    throw new RuntimeDataException(3075, new Serializable[]{curFNames[iter1]});
                }
                if (!this.writeField(obj.get(curFNames[iter1]), curTypes[iter1], fieldOutput)) continue;
                recBuilder.addField(iter1, (IValueReference)fieldValueBuffer);
            }
        } else {
            int closedFieldCount = 0;
            IAType curFieldType = null;
            Iterator iter = obj.fieldNames();
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                if (obj.get(attrName) == null || obj.get(attrName).isNull() || obj.size() == 0) continue;
                int attrIdx = this.checkAttrNameIdx(curFNames, attrName);
                if (curRecType != null) {
                    curFieldType = curRecType.getFieldType(attrName);
                }
                fieldValueBuffer.reset();
                fieldNameBuffer.reset();
                DataOutput fieldOutput = fieldValueBuffer.getDataOutput();
                if (!this.writeField(obj.get(attrName), curFieldType, fieldOutput)) continue;
                if (attrIdx == -1) {
                    this.aString.setValue(attrName);
                    this.stringSerde.serialize((Object)this.aString, fieldNameBuffer.getDataOutput());
                    recBuilder.addField((IValueReference)fieldNameBuffer, (IValueReference)fieldValueBuffer);
                    continue;
                }
                recBuilder.addField(attrIdx, (IValueReference)fieldValueBuffer);
                ++closedFieldCount;
            }
            if (curRecType != null && closedFieldCount < expectedFieldsCount) {
                throw new HyracksDataException("Non-null field is null");
            }
        }
        recBuilder.write(out, true);
    }

    private IARecordBuilder getRecordBuilder() {
        return (IARecordBuilder)this.recordBuilderPool.allocate((Object)ATypeTag.OBJECT);
    }

    private IAsterixListBuilder getArrayBuilder() {
        return (IAsterixListBuilder)this.listBuilderPool.allocate((Object)ATypeTag.ARRAY);
    }

    private ArrayBackedValueStorage getTempBuffer() {
        return (ArrayBackedValueStorage)this.abvsBuilderPool.allocate((Object)ATypeTag.BINARY);
    }

    @Override
    public void parse(IRawRecord<? extends String> record, DataOutput out) throws HyracksDataException {
        try {
            this.resetPools();
            ObjectMapper om = new ObjectMapper();
            this.writeRecord(om.readTree(record.get()), out, this.recordType);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void resetPools() {
        this.listBuilderPool.reset();
        this.recordBuilderPool.reset();
        this.abvsBuilderPool.reset();
    }
}

