/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import com.rometools.rome.feed.synd.SyndEntry;
import java.io.DataOutput;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.external.api.IDataParser;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.om.base.AMutableRecord;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class RSSParser
implements IRecordDataParser<SyndEntry> {
    private long id = 0L;
    private AMutableString[] mutableFields;
    private String[] tupleFieldValues;
    private AMutableRecord mutableRecord;
    private RecordBuilder recordBuilder = new RecordBuilder();
    private int numFields;

    public RSSParser(ARecordType recordType) {
        this.mutableFields = new AMutableString[]{new AMutableString(null), new AMutableString(null), new AMutableString(null), new AMutableString(null)};
        this.mutableRecord = new AMutableRecord(recordType, (IAObject[])this.mutableFields);
        this.tupleFieldValues = new String[recordType.getFieldNames().length];
        this.numFields = recordType.getFieldNames().length;
    }

    @Override
    public void parse(IRawRecord<? extends SyndEntry> record, DataOutput out) throws HyracksDataException {
        SyndEntry entry = record.get();
        this.tupleFieldValues[0] = String.valueOf(this.id);
        this.tupleFieldValues[1] = entry.getTitle();
        this.tupleFieldValues[2] = entry.getDescription().getValue();
        this.tupleFieldValues[3] = entry.getLink();
        for (int i = 0; i < this.numFields; ++i) {
            this.mutableFields[i].setValue(this.tupleFieldValues[i]);
            this.mutableRecord.setValueAtPos(i, (IAObject)this.mutableFields[i]);
        }
        this.recordBuilder.reset(this.mutableRecord.getType());
        this.recordBuilder.init();
        IDataParser.writeRecord(this.mutableRecord, out, (IARecordBuilder)this.recordBuilder);
        ++this.id;
    }
}

