/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.ActiveSourceOperatorNodePushable;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.dataset.adapter.FeedAdapter;
import org.apache.asterix.external.operators.FeedIntakeOperatorDescriptor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeedIntakeOperatorNodePushable
extends ActiveSourceOperatorNodePushable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int DEFAULT_ABORT_TIMEOUT = 60000;
    private final FeedIntakeOperatorDescriptor opDesc;
    private final FeedAdapter adapter;
    private boolean poisoned = false;

    public FeedIntakeOperatorNodePushable(IHyracksTaskContext ctx, EntityId feedId, IAdapterFactory adapterFactory, int partition, IRecordDescriptorProvider recordDescProvider, FeedIntakeOperatorDescriptor feedIntakeOperatorDescriptor) throws HyracksDataException {
        super(ctx, new ActiveRuntimeId(feedId, FeedIntakeOperatorNodePushable.class.getSimpleName(), partition));
        this.opDesc = feedIntakeOperatorDescriptor;
        this.recordDesc = recordDescProvider.getOutputRecordDescriptor(this.opDesc.getActivityId(), 0);
        this.adapter = (FeedAdapter)adapterFactory.createAdapter(ctx, this.runtimeId.getPartition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void start() throws HyracksDataException, InterruptedException {
        Throwable failure = null;
        Thread.currentThread().setName("Intake Thread");
        try {
            this.writer.open();
            FeedIntakeOperatorNodePushable feedIntakeOperatorNodePushable = this;
            synchronized (feedIntakeOperatorNodePushable) {
                if (this.poisoned) {
                    return;
                }
            }
            VSizeFrame message = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
            TaskUtil.put((String)"HYX:MSG", (Object)message, (IHyracksTaskContext)this.ctx);
            message.getBuffer().put((byte)1);
            message.getBuffer().flip();
            this.run();
        }
        catch (Throwable e) {
            failure = e;
            CleanupUtils.fail((IFrameWriter)this.writer, (Throwable)e);
            LOGGER.log(Level.WARN, "Failure during data ingestion", e);
        }
        finally {
            failure = CleanupUtils.close((AutoCloseable)this.adapter, (Throwable)failure);
            failure = CleanupUtils.close((IFrameWriter)this.writer, (Throwable)failure);
        }
        if (failure == null) return;
        throw HyracksDataException.create((Throwable)failure);
    }

    private void run() throws HyracksDataException {
        LOGGER.info("Starting ingestion for partition:" + this.ctx.getTaskAttemptId().getTaskId().getPartition());
        try {
            this.doRun();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw HyracksDataException.create((Throwable)e);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Unhandled Exception", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void doRun() throws HyracksDataException, InterruptedException {
        try {
            this.adapter.start(this.ctx.getTaskAttemptId().getTaskId().getPartition(), this.writer);
            return;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Exception during feed ingestion ", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abort() throws HyracksDataException, InterruptedException {
        LOGGER.info(this.runtimeId + " aborting...");
        FeedIntakeOperatorNodePushable feedIntakeOperatorNodePushable = this;
        synchronized (feedIntakeOperatorNodePushable) {
            this.poisoned = true;
            try {
                if (!this.adapter.stop(60000L)) {
                    LOGGER.info(this.runtimeId + " failed to stop adapter. interrupting the thread...");
                    this.taskThread.interrupt();
                }
            }
            catch (HyracksDataException hde) {
                if (hde.getComponent() == "HYR" && hde.getErrorCode() == 91) {
                    LOGGER.log(Level.WARN, this.runtimeId + " stop adapter timed out. interrupting the thread...", (Throwable)hde);
                    this.taskThread.interrupt();
                }
                LOGGER.log(Level.WARN, "Failure during attempt to stop " + this.runtimeId, (Throwable)hde);
                throw hde;
            }
        }
    }

    public String getStats() {
        if (this.adapter != null) {
            return "{\"adapter-stats\": " + this.adapter.getStats() + "}";
        }
        return "\"Runtime stats is not available.\"";
    }
}

