/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.util.List;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.FileIndexTupleTranslator;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IIndexBuilder;
import org.apache.hyracks.storage.am.common.api.IIndexBuilderFactory;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexBulkLoader;

public class ExternalFilesIndexCreateOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private List<ExternalFile> files;
    private IIndexDataflowHelperFactory dataflowHelperFactory;
    private IIndexBuilderFactory indexBuilderFactory;

    public ExternalFilesIndexCreateOperatorDescriptor(IOperatorDescriptorRegistry spec, IIndexBuilderFactory indexBuilderFactory, IIndexDataflowHelperFactory dataflowHelperFactory, List<ExternalFile> files) {
        super(spec, 0, 0);
        this.indexBuilderFactory = indexBuilderFactory;
        this.dataflowHelperFactory = dataflowHelperFactory;
        this.files = files;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
        return new AbstractOperatorNodePushable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void initialize() throws HyracksDataException {
                IIndexBuilder indexBuilder = ExternalFilesIndexCreateOperatorDescriptor.this.indexBuilderFactory.create(ctx, partition);
                IIndexDataflowHelper indexHelper = ExternalFilesIndexCreateOperatorDescriptor.this.dataflowHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
                FileIndexTupleTranslator filesTupleTranslator = new FileIndexTupleTranslator();
                indexBuilder.build();
                indexHelper.open();
                try {
                    IIndex index = indexHelper.getIndexInstance();
                    IIndexBulkLoader bulkLoader = index.createBulkLoader(0.7f, false, (long)ExternalFilesIndexCreateOperatorDescriptor.this.files.size(), false);
                    for (ExternalFile file : ExternalFilesIndexCreateOperatorDescriptor.this.files) {
                        bulkLoader.add(filesTupleTranslator.getTupleFromFile(file));
                    }
                    bulkLoader.end();
                }
                finally {
                    indexHelper.close();
                }
            }

            public void deinitialize() throws HyracksDataException {
            }

            public int getInputArity() {
                return 0;
            }

            public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) throws HyracksDataException {
            }

            public IFrameWriter getInputFrameWriter(int index) {
                return null;
            }
        };
    }
}

