/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.twitter;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.input.record.GenericRecord;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;

public class TwitterPullRecordReader
implements IRecordReader<String> {
    private Query query;
    private Twitter twitter;
    private int requestInterval = 5;
    private QueryResult result;
    private int nextTweetIndex = 0;
    private long lastTweetIdReceived = 0L;
    private GenericRecord<String> record;
    private boolean stopped = false;

    public TwitterPullRecordReader(Twitter twitter, String keywords, int requestInterval) {
        this.twitter = twitter;
        this.requestInterval = requestInterval;
        this.query = new Query(keywords);
        this.query.setCount(100);
        this.record = new GenericRecord();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.stopped;
    }

    @Override
    public IRawRecord<String> next() throws IOException, InterruptedException {
        if (this.result == null || this.nextTweetIndex >= this.result.getTweets().size()) {
            Thread.sleep(1000 * this.requestInterval);
            this.query.setSinceId(this.lastTweetIdReceived);
            try {
                this.result = this.twitter.search(this.query);
            }
            catch (TwitterException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            this.nextTweetIndex = 0;
        }
        if (this.result != null && !this.result.getTweets().isEmpty()) {
            List tw = this.result.getTweets();
            Status tweet = (Status)tw.get(this.nextTweetIndex++);
            if (this.lastTweetIdReceived < tweet.getId()) {
                this.lastTweetIdReceived = tweet.getId();
            }
            String jsonTweet = TwitterObjectFactory.getRawJSON((Object)tweet);
            this.record.set(jsonTweet);
            return this.record;
        }
        return null;
    }

    @Override
    public boolean stop() {
        this.stopped = true;
        return true;
    }

    @Override
    public void setFeedLogManager(FeedLogManager feedLogManager) {
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }
}

