/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IStreamNotificationHandler;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.asterix.external.input.stream.AsterixInputStreamReader;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class StreamRecordReader
implements IRecordReader<char[]>,
IStreamNotificationHandler {
    protected AsterixInputStreamReader reader;
    protected CharArrayRecord record;
    protected char[] inputBuffer;
    protected int bufferLength = 0;
    protected int bufferPosn = 0;
    protected boolean done = false;
    protected FeedLogManager feedLogManager;

    public void configure(AsterixInputStream inputStream) {
        this.reader = new AsterixInputStreamReader(inputStream);
        this.record = new CharArrayRecord();
        this.inputBuffer = new char[4096];
    }

    @Override
    public IRawRecord<char[]> next() throws IOException {
        return this.record;
    }

    @Override
    public void close() throws IOException {
        if (!this.done) {
            this.reader.close();
        }
        this.done = true;
    }

    @Override
    public boolean stop() {
        try {
            this.reader.stop();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public abstract boolean hasNext() throws IOException;

    @Override
    public void setFeedLogManager(FeedLogManager feedLogManager) throws HyracksDataException {
        this.feedLogManager = feedLogManager;
        this.reader.setFeedLogManager(feedLogManager);
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
        this.reader.setController(controller);
    }

    @Override
    public boolean handleException(Throwable th) {
        return this.reader.handleException(th);
    }

    @Override
    public void notifyNewSource() {
        throw new UnsupportedOperationException();
    }

    public abstract List<String> getRecordReaderFormats();

    public abstract String getRequiredConfigs();

    public abstract void configure(AsterixInputStream var1, Map<String, String> var2) throws HyracksDataException;
}

