/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.indexing;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hyracks.api.client.HyracksConnection;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexingScheduler {
    private static final Logger LOGGER = LogManager.getLogger();
    private String[] NCs;
    private Map<String, List<String>> ipToNcMapping = new HashMap<String, List<String>>();
    private Map<String, Integer> ncNameToIndex = new HashMap<String, Integer>();
    private Map<String, NodeControllerInfo> ncNameToNcInfos;

    public IndexingScheduler(String ipAddress, int port) throws HyracksException {
        try {
            HyracksConnection hcc = new HyracksConnection(ipAddress, port);
            this.ncNameToNcInfos = hcc.getNodeControllerInfos();
            this.loadIPAddressToNCMap(this.ncNameToNcInfos);
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    public String[] getLocationConstraints(InputSplit[] splits) throws HyracksException {
        if (splits == null) {
            return new String[0];
        }
        int[] workloads = new int[this.NCs.length];
        Arrays.fill(workloads, 0);
        String[] locations = new String[splits.length];
        HashMap<String, IntWritable> locationToNumOfSplits = new HashMap<String, IntWritable>();
        int upperBoundSlots = splits.length;
        try {
            Random random = new Random(System.currentTimeMillis());
            boolean[] scheduled = new boolean[splits.length];
            Arrays.fill(scheduled, false);
            this.buildPopularityMap(splits, locationToNumOfSplits);
            HashMap<String, Integer> locationToNumOfAssignement = new HashMap<String, Integer>();
            for (String location : locationToNumOfSplits.keySet()) {
                locationToNumOfAssignement.put(location, 0);
            }
            this.scheduleLocalSlots(splits, workloads, locations, upperBoundSlots, random, scheduled, locationToNumOfSplits, locationToNumOfAssignement);
            int dataLocalCount = 0;
            for (int i = 0; i < scheduled.length; ++i) {
                if (!scheduled[i]) continue;
                ++dataLocalCount;
            }
            LOGGER.info("Data local rate: " + (scheduled.length == 0 ? 0.0 : (double)((float)dataLocalCount / (float)scheduled.length)));
            locationToNumOfAssignement.clear();
            for (String nc : this.NCs) {
                locationToNumOfAssignement.put(nc, 0);
            }
            for (int i = 0; i < scheduled.length; ++i) {
                if (!scheduled[i]) continue;
                locationToNumOfAssignement.put(locations[i], locationToNumOfAssignement.get(locations[i]) + 1);
            }
            this.scheduleNonLocalSlots(splits, workloads, locations, upperBoundSlots, scheduled, locationToNumOfAssignement);
            return locations;
        }
        catch (IOException e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    private void scheduleNonLocalSlots(InputSplit[] splits, int[] workloads, String[] locations, int slotLimit, boolean[] scheduled, HashMap<String, Integer> locationToNumOfAssignement) throws IOException, UnknownHostException {
        PriorityQueue<String> scheduleCadndiates = new PriorityQueue<String>(this.NCs.length, Comparator.comparing(locationToNumOfAssignement::get));
        scheduleCadndiates.addAll(Arrays.asList(this.NCs));
        for (int i = 0; i < splits.length; ++i) {
            int ncIndex;
            String selectedNcName;
            if (scheduled[i] || (selectedNcName = (String)scheduleCadndiates.remove()) == null) continue;
            int n = ncIndex = this.ncNameToIndex.get(selectedNcName).intValue();
            workloads[n] = workloads[n] + 1;
            scheduled[i] = true;
            locations[i] = selectedNcName;
            locationToNumOfAssignement.put(selectedNcName, workloads[ncIndex]);
            scheduleCadndiates.add(selectedNcName);
        }
    }

    private void scheduleLocalSlots(InputSplit[] splits, int[] workloads, String[] locations, int slots, Random random, boolean[] scheduled, Map<String, IntWritable> locationToNumSplits, HashMap<String, Integer> locationToNumOfAssignement) throws IOException, UnknownHostException {
        PriorityQueue scheduleCadndiates = new PriorityQueue(3, (s1, s2) -> {
            int assignmentDifference = ((Integer)locationToNumOfAssignement.get(s1)).compareTo((Integer)locationToNumOfAssignement.get(s2));
            if (assignmentDifference != 0) {
                return assignmentDifference;
            }
            return ((IntWritable)locationToNumSplits.get(s1)).compareTo((IntWritable)locationToNumSplits.get(s2));
        });
        block0: for (int i = 0; i < splits.length; ++i) {
            String[] locs;
            if (scheduled[i] || (locs = splits[i].getLocations()).length <= 0) continue;
            scheduleCadndiates.clear();
            Collections.addAll(scheduleCadndiates, locs);
            for (String candidate : scheduleCadndiates) {
                InetAddress[] allIps;
                for (InetAddress ip : allIps = InetAddress.getAllByName(candidate)) {
                    int arrayPos;
                    List<String> dataLocations;
                    String nc;
                    int pos;
                    if (this.ipToNcMapping.get(ip.getHostAddress()) == null || workloads[pos = this.ncNameToIndex.get(nc = (dataLocations = this.ipToNcMapping.get(ip.getHostAddress())).get(arrayPos = random.nextInt(dataLocations.size()))).intValue()] >= slots) continue;
                    locations[i] = nc;
                    int n = pos;
                    workloads[n] = workloads[n] + 1;
                    scheduled[i] = true;
                    locationToNumOfAssignement.put(candidate, locationToNumOfAssignement.get(candidate) + 1);
                    break;
                }
                if (!scheduled[i]) continue;
                continue block0;
            }
        }
    }

    private void buildPopularityMap(InputSplit[] splits, Map<String, IntWritable> locationToNumOfSplits) throws IOException {
        for (InputSplit split : splits) {
            String[] locations;
            for (String loc : locations = split.getLocations()) {
                IntWritable locCount = locationToNumOfSplits.get(loc);
                if (locCount == null) {
                    locCount = new IntWritable(0);
                    locationToNumOfSplits.put(loc, locCount);
                }
                locCount.set(locCount.get() + 1);
            }
        }
    }

    private void loadIPAddressToNCMap(Map<String, NodeControllerInfo> ncNameToNcInfos) throws HyracksException {
        try {
            this.NCs = new String[ncNameToNcInfos.size()];
            this.ipToNcMapping.clear();
            this.ncNameToIndex.clear();
            int i = 0;
            for (Map.Entry<String, NodeControllerInfo> entry : ncNameToNcInfos.entrySet()) {
                String ipAddr = InetAddress.getByAddress(entry.getValue().getNetworkAddress().lookupIpAddress()).getHostAddress();
                List matchedNCs = this.ipToNcMapping.computeIfAbsent(ipAddr, k -> new ArrayList());
                matchedNCs.add(entry.getKey());
                this.NCs[i] = entry.getKey();
                ++i;
            }
            for (i = 0; i < this.NCs.length; ++i) {
                this.ncNameToIndex.put(this.NCs[i], i);
            }
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }
}

