/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.rewrites.VariableSubstitutionEnvironment;
import org.apache.asterix.lang.common.util.VariableCloneAndSubstitutionUtil;
import org.apache.asterix.lang.common.visitor.CloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class SqlppCloneAndSubstituteVariablesVisitor
extends CloneAndSubstituteVariablesVisitor
implements ISqlppVisitor<Pair<ILangExpression, VariableSubstitutionEnvironment>, VariableSubstitutionEnvironment> {
    private LangRewritingContext context;

    public SqlppCloneAndSubstituteVariablesVisitor(LangRewritingContext context) {
        super(context);
        this.context = context;
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(FromClause fromClause, VariableSubstitutionEnvironment env) throws CompilationException {
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        ArrayList<FromTerm> newFromTerms = new ArrayList<FromTerm>();
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            Pair<ILangExpression, VariableSubstitutionEnvironment> p = fromTerm.accept(this, currentEnv);
            newFromTerms.add((FromTerm)p.first);
            currentEnv = (VariableSubstitutionEnvironment)p.second;
        }
        return new Pair((Object)new FromClause(newFromTerms), (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(FromTerm fromTerm, VariableSubstitutionEnvironment env) throws CompilationException {
        VariableExpr leftVar = fromTerm.getLeftVariable();
        VariableExpr newLeftVar = this.generateNewVariable(this.context, leftVar);
        VariableExpr newLeftPosVar = fromTerm.hasPositionalVariable() ? this.generateNewVariable(this.context, fromTerm.getPositionalVariable()) : null;
        Expression newLeftExpr = (Expression)this.visitUnnesBindingExpression((Expression)fromTerm.getLeftExpression(), (VariableSubstitutionEnvironment)env).first;
        ArrayList<AbstractBinaryCorrelateClause> newCorrelateClauses = new ArrayList<AbstractBinaryCorrelateClause>();
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        currentEnv.removeSubstitution(newLeftVar);
        if (newLeftPosVar != null) {
            currentEnv.removeSubstitution(newLeftPosVar);
        }
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            if (correlateClause.getClauseType() == Clause.ClauseType.UNNEST_CLAUSE) {
                Pair p = (Pair)correlateClause.accept(this, currentEnv);
                currentEnv = (VariableSubstitutionEnvironment)p.second;
                newCorrelateClauses.add((AbstractBinaryCorrelateClause)p.first);
                continue;
            }
            newCorrelateClauses.add((AbstractBinaryCorrelateClause)((Pair)correlateClause.accept((ILangVisitor)this, (Object)env)).first);
            currentEnv.removeSubstitution(correlateClause.getRightVariable());
            if (!correlateClause.hasPositionalVariable()) continue;
            currentEnv.removeSubstitution(correlateClause.getPositionalVariable());
        }
        return new Pair((Object)new FromTerm(newLeftExpr, newLeftVar, newLeftPosVar, newCorrelateClauses), (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(JoinClause joinClause, VariableSubstitutionEnvironment env) throws CompilationException {
        VariableExpr rightVar = joinClause.getRightVariable();
        VariableExpr newRightVar = this.generateNewVariable(this.context, rightVar);
        VariableExpr newRightPosVar = joinClause.hasPositionalVariable() ? this.generateNewVariable(this.context, joinClause.getPositionalVariable()) : null;
        Expression newRightExpr = (Expression)this.visitUnnesBindingExpression((Expression)joinClause.getRightExpression(), (VariableSubstitutionEnvironment)env).first;
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        currentEnv.removeSubstitution(newRightVar);
        if (newRightPosVar != null) {
            currentEnv.removeSubstitution(newRightPosVar);
        }
        Expression conditionExpr = (Expression)((Pair)joinClause.getConditionExpression().accept((ILangVisitor)this, (Object)currentEnv)).first;
        JoinClause newJoinClause = new JoinClause(joinClause.getJoinType(), newRightExpr, newRightVar, newRightPosVar, conditionExpr);
        return new Pair((Object)newJoinClause, (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(NestClause nestClause, VariableSubstitutionEnvironment env) throws CompilationException {
        VariableExpr rightVar = nestClause.getRightVariable();
        VariableExpr newRightVar = this.generateNewVariable(this.context, rightVar);
        VariableExpr newRightPosVar = nestClause.hasPositionalVariable() ? this.generateNewVariable(this.context, nestClause.getPositionalVariable()) : null;
        Expression rightExpr = (Expression)((Pair)nestClause.getRightExpression().accept((ILangVisitor)this, (Object)env)).first;
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        currentEnv.removeSubstitution(newRightVar);
        if (newRightPosVar != null) {
            currentEnv.removeSubstitution(newRightPosVar);
        }
        Expression conditionExpr = (Expression)((Pair)nestClause.getConditionExpression().accept((ILangVisitor)this, (Object)currentEnv)).first;
        NestClause newJoinClause = new NestClause(nestClause.getJoinType(), rightExpr, newRightVar, newRightPosVar, conditionExpr);
        return new Pair((Object)newJoinClause, (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(UnnestClause unnestClause, VariableSubstitutionEnvironment env) throws CompilationException {
        VariableExpr rightVar = unnestClause.getRightVariable();
        VariableExpr newRightVar = this.generateNewVariable(this.context, rightVar);
        VariableExpr newRightPosVar = unnestClause.hasPositionalVariable() ? this.generateNewVariable(this.context, unnestClause.getPositionalVariable()) : null;
        Expression rightExpr = (Expression)this.visitUnnesBindingExpression((Expression)unnestClause.getRightExpression(), (VariableSubstitutionEnvironment)env).first;
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        currentEnv.removeSubstitution(newRightVar);
        if (newRightPosVar != null) {
            currentEnv.removeSubstitution(newRightPosVar);
        }
        UnnestClause newJoinClause = new UnnestClause(unnestClause.getJoinType(), rightExpr, newRightVar, newRightPosVar);
        return new Pair((Object)newJoinClause, (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(Projection projection, VariableSubstitutionEnvironment env) throws CompilationException {
        if (projection.star()) {
            return new Pair((Object)projection, (Object)env);
        }
        Projection newProjection = new Projection((Expression)((Pair)projection.getExpression().accept((ILangVisitor)this, (Object)env)).first, projection.getName(), projection.star(), projection.varStar());
        return new Pair((Object)newProjection, (Object)env);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectBlock selectBlock, VariableSubstitutionEnvironment env) throws CompilationException {
        Pair newLet;
        Pair<ILangExpression, VariableSubstitutionEnvironment> newFrom = null;
        Pair newWhere = null;
        Pair newGroupby = null;
        Pair<ILangExpression, VariableSubstitutionEnvironment> newHaving = null;
        ArrayList<LetClause> newLetClauses = new ArrayList<LetClause>();
        ArrayList<LetClause> newLetClausesAfterGby = new ArrayList<LetClause>();
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        if (selectBlock.hasFromClause()) {
            newFrom = selectBlock.getFromClause().accept(this, currentEnv);
            currentEnv = (VariableSubstitutionEnvironment)newFrom.second;
        }
        if (selectBlock.hasLetClauses()) {
            for (LetClause letClause : selectBlock.getLetList()) {
                newLet = (Pair)letClause.accept((ILangVisitor)this, (Object)currentEnv);
                currentEnv = (VariableSubstitutionEnvironment)newLet.second;
                newLetClauses.add((LetClause)newLet.first);
            }
        }
        if (selectBlock.hasWhereClause()) {
            newWhere = (Pair)selectBlock.getWhereClause().accept((ILangVisitor)this, (Object)currentEnv);
            currentEnv = (VariableSubstitutionEnvironment)newWhere.second;
        }
        if (selectBlock.hasGroupbyClause()) {
            newGroupby = (Pair)selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)currentEnv);
            currentEnv = (VariableSubstitutionEnvironment)newGroupby.second;
            if (selectBlock.hasLetClausesAfterGroupby()) {
                for (LetClause letClauseAfterGby : selectBlock.getLetListAfterGroupby()) {
                    newLet = (Pair)letClauseAfterGby.accept((ILangVisitor)this, (Object)currentEnv);
                    currentEnv = (VariableSubstitutionEnvironment)newLet.second;
                    newLetClausesAfterGby.add(letClauseAfterGby);
                }
            }
        }
        if (selectBlock.hasHavingClause()) {
            newHaving = selectBlock.getHavingClause().accept(this, currentEnv);
            currentEnv = (VariableSubstitutionEnvironment)newHaving.second;
        }
        Pair<ILangExpression, VariableSubstitutionEnvironment> newSelect = selectBlock.getSelectClause().accept(this, currentEnv);
        currentEnv = (VariableSubstitutionEnvironment)newSelect.second;
        FromClause fromClause = newFrom == null ? null : (FromClause)newFrom.first;
        WhereClause whereClause = newWhere == null ? null : (WhereClause)newWhere.first;
        GroupbyClause groupbyClause = newGroupby == null ? null : (GroupbyClause)newGroupby.first;
        HavingClause havingClause = newHaving == null ? null : (HavingClause)newHaving.first;
        return new Pair((Object)new SelectBlock((SelectClause)newSelect.first, fromClause, newLetClauses, whereClause, groupbyClause, newLetClausesAfterGby, havingClause), (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectClause selectClause, VariableSubstitutionEnvironment env) throws CompilationException {
        boolean distinct = selectClause.distinct();
        if (selectClause.selectElement()) {
            Pair<ILangExpression, VariableSubstitutionEnvironment> newSelectElement = selectClause.getSelectElement().accept(this, env);
            return new Pair((Object)new SelectClause((SelectElement)newSelectElement.first, null, distinct), newSelectElement.second);
        }
        Pair<ILangExpression, VariableSubstitutionEnvironment> newSelectRegular = selectClause.getSelectRegular().accept(this, env);
        return new Pair((Object)new SelectClause(null, (SelectRegular)newSelectRegular.first, distinct), newSelectRegular.second);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectElement selectElement, VariableSubstitutionEnvironment env) throws CompilationException {
        Pair newExpr = (Pair)selectElement.getExpression().accept((ILangVisitor)this, (Object)env);
        return new Pair((Object)new SelectElement((Expression)newExpr.first), newExpr.second);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectRegular selectRegular, VariableSubstitutionEnvironment env) throws CompilationException {
        ArrayList<Projection> newProjections = new ArrayList<Projection>();
        for (Projection projection : selectRegular.getProjections()) {
            newProjections.add((Projection)projection.accept(this, env).first);
        }
        return new Pair((Object)new SelectRegular(newProjections), (Object)env);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectSetOperation selectSetOperation, VariableSubstitutionEnvironment env) throws CompilationException {
        SetOperationInput newLeftInput;
        Pair<ILangExpression, VariableSubstitutionEnvironment> leftResult;
        SetOperationInput leftInput = selectSetOperation.getLeftInput();
        if (leftInput.selectBlock()) {
            leftResult = leftInput.getSelectBlock().accept(this, env);
            newLeftInput = new SetOperationInput((SelectBlock)leftResult.first, null);
        } else {
            leftResult = leftInput.getSubquery().accept(this, env);
            newLeftInput = new SetOperationInput(null, (SelectExpression)((Object)leftResult.first));
        }
        ArrayList<SetOperationRight> newRightInputs = new ArrayList<SetOperationRight>();
        if (selectSetOperation.hasRightInputs()) {
            for (SetOperationRight right : selectSetOperation.getRightInputs()) {
                SetOperationInput newRightInput;
                Pair<ILangExpression, VariableSubstitutionEnvironment> rightResult;
                SetOperationInput rightInput = right.getSetOperationRightInput();
                if (rightInput.selectBlock()) {
                    rightResult = rightInput.getSelectBlock().accept(this, env);
                    newRightInput = new SetOperationInput((SelectBlock)rightResult.first, null);
                } else {
                    rightResult = rightInput.getSubquery().accept(this, env);
                    newRightInput = new SetOperationInput(null, (SelectExpression)((Object)rightResult.first));
                }
                newRightInputs.add(new SetOperationRight(right.getSetOpType(), right.isSetSemantics(), newRightInput));
            }
        }
        SelectSetOperation newSelectSetOperation = new SelectSetOperation(newLeftInput, newRightInputs);
        return new Pair((Object)newSelectSetOperation, (Object)(selectSetOperation.hasRightInputs() ? env : (VariableSubstitutionEnvironment)leftResult.second));
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectExpression selectExpression, VariableSubstitutionEnvironment env) throws CompilationException {
        Pair p;
        boolean subquery = selectExpression.isSubquery();
        ArrayList<LetClause> newLetList = new ArrayList<LetClause>();
        OrderbyClause newOrderbyClause = null;
        LimitClause newLimitClause = null;
        VariableSubstitutionEnvironment currentEnv = env;
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                p = (Pair)letClause.accept((ILangVisitor)this, (Object)currentEnv);
                newLetList.add((LetClause)p.first);
                currentEnv = (VariableSubstitutionEnvironment)p.second;
            }
        }
        p = selectExpression.getSelectSetOperation().accept(this, env);
        SelectSetOperation newSelectSetOperation = (SelectSetOperation)p.first;
        currentEnv = (VariableSubstitutionEnvironment)p.second;
        if (selectExpression.hasOrderby()) {
            p = (Pair)selectExpression.getOrderbyClause().accept((ILangVisitor)this, (Object)currentEnv);
            newOrderbyClause = (OrderbyClause)p.first;
            currentEnv = (VariableSubstitutionEnvironment)p.second;
        }
        if (selectExpression.hasLimit()) {
            p = (Pair)selectExpression.getLimitClause().accept((ILangVisitor)this, (Object)currentEnv);
            newLimitClause = (LimitClause)p.first;
            currentEnv = (VariableSubstitutionEnvironment)p.second;
        }
        return new Pair((Object)new SelectExpression(newLetList, newSelectSetOperation, newOrderbyClause, newLimitClause, subquery), (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(HavingClause havingClause, VariableSubstitutionEnvironment env) throws CompilationException {
        Pair p = (Pair)havingClause.getFilterExpression().accept((ILangVisitor)this, (Object)env);
        HavingClause newHavingClause = new HavingClause((Expression)p.first);
        return new Pair((Object)newHavingClause, p.second);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(CaseExpression caseExpr, VariableSubstitutionEnvironment env) throws CompilationException {
        Expression conditionExpr = (Expression)((Pair)caseExpr.getConditionExpr().accept((ILangVisitor)this, (Object)env)).first;
        List whenExprList = VariableCloneAndSubstitutionUtil.visitAndCloneExprList(caseExpr.getWhenExprs(), (VariableSubstitutionEnvironment)env, (CloneAndSubstituteVariablesVisitor)this);
        List thenExprList = VariableCloneAndSubstitutionUtil.visitAndCloneExprList(caseExpr.getThenExprs(), (VariableSubstitutionEnvironment)env, (CloneAndSubstituteVariablesVisitor)this);
        Expression elseExpr = (Expression)((Pair)caseExpr.getElseExpr().accept((ILangVisitor)this, (Object)env)).first;
        CaseExpression newCaseExpr = new CaseExpression(conditionExpr, whenExprList, thenExprList, elseExpr);
        return new Pair((Object)newCaseExpr, (Object)env);
    }
}

