/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.HashMap;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SubstituteGroupbyExpressionVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;

public class SubstituteGroupbyExpressionWithVariableVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public SubstituteGroupbyExpressionWithVariableVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        if (selectBlock.hasGroupbyClause()) {
            HashMap<Expression, Expression> map = new HashMap<Expression, Expression>();
            for (Object gbyKeyPair : selectBlock.getGroupbyClause().getGbyPairList()) {
                Expression gbyKeyExpr = gbyKeyPair.getExpr();
                if (gbyKeyExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION) continue;
                map.put(gbyKeyExpr, (Expression)gbyKeyPair.getVar());
            }
            SubstituteGroupbyExpressionVisitor visitor = new SubstituteGroupbyExpressionVisitor(this.context, map);
            if (selectBlock.hasLetClausesAfterGroupby()) {
                for (LetClause letClause : selectBlock.getLetListAfterGroupby()) {
                    letClause.accept((ILangVisitor)this, (Object)arg);
                }
            }
            if (selectBlock.hasHavingClause()) {
                selectBlock.getHavingClause().accept(visitor, arg);
            }
            selectBlock.getSelectClause().accept(visitor, arg);
            SelectExpression selectExpression = (SelectExpression)arg;
            if (!selectExpression.getSelectSetOperation().hasRightInputs()) {
                if (selectExpression.hasOrderby()) {
                    selectExpression.getOrderbyClause().accept((ILangVisitor)visitor, (Object)arg);
                }
                if (selectExpression.hasLimit()) {
                    selectExpression.getLimitClause().accept((ILangVisitor)visitor, (Object)arg);
                }
            }
        }
        return super.visit(selectBlock, arg);
    }
}

