/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

public class SqlppDistinctAggregationSugarVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    protected final LangRewritingContext context;

    public SqlppDistinctAggregationSugarVisitor(LangRewritingContext context) {
        this.context = context;
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        FunctionIdentifier newAggFn;
        FunctionSignature signature = callExpr.getFunctionSignature();
        IFunctionInfo finfo = FunctionUtil.getFunctionInfo((FunctionSignature)signature);
        FunctionIdentifier aggFn = finfo != null ? BuiltinFunctions.getAggregateFunction((FunctionIdentifier)finfo.getFunctionIdentifier()) : null;
        FunctionIdentifier functionIdentifier = newAggFn = aggFn != null ? BuiltinFunctions.getAggregateFunctionForDistinct((FunctionIdentifier)aggFn) : null;
        if (newAggFn == null) {
            return super.visit(callExpr, arg);
        }
        List exprList = callExpr.getExprList();
        ArrayList<Object> newExprList = new ArrayList<Object>(exprList.size());
        for (Expression expr : exprList) {
            Expression newExpr = this.rewriteArgument(expr);
            newExprList.add(newExpr.accept((ILangVisitor)this, (Object)arg));
        }
        callExpr.setFunctionSignature(new FunctionSignature(newAggFn));
        callExpr.setExprList(newExprList);
        return callExpr;
    }

    private Expression rewriteArgument(Expression argExpr) throws CompilationException {
        VariableExpr fromBindingVar = new VariableExpr(this.context.newVariable());
        FromTerm fromTerm = new FromTerm(argExpr, fromBindingVar, null, null);
        FromClause fromClause = new FromClause(Collections.singletonList(fromTerm));
        SelectClause selectClause = new SelectClause(new SelectElement((Expression)fromBindingVar), null, true);
        SelectBlock selectBlock = new SelectBlock(selectClause, fromClause, null, null, null, null, null);
        SelectSetOperation selectSetOperation = new SelectSetOperation(new SetOperationInput(selectBlock, null), null);
        return new SelectExpression(null, selectSetOperation, null, null, true);
    }
}

