/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;

public class GenerateColumnNameVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public GenerateColumnNameVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        selectBlock.getSelectClause().accept(this, arg);
        return super.visit(selectBlock, arg);
    }

    @Override
    public Expression visit(Projection projection, ILangExpression arg) throws CompilationException {
        if (!projection.star() && !projection.varStar() && projection.getName() == null) {
            projection.setName(SqlppVariableUtil.variableNameToDisplayedFieldName(this.context.newVariable().getValue()));
        }
        return super.visit(projection, arg);
    }

    @Override
    public Expression visit(GroupbyClause groupbyClause, ILangExpression arg) throws CompilationException {
        for (GbyVariableExpressionPair gbyKeyPair : groupbyClause.getGbyPairList()) {
            if (gbyKeyPair.getVar() != null) continue;
            gbyKeyPair.setVar(new VariableExpr(this.context.newVariable()));
        }
        return super.visit(groupbyClause, arg);
    }
}

