/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.parser;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.metadata.entities.Function;

public class FunctionParser {
    private final IParserFactory parserFactory;

    public FunctionParser(IParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    public FunctionDecl getFunctionDecl(Function function) throws CompilationException {
        if (!function.getLanguage().equals("SQLPP")) {
            throw new CompilationException(1055, new Serializable[]{"SQLPP", function.getLanguage()});
        }
        String functionBody = function.getFunctionBody();
        List params = function.getArguments();
        StringBuilder builder = new StringBuilder();
        builder.append(" use " + function.getDataverseName() + ";");
        builder.append(" declare function " + function.getName().split("@")[0]);
        builder.append("(");
        for (String param : params) {
            VarIdentifier varId = SqlppVariableUtil.toUserDefinedVariableName(param);
            builder.append(varId);
            builder.append(",");
        }
        if (params.size() > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append(")");
        builder.append("{");
        builder.append("\n");
        builder.append(functionBody);
        builder.append("\n");
        builder.append("};");
        IParser parser = this.parserFactory.createParser((Reader)new StringReader(new String(builder)));
        List statements = parser.parse();
        FunctionDecl decl = (FunctionDecl)statements.get(1);
        return decl;
    }
}

