/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.ByteBufferInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FrameDeserializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ByteBufferInputStream bbis = new ByteBufferInputStream();
    private final DataInputStream di = new DataInputStream(this.bbis);
    private final RecordDescriptor recordDescriptor;
    private final FrameTupleAccessor frameTupleAccessor;
    private int tupleCount;
    private int tIndex;
    private ByteBuffer buffer;

    public FrameDeserializer(RecordDescriptor recordDescriptor) {
        this.recordDescriptor = recordDescriptor;
        this.frameTupleAccessor = new FrameTupleAccessor(recordDescriptor);
    }

    public void reset(ByteBuffer buffer) {
        this.buffer = buffer;
        this.frameTupleAccessor.reset(buffer);
        this.tupleCount = this.frameTupleAccessor.getTupleCount();
        this.tIndex = 0;
    }

    public boolean done() {
        return this.tIndex >= this.tupleCount;
    }

    public Object[] deserializeRecord() throws HyracksDataException {
        int start = this.frameTupleAccessor.getTupleStartOffset(this.tIndex) + this.frameTupleAccessor.getFieldSlotsLength();
        this.bbis.setByteBuffer(this.buffer, start);
        Object[] record = new Object[this.recordDescriptor.getFieldCount()];
        for (int i = 0; i < record.length; ++i) {
            Object instance = this.recordDescriptor.getFields()[i].deserialize((DataInput)this.di);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(i + " " + instance);
            }
            record[i] = instance;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Read Record tIndex = " + this.tIndex + ", tupleCount = " + this.tupleCount);
        }
        ++this.tIndex;
        return record;
    }

    public void close() {
        try {
            this.di.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

