/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.hyracks.http.api.IServletResponse;

public class FullResponse
implements IServletResponse {
    private final ChannelHandlerContext ctx;
    private final ByteArrayOutputStream baos;
    private final PrintWriter writer;
    private final FullHttpResponse response;
    private final boolean keepAlive;
    private ChannelFuture future;

    public FullResponse(ChannelHandlerContext ctx, FullHttpRequest request) {
        this.ctx = ctx;
        this.baos = new ByteArrayOutputStream();
        this.writer = new PrintWriter(this.baos);
        this.response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        this.keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        if (this.keepAlive) {
            this.response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        FullHttpResponse fullResponse = this.response.replace(Unpooled.copiedBuffer((byte[])this.baos.toByteArray()));
        if (this.keepAlive) {
            if (this.response.status() == HttpResponseStatus.OK || this.response.status() == HttpResponseStatus.UNAUTHORIZED) {
                fullResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, fullResponse.content().readableBytes());
            } else {
                fullResponse.headers().remove((CharSequence)HttpHeaderNames.CONNECTION);
            }
        }
        this.future = this.ctx.writeAndFlush((Object)fullResponse);
        if (this.response.status() != HttpResponseStatus.OK && this.response.status() != HttpResponseStatus.UNAUTHORIZED) {
            this.future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public IServletResponse setHeader(CharSequence name, Object value) throws IOException {
        this.response.headers().set(name, value);
        return this;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public ChannelFuture lastContentFuture() throws IOException {
        return this.future;
    }

    @Override
    public OutputStream outputStream() {
        return this.baos;
    }

    @Override
    public void setStatus(HttpResponseStatus status) {
        this.response.setStatus(status);
    }

    @Override
    public void notifyChannelWritable() {
    }

    @Override
    public void notifyChannelInactive() {
    }
}

