/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.impls;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import org.apache.hyracks.storage.am.common.impls.AbstractTreeIndex;
import org.apache.hyracks.storage.am.common.impls.NodeFrontier;
import org.apache.hyracks.storage.am.common.impls.TreeIndexDiskOrderScanCursor;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.util.TreeIndexUtils;
import org.apache.hyracks.storage.am.rtree.api.IRTreeFrame;
import org.apache.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import org.apache.hyracks.storage.am.rtree.api.IRTreeLeafFrame;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMFrame;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMInteriorFrame;
import org.apache.hyracks.storage.am.rtree.impls.RTreeOpContext;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSearchCursor;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.am.rtree.tuples.RTreeTypeAwareTupleWriter;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class RTree
extends AbstractTreeIndex {
    private final AtomicLong globalNsn = new AtomicLong();
    private final int maxTupleSize;
    private final boolean isPointMBR;

    public RTree(IBufferCache bufferCache, IPageManager freePageManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory, IBinaryComparatorFactory[] cmpFactories, int fieldCount, FileReference file, boolean isPointMBR) {
        super(bufferCache, freePageManager, interiorFrameFactory, leafFrameFactory, cmpFactories, fieldCount, file);
        ITreeIndexFrame leafFrame = leafFrameFactory.createFrame();
        ITreeIndexFrame interiorFrame = interiorFrameFactory.createFrame();
        this.maxTupleSize = Math.min(leafFrame.getMaxTupleSize(bufferCache.getPageSize()), interiorFrame.getMaxTupleSize(bufferCache.getPageSize()));
        this.isPointMBR = isPointMBR;
    }

    private long incrementGlobalNsn() {
        return this.globalNsn.incrementAndGet();
    }

    public String printTree(IRTreeLeafFrame leafFrame, IRTreeInteriorFrame interiorFrame, ISerializerDeserializer[] keySerdes) throws Exception {
        MultiComparator cmp = MultiComparator.create((IBinaryComparatorFactory[])this.cmpFactories);
        byte treeHeight = this.getTreeHeight(leafFrame);
        StringBuilder strBuilder = new StringBuilder();
        this.printTree(this.rootPage, null, false, leafFrame, interiorFrame, treeHeight, keySerdes, strBuilder, cmp);
        return strBuilder.toString();
    }

    public void printTree(int pageId, ICachedPage parent, boolean unpin, IRTreeLeafFrame leafFrame, IRTreeInteriorFrame interiorFrame, byte treeHeight, ISerializerDeserializer[] keySerdes, StringBuilder strBuilder, MultiComparator cmp) throws Exception {
        ICachedPage node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
        node.acquireReadLatch();
        try {
            int rightPage;
            long NSN;
            long LSN;
            String keyString;
            if (parent != null && unpin) {
                parent.releaseReadLatch();
                this.bufferCache.unpin(parent);
            }
            interiorFrame.setPage(node);
            byte level = interiorFrame.getLevel();
            strBuilder.append(String.format("%1d ", level));
            strBuilder.append(String.format("%3d ", pageId) + ": ");
            for (int i = 0; i < treeHeight - level; ++i) {
                strBuilder.append("    ");
            }
            if (interiorFrame.isLeaf()) {
                leafFrame.setPage(node);
                keyString = TreeIndexUtils.printFrameTuples((ITreeIndexFrame)leafFrame, (ISerializerDeserializer[])keySerdes);
                LSN = leafFrame.getPageLsn();
                NSN = leafFrame.getPageNsn();
                rightPage = leafFrame.getRightPage();
            } else {
                keyString = TreeIndexUtils.printFrameTuples((ITreeIndexFrame)interiorFrame, (ISerializerDeserializer[])keySerdes);
                LSN = interiorFrame.getPageLsn();
                NSN = interiorFrame.getPageNsn();
                rightPage = interiorFrame.getRightPage();
            }
            strBuilder.append(keyString + "\npageId: " + pageId + " LSN: " + LSN + " NSN: " + NSN + " rightPage: " + rightPage + "\n");
            if (!interiorFrame.isLeaf()) {
                ArrayList<Integer> children = ((RTreeNSMInteriorFrame)interiorFrame).getChildren(cmp);
                for (int i = 0; i < children.size(); ++i) {
                    this.printTree(children.get(i), node, i == children.size() - 1, leafFrame, interiorFrame, treeHeight, keySerdes, strBuilder, cmp);
                }
            } else {
                node.releaseReadLatch();
                this.bufferCache.unpin(node);
            }
        }
        catch (Exception e) {
            node.releaseReadLatch();
            this.bufferCache.unpin(node);
            e.printStackTrace();
        }
    }

    private RTreeOpContext createOpContext(IModificationOperationCallback modificationCallback) {
        return new RTreeOpContext((IRTreeLeafFrame)this.leafFrameFactory.createFrame(), (IRTreeInteriorFrame)this.interiorFrameFactory.createFrame(), this.freePageManager, this.cmpFactories, modificationCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedPage findLeaf(RTreeOpContext ctx) throws HyracksDataException {
        int pageId = this.rootPage;
        boolean writeLatched = false;
        boolean readLatched = false;
        boolean succeeded = false;
        ICachedPage node = null;
        boolean isLeaf = false;
        long pageLsn = 0L;
        long parentLsn = 0L;
        try {
            while (true) {
                if (!writeLatched) {
                    node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
                    ctx.getInteriorFrame().setPage(node);
                    isLeaf = ctx.getInteriorFrame().isLeaf();
                    if (isLeaf) {
                        node.acquireWriteLatch();
                        writeLatched = true;
                        if (!ctx.getInteriorFrame().isLeaf()) {
                            node.releaseWriteLatch(true);
                            writeLatched = false;
                            this.bufferCache.unpin(node);
                            continue;
                        }
                    } else {
                        node.acquireReadLatch();
                        readLatched = true;
                    }
                }
                if (pageId != this.rootPage && parentLsn < ctx.getInteriorFrame().getPageNsn()) {
                    if (writeLatched) {
                        node.releaseWriteLatch(true);
                        writeLatched = false;
                        this.bufferCache.unpin(node);
                    } else {
                        node.releaseReadLatch();
                        readLatched = false;
                        this.bufferCache.unpin(node);
                    }
                    pageId = ctx.getPathList().getLastPageId();
                    if (pageId != this.rootPage) {
                        parentLsn = ctx.getPathList().getPageLsn(ctx.getPathList().size() - 2);
                    }
                    ctx.getPathList().moveLast();
                    continue;
                }
                pageLsn = ctx.getInteriorFrame().getPageLsn();
                ctx.getPathList().add(pageId, pageLsn, -1);
                if (isLeaf) break;
                int childPageId = ctx.getInteriorFrame().findBestChild(ctx.getTuple(), ctx.getCmp());
                boolean enlarementIsNeeded = ctx.getInteriorFrame().checkIfEnlarementIsNeeded(ctx.getTuple(), ctx.getCmp());
                if (enlarementIsNeeded) {
                    if (!writeLatched) {
                        node.releaseReadLatch();
                        readLatched = false;
                        this.bufferCache.unpin(node);
                        node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
                        node.acquireWriteLatch();
                        writeLatched = true;
                        ctx.getInteriorFrame().setPage(node);
                        if (ctx.getInteriorFrame().getPageLsn() != pageLsn) {
                            ctx.getPathList().moveLast();
                            continue;
                        }
                    }
                    ctx.getInteriorFrame().enlarge(ctx.getTuple(), ctx.getCmp());
                    node.releaseWriteLatch(true);
                    writeLatched = false;
                    this.bufferCache.unpin(node);
                } else if (readLatched) {
                    node.releaseReadLatch();
                    readLatched = false;
                    this.bufferCache.unpin(node);
                } else if (writeLatched) {
                    node.releaseWriteLatch(true);
                    writeLatched = false;
                    this.bufferCache.unpin(node);
                }
                pageId = childPageId;
                parentLsn = pageLsn;
            }
            ctx.getLeafFrame().setPage(node);
            succeeded = true;
            ICachedPage iCachedPage = node;
            return iCachedPage;
        }
        finally {
            if (!succeeded) {
                if (readLatched) {
                    node.releaseReadLatch();
                    readLatched = false;
                    this.bufferCache.unpin(node);
                } else if (writeLatched) {
                    node.releaseWriteLatch(true);
                    writeLatched = false;
                    this.bufferCache.unpin(node);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void insertTuple(ICachedPage node, int pageId, ITupleReference tuple, RTreeOpContext ctx, boolean isLeaf) throws HyracksDataException {
        succeeded = false;
        spaceStatus = isLeaf == false ? ctx.getInteriorFrame().hasSpaceInsert(tuple) : ctx.getLeafFrame().hasSpaceInsert(tuple);
        switch (1.$SwitchMap$org$apache$hyracks$storage$am$common$frames$FrameOpSpaceStatus[spaceStatus.ordinal()]) {
            case 1: {
                try {
                    if (!isLeaf) {
                        ctx.getInteriorFrame().insert(tuple, -1);
                    } else {
                        ctx.getModificationCallback().found(null, tuple);
                        ctx.getLeafFrame().insert(tuple, -1);
                    }
                    succeeded = true;
                    if (!succeeded) ** GOTO lbl27
                    ctx.getLSNUpdates().add(node);
                }
                catch (Throwable var8_8) {
                    if (succeeded) {
                        ctx.getLSNUpdates().add(node);
                        ctx.getSplitKey().reset();
                    } else if (isLeaf) {
                        node.releaseWriteLatch(true);
                        this.bufferCache.unpin(node);
                    }
                    throw var8_8;
                }
                ctx.getSplitKey().reset();
                break;
lbl27:
                // 1 sources

                if (!isLeaf) break;
                node.releaseWriteLatch(true);
                this.bufferCache.unpin(node);
                break;
            }
            case 2: {
                try {
                    if (!isLeaf) {
                        ctx.getInteriorFrame().compact();
                        ctx.getInteriorFrame().insert(tuple, -1);
                    } else {
                        ctx.getLeafFrame().compact();
                        ctx.getModificationCallback().found(null, tuple);
                        ctx.getLeafFrame().insert(tuple, -1);
                    }
                    succeeded = true;
                    if (!succeeded) ** GOTO lbl58
                    ctx.getLSNUpdates().add(node);
                }
                catch (Throwable var9_10) {
                    if (succeeded) {
                        ctx.getLSNUpdates().add(node);
                        ctx.getSplitKey().reset();
                    } else if (isLeaf) {
                        node.releaseWriteLatch(true);
                        this.bufferCache.unpin(node);
                    }
                    throw var9_10;
                }
                ctx.getSplitKey().reset();
                break;
lbl58:
                // 1 sources

                if (!isLeaf) break;
                node.releaseWriteLatch(true);
                this.bufferCache.unpin(node);
                break;
            }
            case 3: {
                rightPageId = this.freePageManager.takePage(ctx.getMetaFrame());
                rightNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)rightPageId), true);
                rightNode.acquireWriteLatch();
                try {
                    if (!isLeaf) {
                        rightFrame = (IRTreeFrame)this.interiorFrameFactory.createFrame();
                        rightFrame.setPage(rightNode);
                        rightFrame.initBuffer(ctx.getInteriorFrame().getLevel());
                        rightFrame.setRightPage(ctx.getInteriorFrame().getRightPage());
                        ctx.getInteriorFrame().split(rightFrame, tuple, ctx.getSplitKey(), ctx, this.bufferCache);
                        ctx.getInteriorFrame().setRightPage(rightPageId);
                    } else {
                        rightFrame = (IRTreeFrame)this.leafFrameFactory.createFrame();
                        rightFrame.setPage(rightNode);
                        rightFrame.initBuffer((byte)0);
                        rightFrame.setRightPage(ctx.getInteriorFrame().getRightPage());
                        ctx.getModificationCallback().found(null, tuple);
                        ctx.getLeafFrame().split(rightFrame, tuple, ctx.getSplitKey(), ctx, this.bufferCache);
                        ctx.getLeafFrame().setRightPage(rightPageId);
                    }
                    succeeded = true;
                }
                finally {
                    if (succeeded) {
                        ctx.getNSNUpdates().add(rightNode);
                        ctx.getLSNUpdates().add(rightNode);
                        ctx.getNSNUpdates().add(node);
                        ctx.getLSNUpdates().add(node);
                    } else if (isLeaf) {
                        node.releaseWriteLatch(true);
                        this.bufferCache.unpin(node);
                        rightNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(rightNode);
                    } else {
                        rightNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(rightNode);
                    }
                }
                ctx.getSplitKey().setPages(pageId, rightPageId);
                if (pageId != this.rootPage) break;
                newLeftId = this.freePageManager.takePage(ctx.getMetaFrame());
                newLeftNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)newLeftId), true);
                newLeftNode.acquireWriteLatch();
                succeeded = false;
                try {
                    System.arraycopy(node.getBuffer().array(), 0, newLeftNode.getBuffer().array(), 0, newLeftNode.getBuffer().capacity());
                    ctx.getInteriorFrame().setPage(node);
                    ctx.getInteriorFrame().initBuffer((byte)(ctx.getInteriorFrame().getLevel() + 1));
                    ctx.getSplitKey().setLeftPage(newLeftId);
                    ctx.getInteriorFrame().insert((ITupleReference)ctx.getSplitKey().getLeftTuple(), -1);
                    ctx.getInteriorFrame().insert((ITupleReference)ctx.getSplitKey().getRightTuple(), -1);
                    succeeded = true;
                    if (!succeeded) ** GOTO lbl162
                    ctx.getNSNUpdates().remove(ctx.getNSNUpdates().size() - 1);
                }
                catch (Throwable var12_16) {
                    if (succeeded) {
                        ctx.getNSNUpdates().remove(ctx.getNSNUpdates().size() - 1);
                        ctx.getLSNUpdates().remove(ctx.getLSNUpdates().size() - 1);
                        ctx.getNSNUpdates().add(newLeftNode);
                        ctx.getLSNUpdates().add(newLeftNode);
                        ctx.getNSNUpdates().add(node);
                        ctx.getLSNUpdates().add(node);
                        ctx.getSplitKey().reset();
                    } else if (isLeaf) {
                        node.releaseWriteLatch(true);
                        this.bufferCache.unpin(node);
                        rightNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(rightNode);
                        newLeftNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(newLeftNode);
                    } else {
                        rightNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(rightNode);
                        newLeftNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(newLeftNode);
                    }
                    throw var12_16;
                }
                ctx.getLSNUpdates().remove(ctx.getLSNUpdates().size() - 1);
                ctx.getNSNUpdates().add(newLeftNode);
                ctx.getLSNUpdates().add(newLeftNode);
                ctx.getNSNUpdates().add(node);
                ctx.getLSNUpdates().add(node);
                ctx.getSplitKey().reset();
                break;
lbl162:
                // 1 sources

                if (isLeaf) {
                    node.releaseWriteLatch(true);
                    this.bufferCache.unpin(node);
                    rightNode.releaseWriteLatch(true);
                    this.bufferCache.unpin(rightNode);
                    newLeftNode.releaseWriteLatch(true);
                    this.bufferCache.unpin(newLeftNode);
                    break;
                }
                rightNode.releaseWriteLatch(true);
                this.bufferCache.unpin(rightNode);
                newLeftNode.releaseWriteLatch(true);
                this.bufferCache.unpin(newLeftNode);
                break;
            }
            default: {
                throw new IllegalStateException("NYI: " + spaceStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateParentForInsert(RTreeOpContext ctx) throws HyracksDataException {
        block10: {
            boolean succeeded = false;
            boolean writeLatched = false;
            int parentId = ctx.getPathList().getLastPageId();
            ICachedPage parentNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)parentId), false);
            parentNode.acquireWriteLatch();
            writeLatched = true;
            ctx.getInteriorFrame().setPage(parentNode);
            boolean foundParent = true;
            try {
                if (ctx.getInteriorFrame().getPageLsn() != ctx.getPathList().getLastPageLsn()) {
                    foundParent = false;
                    while (true) {
                        if (ctx.getInteriorFrame().findTupleByPointer((ITupleReference)ctx.getSplitKey().getLeftTuple(), ctx.getCmp()) != -1) {
                            foundParent = true;
                            break;
                        }
                        int rightPage = ctx.getInteriorFrame().getRightPage();
                        parentNode.releaseWriteLatch(true);
                        writeLatched = false;
                        this.bufferCache.unpin(parentNode);
                        if (rightPage == -1) break;
                        parentId = rightPage;
                        parentNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)parentId), false);
                        parentNode.acquireWriteLatch();
                        writeLatched = true;
                        ctx.getInteriorFrame().setPage(parentNode);
                    }
                }
                if (!foundParent) break block10;
                try {
                    ctx.getInteriorFrame().adjustKey((ITupleReference)ctx.getSplitKey().getLeftTuple(), -1, ctx.getCmp());
                }
                catch (Exception e) {
                    if (writeLatched) {
                        parentNode.releaseWriteLatch(true);
                        writeLatched = false;
                        this.bufferCache.unpin(parentNode);
                    }
                    throw e;
                }
                this.insertTuple(parentNode, parentId, (ITupleReference)ctx.getSplitKey().getRightTuple(), ctx, ctx.getInteriorFrame().isLeaf());
                ctx.getPathList().moveLast();
                succeeded = true;
                return;
            }
            finally {
                if (!succeeded && writeLatched) {
                    parentNode.releaseWriteLatch(true);
                    writeLatched = false;
                    this.bufferCache.unpin(parentNode);
                }
            }
        }
        ctx.getTraverseList().clear();
        this.findPath(ctx);
        this.updateParentForInsert(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void findPath(RTreeOpContext ctx) throws HyracksDataException {
        block11: {
            boolean readLatched = false;
            int pageId = this.rootPage;
            int parentIndex = -1;
            long parentLsn = 0L;
            ICachedPage node = null;
            ctx.getTraverseList().add(pageId, -1L, parentIndex);
            while (true) {
                block9: {
                    block10: {
                        int rightPage;
                        if (ctx.getTraverseList().isLast()) break;
                        pageId = ctx.getTraverseList().getFirstPageId();
                        parentIndex = ctx.getTraverseList().getFirstPageIndex();
                        node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
                        node.acquireReadLatch();
                        readLatched = true;
                        ctx.getInteriorFrame().setPage(node);
                        long pageLsn = ctx.getInteriorFrame().getPageLsn();
                        int pageIndex = ctx.getTraverseList().first();
                        ctx.getTraverseList().setPageLsn(pageIndex, pageLsn);
                        ctx.getTraverseList().moveFirst();
                        if (ctx.getInteriorFrame().isLeaf()) {
                            throw HyracksDataException.create((int)44, (Serializable[])new Serializable[0]);
                        }
                        if (pageId != this.rootPage) {
                            parentLsn = ctx.getTraverseList().getPageLsn(ctx.getTraverseList().getPageIndex(pageIndex));
                        }
                        if (pageId != this.rootPage && parentLsn < ctx.getInteriorFrame().getPageNsn() && (rightPage = ctx.getInteriorFrame().getRightPage()) != -1) {
                            ctx.getTraverseList().addFirst(rightPage, -1L, parentIndex);
                        }
                        if (ctx.getInteriorFrame().findTupleByPointer((ITupleReference)ctx.getSplitKey().getLeftTuple(), ctx.getTraverseList(), pageIndex, ctx.getCmp()) == -1) break block9;
                        ctx.getPathList().clear();
                        this.fillPath(ctx, pageIndex);
                        if (!readLatched) break block10;
                        node.releaseReadLatch();
                        readLatched = false;
                        this.bufferCache.unpin(node);
                    }
                    return;
                }
                node.releaseReadLatch();
                readLatched = false;
                this.bufferCache.unpin(node);
                continue;
                break;
            }
            if (readLatched) {
                node.releaseReadLatch();
                readLatched = false;
                this.bufferCache.unpin(node);
            }
            break block11;
            catch (Throwable throwable) {
                if (readLatched) {
                    node.releaseReadLatch();
                    readLatched = false;
                    this.bufferCache.unpin(node);
                }
                throw throwable;
            }
        }
    }

    private void fillPath(RTreeOpContext ctx, int pageIndex) {
        if (pageIndex != -1) {
            this.fillPath(ctx, ctx.getTraverseList().getPageIndex(pageIndex));
            ctx.getPathList().add(ctx.getTraverseList().getPageId(pageIndex), ctx.getTraverseList().getPageLsn(pageIndex), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(ITupleReference tuple, RTreeOpContext ctx) throws HyracksDataException {
        ctx.reset();
        ctx.setTuple(tuple);
        ctx.getSplitKey().reset();
        ctx.getSplitKey().getLeftTuple().setFieldCount(this.cmpFactories.length);
        int tupleIndex = this.findTupleToDelete(ctx);
        if (tupleIndex != -1) {
            try {
                this.deleteTuple(tupleIndex, ctx);
            }
            finally {
                ctx.getLeafFrame().getPage().releaseWriteLatch(true);
                this.bufferCache.unpin(ctx.getLeafFrame().getPage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findTupleToDelete(RTreeOpContext ctx) throws HyracksDataException {
        writeLatched = false;
        readLatched = false;
        succeeded = false;
        node = null;
        ctx.getPathList().add(this.rootPage, -1L, -1);
        while (true) {
            block15: {
                block13: {
                    block14: {
                        try {
                            while (!ctx.getPathList().isEmpty()) {
                                block16: {
                                    pageId = ctx.getPathList().getLastPageId();
                                    parentLsn = ctx.getPathList().getLastPageLsn();
                                    ctx.getPathList().moveLast();
                                    node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
                                    node.acquireReadLatch();
                                    readLatched = true;
                                    ctx.getInteriorFrame().setPage(node);
                                    isLeaf = ctx.getInteriorFrame().isLeaf();
                                    pageLsn = ctx.getInteriorFrame().getPageLsn();
                                    if (pageId != this.rootPage && parentLsn < ctx.getInteriorFrame().getPageNsn() && (rightPage = ctx.getInteriorFrame().getRightPage()) != -1) {
                                        ctx.getPathList().add(rightPage, parentLsn, -1);
                                    }
                                    if (isLeaf) break block16;
                                    for (i = 0; i < ctx.getInteriorFrame().getTupleCount(); ++i) {
                                        childPageId = ctx.getInteriorFrame().getChildPageIdIfIntersect(ctx.getTuple(), i, ctx.getCmp());
                                        if (childPageId == -1) continue;
                                        ctx.getPathList().add(childPageId, pageLsn, -1);
                                    }
                                    ** GOTO lbl-1000
                                }
                                ctx.getLeafFrame().setPage(node);
                                tupleIndex = ctx.getLeafFrame().findTupleIndex(ctx.getTuple(), ctx.getCmp());
                                if (tupleIndex == -1) ** GOTO lbl-1000
                                node.releaseReadLatch();
                                readLatched = false;
                                this.bufferCache.unpin(node);
                                node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
                                node.acquireWriteLatch();
                                writeLatched = true;
                                ctx.getLeafFrame().setPage(node);
                                if (!ctx.getLeafFrame().isLeaf()) {
                                    ctx.getPathList().add(pageId, -1L, -1);
                                    node.releaseWriteLatch(true);
                                    writeLatched = false;
                                    this.bufferCache.unpin(node);
                                    continue;
                                }
                                if (ctx.getLeafFrame().getPageLsn() != pageLsn) {
                                    tupleIndex = ctx.getLeafFrame().findTupleIndex(ctx.getTuple(), ctx.getCmp());
                                    if (tupleIndex == -1) {
                                        ctx.getPathList().add(pageId, parentLsn, -1);
                                        node.releaseWriteLatch(true);
                                        writeLatched = false;
                                        this.bufferCache.unpin(node);
                                        continue;
                                    }
                                    succeeded = true;
                                    var13_11 = tupleIndex;
                                    if (succeeded != false) return var13_11;
                                    if (!readLatched) break block13;
                                    break block14;
                                }
                                ** GOTO lbl-1000
                            }
                            break;
                        }
                        catch (Throwable var14_12) {
                            if (succeeded != false) throw var14_12;
                            if (readLatched) {
                                node.releaseReadLatch();
                                readLatched = false;
                                this.bufferCache.unpin(node);
                                throw var14_12;
                            }
                            if (writeLatched == false) throw var14_12;
                            node.releaseWriteLatch(true);
                            writeLatched = false;
                            this.bufferCache.unpin(node);
                            throw var14_12;
                        }
                    }
                    node.releaseReadLatch();
                    readLatched = false;
                    this.bufferCache.unpin(node);
                    return var13_11;
                }
                if (writeLatched == false) return var13_11;
                node.releaseWriteLatch(true);
                writeLatched = false;
                this.bufferCache.unpin(node);
                return var13_11;
lbl-1000:
                // 1 sources

                {
                    succeeded = true;
                    var13_11 = tupleIndex;
                    if (succeeded != false) return var13_11;
                    if (!readLatched) break block15;
                }
                node.releaseReadLatch();
                readLatched = false;
                this.bufferCache.unpin(node);
                return var13_11;
            }
            if (writeLatched == false) return var13_11;
            node.releaseWriteLatch(true);
            writeLatched = false;
            this.bufferCache.unpin(node);
            return var13_11;
lbl-1000:
            // 2 sources

            {
                node.releaseReadLatch();
                readLatched = false;
                this.bufferCache.unpin(node);
                continue;
            }
            break;
        }
        if (succeeded != false) return -1;
        if (readLatched) {
            node.releaseReadLatch();
            readLatched = false;
            this.bufferCache.unpin(node);
            return -1;
        }
        if (writeLatched == false) return -1;
        node.releaseWriteLatch(true);
        writeLatched = false;
        this.bufferCache.unpin(node);
        return -1;
    }

    private void deleteTuple(int tupleIndex, RTreeOpContext ctx) throws HyracksDataException {
        ITupleReference beforeTuple = ctx.getLeafFrame().getBeforeTuple(ctx.getTuple(), tupleIndex, ctx.getCmp());
        ctx.getModificationCallback().found(beforeTuple, ctx.getTuple());
        ctx.getLeafFrame().delete(tupleIndex, ctx.getCmp());
        ctx.getLeafFrame().setPageLsn(this.incrementGlobalNsn());
    }

    private void search(ITreeIndexCursor cursor, ISearchPredicate searchPred, RTreeOpContext ctx) throws HyracksDataException {
        ctx.reset();
        ctx.setCursor(cursor);
        cursor.setBufferCache(this.bufferCache);
        cursor.setFileId(this.getFileId());
        ctx.getCursorInitialState().setRootPage(this.rootPage);
        ctx.getCursor().open((ICursorInitialState)ctx.getCursorInitialState(), searchPred);
    }

    private void update(ITupleReference tuple, RTreeOpContext ctx) {
        throw new UnsupportedOperationException("RTree Update not implemented.");
    }

    private void diskOrderScan(ITreeIndexCursor icursor, RTreeOpContext ctx) throws HyracksDataException {
        TreeIndexDiskOrderScanCursor cursor = (TreeIndexDiskOrderScanCursor)icursor;
        ctx.reset();
        MultiComparator cmp = MultiComparator.create((IBinaryComparatorFactory[])this.cmpFactories);
        SearchPredicate searchPred = new SearchPredicate(null, cmp);
        int currentPageId = this.bulkloadLeafStart;
        int maxPageId = this.freePageManager.getMaxPageId(ctx.getMetaFrame());
        ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)currentPageId), false);
        page.acquireReadLatch();
        try {
            cursor.setBufferCache(this.bufferCache);
            cursor.setFileId(this.getFileId());
            cursor.setCurrentPageId(currentPageId);
            cursor.setMaxPageId(maxPageId);
            ctx.getCursorInitialState().setOriginialKeyComparator(ctx.getCmp());
            ctx.getCursorInitialState().setPage(page);
            cursor.open((ICursorInitialState)ctx.getCursorInitialState(), (ISearchPredicate)searchPred);
        }
        catch (Exception e) {
            page.releaseReadLatch();
            this.bufferCache.unpin(page);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public RTreeAccessor createAccessor(IIndexAccessParameters iap) {
        return new RTreeAccessor(this, iap.getModificationCallback(), iap.getSearchOperationCallback());
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws HyracksDataException {
        return new RTreeBulkLoader(fillFactor);
    }

    public void validate() throws HyracksDataException {
        throw new UnsupportedOperationException("Validation not implemented for R-Trees.");
    }

    public int getNumOfFilterFields() {
        return 0;
    }

    public class RTreeBulkLoader
    extends AbstractTreeIndex.AbstractTreeIndexBulkLoader {
        ITreeIndexFrame lowerFrame;
        ITreeIndexFrame prevInteriorFrame;
        RTreeTypeAwareTupleWriter interiorFrameTupleWriter;
        ITreeIndexTupleReference mbrTuple;
        ByteBuffer mbr;
        List<Integer> prevNodeFrontierPages;

        public RTreeBulkLoader(float fillFactor) throws HyracksDataException {
            super((AbstractTreeIndex)RTree.this, fillFactor);
            this.interiorFrameTupleWriter = (RTreeTypeAwareTupleWriter)this.interiorFrame.getTupleWriter();
            this.mbrTuple = this.interiorFrame.createTupleReference();
            this.prevNodeFrontierPages = new ArrayList<Integer>();
            this.prevInteriorFrame = RTree.this.interiorFrameFactory.createFrame();
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            try {
                int leafFrameTupleSize = this.leafFrame.getBytesRequiredToWriteTuple(tuple);
                int interiorFrameTupleSize = this.interiorFrame.getBytesRequiredToWriteTuple(tuple);
                int tupleSize = Math.max(leafFrameTupleSize, interiorFrameTupleSize);
                if (tupleSize > RTree.this.maxTupleSize) {
                    throw HyracksDataException.create((int)43, (Serializable[])new Serializable[]{Integer.valueOf(tupleSize), Integer.valueOf(RTree.this.maxTupleSize)});
                }
                NodeFrontier leafFrontier = (NodeFrontier)this.nodeFrontiers.get(0);
                int spaceNeeded = leafFrameTupleSize;
                int spaceUsed = this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace();
                if (spaceUsed + spaceNeeded > this.leafMaxBytes) {
                    this.leafFrame.compress();
                    spaceUsed = this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace();
                }
                if (spaceUsed + spaceNeeded > this.leafMaxBytes) {
                    if (this.prevNodeFrontierPages.size() == 0) {
                        this.prevNodeFrontierPages.add(leafFrontier.pageId);
                    } else {
                        this.prevNodeFrontierPages.set(0, leafFrontier.pageId);
                    }
                    this.propagateBulk(1, false, this.pagesToWrite);
                    leafFrontier.pageId = RTree.this.freePageManager.takePage(this.metaFrame);
                    this.queue.put(leafFrontier.page);
                    for (ICachedPage c : this.pagesToWrite) {
                        this.queue.put(c);
                    }
                    this.pagesToWrite.clear();
                    leafFrontier.page = RTree.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)RTree.this.getFileId(), (int)leafFrontier.pageId));
                    this.leafFrame.setPage(leafFrontier.page);
                    this.leafFrame.initBuffer((byte)0);
                }
                this.leafFrame.setPage(leafFrontier.page);
                this.leafFrame.insert(tuple, -1);
            }
            catch (HyracksDataException e) {
                this.handleException();
                throw e;
            }
            catch (RuntimeException e) {
                this.handleException();
                throw e;
            }
        }

        public void end() throws HyracksDataException {
            this.pagesToWrite.clear();
            if (this.nodeFrontiers.size() > 1) {
                this.propagateBulk(1, true, this.pagesToWrite);
            }
            for (ICachedPage c : this.pagesToWrite) {
                this.queue.put(c);
            }
            this.finish();
            super.end();
        }

        public void abort() throws HyracksDataException {
            super.handleException();
        }

        protected void finish() throws HyracksDataException {
            int prevPageId = -1;
            for (NodeFrontier n : this.nodeFrontiers) {
                if (this.nodeFrontiers.indexOf(n) != 0) {
                    int finalPageId;
                    this.interiorFrame.setPage(n.page);
                    this.mbrTuple.resetByTupleOffset(this.mbr.array(), 0);
                    this.interiorFrame.insert((ITupleReference)this.mbrTuple, -1);
                    this.interiorFrame.getBuffer().putInt(this.interiorFrame.getTupleOffset(this.interiorFrame.getTupleCount() - 1) + this.mbrTuple.getTupleSize(), prevPageId);
                    n.pageId = finalPageId = RTree.this.freePageManager.takePage(this.metaFrame);
                    n.page.setDiskPageId(BufferedFileHandle.getDiskPageId((int)RTree.this.getFileId(), (int)finalPageId));
                }
                if (this.nodeFrontiers.size() > 1 && this.nodeFrontiers.indexOf(n) < this.nodeFrontiers.size() - 1) {
                    this.lowerFrame.setPage(n.page);
                    ((RTreeNSMFrame)this.lowerFrame).adjustMBR();
                    this.interiorFrameTupleWriter.writeTupleFields(((RTreeNSMFrame)this.lowerFrame).getMBRTuples(), 0, this.mbr, 0);
                }
                this.queue.put(n.page);
                n.page = null;
                prevPageId = n.pageId;
            }
            RTree.this.rootPage = ((NodeFrontier)this.nodeFrontiers.get((int)(this.nodeFrontiers.size() - 1))).pageId;
            this.releasedLatches = true;
        }

        protected void propagateBulk(int level, boolean toRoot, List<ICachedPage> pagesToWrite) throws HyracksDataException {
            boolean propagated = false;
            if (level == 1) {
                this.lowerFrame = this.leafFrame;
            }
            if (this.lowerFrame.getTupleCount() == 0) {
                return;
            }
            if (level >= this.nodeFrontiers.size()) {
                this.addLevel();
            }
            ((RTreeNSMFrame)this.lowerFrame).adjustMBR();
            if (this.mbr == null) {
                int bytesRequired = this.interiorFrameTupleWriter.bytesRequired((ITupleReference)((RTreeNSMFrame)this.lowerFrame).getMBRTuples()[0], 0, this.cmp.getKeyFieldCount()) + ((RTreeNSMInteriorFrame)this.interiorFrame).getChildPointerSize();
                this.mbr = ByteBuffer.allocate(bytesRequired);
            }
            this.interiorFrameTupleWriter.writeTupleFields(((RTreeNSMFrame)this.lowerFrame).getMBRTuples(), 0, this.mbr, 0);
            this.mbrTuple.resetByTupleOffset(this.mbr.array(), 0);
            NodeFrontier frontier = (NodeFrontier)this.nodeFrontiers.get(level);
            this.interiorFrame.setPage(frontier.page);
            int sizeOfTwoTuples = 2 * (this.mbrTuple.getTupleSize() + 4);
            FrameOpSpaceStatus spaceForTwoTuples = ((RTreeNSMInteriorFrame)this.interiorFrame).hasSpaceInsert(sizeOfTwoTuples);
            if (spaceForTwoTuples != FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE && !toRoot) {
                int finalPageId = RTree.this.freePageManager.takePage(this.metaFrame);
                if (this.prevNodeFrontierPages.size() <= level) {
                    this.prevNodeFrontierPages.add(finalPageId);
                } else {
                    this.prevNodeFrontierPages.set(level, finalPageId);
                }
                frontier.page.setDiskPageId(BufferedFileHandle.getDiskPageId((int)RTree.this.getFileId(), (int)finalPageId));
                pagesToWrite.add(frontier.page);
                this.lowerFrame = this.prevInteriorFrame;
                this.lowerFrame.setPage(frontier.page);
                frontier.page = RTree.this.bufferCache.confiscatePage(-1L);
                this.interiorFrame.setPage(frontier.page);
                this.interiorFrame.initBuffer((byte)level);
                this.interiorFrame.insert((ITupleReference)this.mbrTuple, -1);
                this.interiorFrame.getBuffer().putInt(this.interiorFrame.getTupleOffset(this.interiorFrame.getTupleCount() - 1) + this.mbrTuple.getTupleSize(), this.prevNodeFrontierPages.get(level - 1));
                this.propagateBulk(level + 1, toRoot, pagesToWrite);
            } else if (this.interiorFrame.hasSpaceInsert((ITupleReference)this.mbrTuple) == FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE && !toRoot) {
                this.interiorFrame.insert((ITupleReference)this.mbrTuple, -1);
                this.interiorFrame.getBuffer().putInt(this.interiorFrame.getTupleOffset(this.interiorFrame.getTupleCount() - 1) + this.mbrTuple.getTupleSize(), this.prevNodeFrontierPages.get(level - 1));
            }
            if (toRoot && level < this.nodeFrontiers.size() - 1) {
                this.lowerFrame = this.prevInteriorFrame;
                this.lowerFrame.setPage(frontier.page);
                this.propagateBulk(level + 1, true, pagesToWrite);
            }
            this.leafFrame.setPage(((NodeFrontier)this.nodeFrontiers.get((int)0)).page);
        }
    }

    public class RTreeAccessor
    implements ITreeIndexAccessor {
        private RTree rtree;
        private RTreeOpContext ctx;
        private boolean destroyed = false;

        public RTreeAccessor(RTree rtree, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
            this.rtree = rtree;
            this.ctx = rtree.createOpContext(modificationCallback);
        }

        public void reset(RTree rtree, IModificationOperationCallback modificationCallback) {
            this.rtree = rtree;
            this.ctx.setModificationCallback(modificationCallback);
            this.ctx.reset();
        }

        public void insert(ITupleReference tuple) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.INSERT);
            this.insert(tuple, this.ctx);
        }

        public void update(ITupleReference tuple) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.UPDATE);
            this.rtree.update(tuple, this.ctx);
        }

        public void delete(ITupleReference tuple) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.DELETE);
            this.rtree.delete(tuple, this.ctx);
        }

        public RTreeSearchCursor createSearchCursor(boolean exclusive) {
            return new RTreeSearchCursor((IRTreeInteriorFrame)RTree.this.interiorFrameFactory.createFrame(), (IRTreeLeafFrame)RTree.this.leafFrameFactory.createFrame());
        }

        public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.SEARCH);
            this.rtree.search((ITreeIndexCursor)cursor, searchPred, this.ctx);
        }

        public ITreeIndexCursor createDiskOrderScanCursor() {
            return new TreeIndexDiskOrderScanCursor(RTree.this.leafFrameFactory.createFrame());
        }

        public void diskOrderScan(ITreeIndexCursor cursor) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.DISKORDERSCAN);
            this.rtree.diskOrderScan(cursor, this.ctx);
        }

        public RTreeOpContext getOpContext() {
            return this.ctx;
        }

        public void upsert(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("The RTree does not support the notion of keys, therefore upsert does not make sense.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insert(ITupleReference tuple, IIndexOperationContext ictx) throws HyracksDataException {
            int i;
            RTreeOpContext ctx = (RTreeOpContext)ictx;
            int tupleSize = Math.max(ctx.getLeafFrame().getBytesRequiredToWriteTuple(tuple), ctx.getInteriorFrame().getBytesRequiredToWriteTuple(tuple));
            if (tupleSize > RTree.this.maxTupleSize) {
                throw HyracksDataException.create((int)43, (Serializable[])new Serializable[]{Integer.valueOf(tupleSize), Integer.valueOf(RTree.this.maxTupleSize)});
            }
            ctx.reset();
            ctx.setTuple(tuple);
            ctx.getSplitKey().reset();
            ctx.getSplitKey().getLeftTuple().setFieldCount(RTree.this.cmpFactories.length);
            ctx.getSplitKey().getRightTuple().setFieldCount(RTree.this.cmpFactories.length);
            ctx.getModificationCallback().before(tuple);
            int maxFieldPos = RTree.this.cmpFactories.length / 2;
            for (int i2 = 0; i2 < maxFieldPos; ++i2) {
                int j = maxFieldPos + i2;
                int c = ctx.getCmp().getComparators()[i2].compare(tuple.getFieldData(i2), tuple.getFieldStart(i2), tuple.getFieldLength(i2), tuple.getFieldData(j), tuple.getFieldStart(j), tuple.getFieldLength(j));
                if (c <= 0) continue;
                throw new IllegalArgumentException("The low key point has larger coordinates than the high key point.");
            }
            try {
                ICachedPage leafNode = RTree.this.findLeaf(ctx);
                int pageId = ctx.getPathList().getLastPageId();
                ctx.getPathList().moveLast();
                RTree.this.insertTuple(leafNode, pageId, ctx.getTuple(), ctx, true);
                while (ctx.getSplitKey().getLeftPageBuffer() != null) {
                    RTree.this.updateParentForInsert(ctx);
                }
            }
            catch (Throwable throwable) {
                ICachedPage node;
                int i3;
                for (i3 = ctx.getNSNUpdates().size() - 1; i3 >= 0; --i3) {
                    node = ctx.getNSNUpdates().get(i3);
                    ctx.getInteriorFrame().setPage(node);
                    ctx.getInteriorFrame().setPageNsn(RTree.this.incrementGlobalNsn());
                }
                for (i3 = ctx.getLSNUpdates().size() - 1; i3 >= 0; --i3) {
                    node = ctx.getLSNUpdates().get(i3);
                    ctx.getInteriorFrame().setPage(node);
                    ctx.getInteriorFrame().setPageLsn(RTree.this.incrementGlobalNsn());
                    node.releaseWriteLatch(true);
                    RTree.this.bufferCache.unpin(node);
                }
                throw throwable;
            }
            for (i = ctx.getNSNUpdates().size() - 1; i >= 0; --i) {
                ICachedPage node = ctx.getNSNUpdates().get(i);
                ctx.getInteriorFrame().setPage(node);
                ctx.getInteriorFrame().setPageNsn(RTree.this.incrementGlobalNsn());
            }
            for (i = ctx.getLSNUpdates().size() - 1; i >= 0; --i) {
                ICachedPage node = ctx.getLSNUpdates().get(i);
                ctx.getInteriorFrame().setPage(node);
                ctx.getInteriorFrame().setPageLsn(RTree.this.incrementGlobalNsn());
                node.releaseWriteLatch(true);
                RTree.this.bufferCache.unpin(node);
            }
        }

        public void destroy() throws HyracksDataException {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            this.ctx.destroy();
        }
    }
}

