/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.PrimaryKeyVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.rewriter.util.PhysicalOptimizationsUtil;

public class EquivalenceClassUtils {
    public static void addEquivalenceClassesForPrimaryIndexAccess(ILogicalOperator operator, List<LogicalVariable> indexSearchVars, ARecordType recordType, ARecordType metaRecordType, Dataset dataset, IOptimizationContext context) throws AlgebricksException {
        if (dataset.getDatasetDetails().getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
            return;
        }
        InternalDatasetDetails datasetDetails = (InternalDatasetDetails)dataset.getDatasetDetails();
        List primaryKey = datasetDetails.getPrimaryKey();
        HashMap<String, Integer> fieldNameToIndexMap = new HashMap<String, Integer>();
        String[] fieldNames = recordType.getFieldNames();
        for (int fieldIndex = 0; fieldIndex < fieldNames.length; ++fieldIndex) {
            fieldNameToIndexMap.put(fieldNames[fieldIndex], fieldIndex);
        }
        boolean hasMeta = dataset.hasMetaPart();
        HashMap<String, Integer> metaFieldNameToIndexMap = new HashMap<String, Integer>();
        if (hasMeta) {
            String[] metaFieldNames = metaRecordType.getFieldNames();
            for (int metaFieldIndex = 0; metaFieldIndex < metaFieldNames.length; ++metaFieldIndex) {
                metaFieldNameToIndexMap.put(metaFieldNames[metaFieldIndex], metaFieldIndex);
            }
        }
        List keySourceIndicators = datasetDetails.getKeySourceIndicator();
        LogicalVariable recordVar = hasMeta ? indexSearchVars.get(indexSearchVars.size() - 2) : indexSearchVars.get(indexSearchVars.size() - 1);
        LogicalVariable metaRecordVar = hasMeta ? indexSearchVars.get(indexSearchVars.size() - 1) : null;
        for (int pkIndex = 0; pkIndex < primaryKey.size(); ++pkIndex) {
            Integer fieldIndexInRecord;
            LogicalVariable referredRecordVar = recordVar;
            String pkFieldName = (String)((List)primaryKey.get(pkIndex)).get(0);
            int source = (Integer)keySourceIndicators.get(pkIndex);
            if (source == 0) {
                fieldIndexInRecord = (Integer)fieldNameToIndexMap.get(pkFieldName);
            } else {
                referredRecordVar = metaRecordVar;
                fieldIndexInRecord = (Integer)metaFieldNameToIndexMap.get(pkFieldName);
            }
            LogicalVariable var = indexSearchVars.get(pkIndex);
            ScalarFunctionCallExpression expr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(referredRecordVar)), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(fieldIndexInRecord.intValue()))))});
            EquivalenceClass equivClass = new EquivalenceClass(Collections.singletonList(var), var, Collections.singletonList(expr));
            HashMap<LogicalVariable, EquivalenceClass> equivalenceMap = context.getEquivalenceClassMap(operator);
            if (equivalenceMap == null) {
                equivalenceMap = new HashMap<LogicalVariable, EquivalenceClass>();
                context.putEquivalenceClassMap(operator, equivalenceMap);
            }
            equivalenceMap.put(var, equivClass);
        }
    }

    public static Pair<ILogicalOperator, Set<LogicalVariable>> findOrCreatePrimaryKeyOpAndVariables(ILogicalOperator operator, boolean usedForCorrelationJoin, IOptimizationContext context) throws AlgebricksException {
        EquivalenceClassUtils.computePrimaryKeys(operator, context);
        HashSet liveVars = new HashSet();
        VariableUtilities.getSubplanLocalLiveVariables((ILogicalOperator)operator, liveVars);
        HashSet primaryKeyVars = new HashSet();
        HashSet<LogicalVariable> noKeyVars = new HashSet<LogicalVariable>();
        for (LogicalVariable liveVar : liveVars) {
            List keyVars = context.findPrimaryKey(liveVar);
            if (keyVars != null) {
                keyVars.retainAll(liveVars);
            }
            if (keyVars == null || keyVars.isEmpty()) {
                noKeyVars.add(liveVar);
                continue;
            }
            primaryKeyVars.addAll(keyVars);
        }
        primaryKeyVars.retainAll(liveVars);
        if (primaryKeyVars.containsAll(noKeyVars)) {
            return new Pair((Object)operator, primaryKeyVars);
        }
        LogicalVariable assignVar = context.newVar();
        AssignOperator assignOp = new AssignOperator(assignVar, (Mutable)new MutableObject((Object)new StatefulFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_QUERY_UID), null)));
        OperatorPropertiesUtil.markMovable((ILogicalOperator)assignOp, (!usedForCorrelationJoin ? 1 : 0) != 0);
        assignOp.getInputs().add(new MutableObject((Object)operator));
        context.addPrimaryKey(new FunctionalDependency(Collections.singletonList(assignVar), new ArrayList(liveVars)));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        return new Pair((Object)assignOp, Collections.singleton(assignVar));
    }

    private static void computePrimaryKeys(ILogicalOperator op, IOptimizationContext ctx) throws AlgebricksException {
        PrimaryKeyVariablesVisitor visitor = new PrimaryKeyVariablesVisitor();
        PhysicalOptimizationsUtil.visitOperatorAndItsDescendants((ILogicalOperator)op, (ILogicalOperatorVisitor)visitor, (IOptimizationContext)ctx);
    }
}

