/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.subplan;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.subplan.SubplanFlatteningUtil;
import org.apache.asterix.optimizer.rules.util.EquivalenceClassUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class InlineSubplanInputForNestedTupleSourceRule
implements IAlgebraicRewriteRule {
    private boolean hasRun = false;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.hasRun) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> result = this.rewriteSubplanOperator(opRef, context);
        this.hasRun = true;
        return (Boolean)result.first;
    }

    private Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> rewriteSubplanOperator(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> changedAndVarMap = this.traverseNonSubplanOperator((ILogicalOperator)op, context);
        if (op.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return changedAndVarMap;
        }
        Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> result = this.applySpecialFlattening(opRef, context);
        if (!((Boolean)result.first).booleanValue()) {
            result = this.applyGeneralFlattening(opRef, context);
        }
        LinkedHashMap returnedMap = new LinkedHashMap();
        returnedMap.putAll((Map)changedAndVarMap.second);
        returnedMap.putAll((Map)result.second);
        return new Pair((Object)((Boolean)result.first != false || (Boolean)changedAndVarMap.first != false ? 1 : 0), returnedMap);
    }

    private Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> traverseNonSubplanOperator(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        HashSet liveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)op, liveVars);
        LinkedHashMap replacedVarMap = new LinkedHashMap();
        LinkedHashMap replacedVarMapForAncestor = new LinkedHashMap();
        boolean changed = false;
        for (Mutable childrenRef : op.getInputs()) {
            Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> resultFromChild = this.rewriteSubplanOperator((Mutable<ILogicalOperator>)childrenRef, context);
            changed = changed || (Boolean)resultFromChild.first != false;
            ((LinkedHashMap)resultFromChild.second).forEach((oldVar, newVar) -> {
                if (liveVars.contains(oldVar)) {
                    replacedVarMapForAncestor.put(oldVar, newVar);
                    oldVar = newVar;
                    while ((newVar = (LogicalVariable)((LinkedHashMap)resultFromChild.second).get(newVar)) != null) {
                        replacedVarMapForAncestor.put(oldVar, newVar);
                        oldVar = newVar;
                    }
                }
            });
            replacedVarMap.putAll((Map)resultFromChild.second);
        }
        VariableUtilities.substituteVariables((ILogicalOperator)op, replacedVarMap, (ITypingContext)context);
        context.computeAndSetTypeEnvironmentForOperator(op);
        return new Pair((Object)changed, replacedVarMapForAncestor);
    }

    private Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> applyGeneralFlattening(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        SubplanOperator subplanOp = (SubplanOperator)opRef.getValue();
        if (!SubplanFlatteningUtil.containsOperators(subplanOp, EnumSet.of(LogicalOperatorTag.DATASOURCESCAN, LogicalOperatorTag.INNERJOIN, LogicalOperatorTag.LEFTOUTERJOIN))) {
            return new Pair((Object)false, new LinkedHashMap());
        }
        Mutable inputOpRef = (Mutable)subplanOp.getInputs().get(0);
        ILogicalOperator inputOpBackup = (ILogicalOperator)inputOpRef.getValue();
        Pair<ILogicalOperator, Set<LogicalVariable>> primaryOpAndVars = EquivalenceClassUtils.findOrCreatePrimaryKeyOpAndVariables(inputOpBackup, true, context);
        ILogicalOperator inputOp = (ILogicalOperator)primaryOpAndVars.first;
        Set primaryKeyVars = (Set)primaryOpAndVars.second;
        inputOpRef.setValue((Object)inputOp);
        HashSet inputLiveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)inputOp, inputLiveVars);
        Pair<Map<LogicalVariable, LogicalVariable>, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>> varMapAndOrderExprs = SubplanFlatteningUtil.inlineAllNestedTupleSource(subplanOp, context);
        Map varMap = (Map)varMapAndOrderExprs.first;
        if (varMap == null) {
            inputOpRef.setValue((Object)inputOpBackup);
            return new Pair((Object)false, new LinkedHashMap());
        }
        MutableObject lowestAggregateRefInSubplan = SubplanFlatteningUtil.findLowestAggregate((Mutable<ILogicalOperator>)((Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0)));
        Mutable rightInputOpRef = (Mutable)((ILogicalOperator)lowestAggregateRefInSubplan.getValue()).getInputs().get(0);
        ILogicalOperator rightInputOp = (ILogicalOperator)rightInputOpRef.getValue();
        LogicalVariable assignVar = context.newVar();
        AssignOperator assignOp = new AssignOperator(assignVar, (Mutable)new MutableObject((Object)ConstantExpression.TRUE));
        assignOp.getInputs().add(rightInputOpRef);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        rightInputOpRef = new MutableObject((Object)assignOp);
        ArrayList<MutableObject> joinPredicates = new ArrayList<MutableObject>();
        for (LogicalVariable liveVar : primaryKeyVars) {
            ArrayList<MutableObject> arguments = new ArrayList<MutableObject>();
            arguments.add(new MutableObject((Object)new VariableReferenceExpression(liveVar)));
            LogicalVariable rightVar = (LogicalVariable)varMap.get(liveVar);
            arguments.add(new MutableObject((Object)new VariableReferenceExpression(rightVar)));
            ScalarFunctionCallExpression expr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.EQ), arguments);
            joinPredicates.add(new MutableObject((Object)expr));
        }
        ScalarFunctionCallExpression joinExpr = joinPredicates.size() > 1 ? new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND), joinPredicates) : (joinPredicates.size() > 0 ? (ILogicalExpression)((Mutable)joinPredicates.get(0)).getValue() : ConstantExpression.TRUE);
        LeftOuterJoinOperator leftOuterJoinOp = new LeftOuterJoinOperator((Mutable)new MutableObject((Object)joinExpr), inputOpRef, rightInputOpRef);
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)rightInputOp, (ITypingContext)context);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)leftOuterJoinOp);
        ArrayList<Pair> groupByList = new ArrayList<Pair>();
        ArrayList<Pair> groupByDecorList = new ArrayList<Pair>();
        ArrayList<ALogicalPlanImpl> nestedPlans = new ArrayList<ALogicalPlanImpl>();
        GroupByOperator groupbyOp = new GroupByOperator(groupByList, groupByDecorList, nestedPlans);
        LinkedHashMap<LogicalVariable, LogicalVariable> replacedVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        for (LogicalVariable liveVar : primaryKeyVars) {
            LogicalVariable newVar = context.newVar();
            groupByList.add(new Pair((Object)newVar, (Object)new MutableObject((Object)new VariableReferenceExpression(liveVar))));
            replacedVarMap.put(liveVar, newVar);
        }
        for (LogicalVariable liveVar : inputLiveVars) {
            if (primaryKeyVars.contains(liveVar)) continue;
            groupByDecorList.add(new Pair(null, (Object)new MutableObject((Object)new VariableReferenceExpression(liveVar))));
        }
        Mutable aggOpRef = (Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0);
        ((ILogicalOperator)lowestAggregateRefInSubplan.getValue()).getInputs().clear();
        MutableObject currentOpRef = lowestAggregateRefInSubplan;
        List orderExprs = (List)varMapAndOrderExprs.second;
        if (!orderExprs.isEmpty()) {
            OrderOperator orderOp = new OrderOperator(orderExprs);
            currentOpRef = new MutableObject((Object)orderOp);
            ((ILogicalOperator)lowestAggregateRefInSubplan.getValue()).getInputs().add(currentOpRef);
        }
        MutableObject filterVarExpr = new MutableObject((Object)new VariableReferenceExpression(assignVar));
        ArrayList<MutableObject> args = new ArrayList<MutableObject>();
        args.add(filterVarExpr);
        ArrayList<MutableObject> argsForNotFunction = new ArrayList<MutableObject>();
        argsForNotFunction.add(new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.IS_MISSING), args)));
        SelectOperator selectOp = new SelectOperator((Mutable)new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), argsForNotFunction)), false, null);
        ((ILogicalOperator)currentOpRef.getValue()).getInputs().add(new MutableObject((Object)selectOp));
        selectOp.getInputs().add(new MutableObject((Object)new NestedTupleSourceOperator((Mutable)new MutableObject((Object)groupbyOp))));
        ArrayList<Mutable> nestedRoots = new ArrayList<Mutable>();
        nestedRoots.add(aggOpRef);
        nestedPlans.add(new ALogicalPlanImpl(nestedRoots));
        groupbyOp.getInputs().add(new MutableObject((Object)leftOuterJoinOp));
        opRef.setValue((Object)groupbyOp);
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)groupbyOp, (ITypingContext)context);
        Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> result = this.rewriteSubplanOperator((Mutable<ILogicalOperator>)rightInputOpRef, context);
        VariableUtilities.substituteVariables((ILogicalOperator)leftOuterJoinOp, (LinkedHashMap)((LinkedHashMap)result.second), (ITypingContext)context);
        VariableUtilities.substituteVariables((ILogicalOperator)groupbyOp, (LinkedHashMap)((LinkedHashMap)result.second), (ITypingContext)context);
        return new Pair((Object)true, replacedVarMap);
    }

    private Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> applySpecialFlattening(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        SubplanOperator subplanOp = (SubplanOperator)opRef.getValue();
        Mutable inputOpRef = (Mutable)subplanOp.getInputs().get(0);
        LinkedHashMap<LogicalVariable, LogicalVariable> replacedVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> result = this.rewriteSubplanOperator((Mutable<ILogicalOperator>)((Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0)), context);
        ILogicalOperator inputOpBackup = (ILogicalOperator)inputOpRef.getValue();
        Pair<ILogicalOperator, Set<LogicalVariable>> primaryOpAndVars = EquivalenceClassUtils.findOrCreatePrimaryKeyOpAndVariables(inputOpBackup, false, context);
        ILogicalOperator inputOp = (ILogicalOperator)primaryOpAndVars.first;
        Set primaryKeyVars = (Set)primaryOpAndVars.second;
        inputOpRef.setValue((Object)inputOp);
        HashSet liveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)inputOp, liveVars);
        Pair<Set<LogicalVariable>, Mutable<ILogicalOperator>> notNullVarsAndTopJoinRef = SubplanFlatteningUtil.inlineLeftNtsInSubplanJoin(subplanOp, context);
        if (notNullVarsAndTopJoinRef.first == null) {
            inputOpRef.setValue((Object)inputOpBackup);
            return new Pair((Object)false, replacedVarMap);
        }
        Set notNullVars = (Set)notNullVarsAndTopJoinRef.first;
        Mutable topJoinRef = (Mutable)notNullVarsAndTopJoinRef.second;
        ArrayList<Pair> groupByList = new ArrayList<Pair>();
        ArrayList<Pair> groupByDecorList = new ArrayList<Pair>();
        GroupByOperator groupbyOp = new GroupByOperator(groupByList, groupByDecorList, subplanOp.getNestedPlans());
        for (LogicalVariable coverVar : primaryKeyVars) {
            LogicalVariable newVar = context.newVar();
            groupByList.add(new Pair((Object)newVar, (Object)new MutableObject((Object)new VariableReferenceExpression(coverVar))));
            replacedVarMap.put(coverVar, newVar);
        }
        for (Object liveVar : liveVars) {
            if (primaryKeyVars.contains(liveVar)) continue;
            groupByDecorList.add(new Pair(null, (Object)new MutableObject((Object)new VariableReferenceExpression((LogicalVariable)liveVar))));
        }
        groupbyOp.getInputs().add(new MutableObject(topJoinRef.getValue()));
        if (!notNullVars.isEmpty()) {
            ArrayList<MutableObject> nullCheckExprRefs = new ArrayList<MutableObject>();
            for (LogicalVariable notNullVar : notNullVars) {
                MutableObject filterVarExpr = new MutableObject((Object)new VariableReferenceExpression(notNullVar));
                ArrayList<MutableObject> args = new ArrayList<MutableObject>();
                args.add(filterVarExpr);
                ArrayList<MutableObject> argsForNotFunction = new ArrayList<MutableObject>();
                argsForNotFunction.add(new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.IS_MISSING), args)));
                nullCheckExprRefs.add(new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), argsForNotFunction)));
            }
            MutableObject selectExprRef = nullCheckExprRefs.size() > 1 ? new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), nullCheckExprRefs)) : (Mutable)nullCheckExprRefs.get(0);
            SelectOperator selectOp = new SelectOperator((Mutable)selectExprRef, false, null);
            topJoinRef.setValue((Object)selectOp);
            selectOp.getInputs().add(new MutableObject((Object)new NestedTupleSourceOperator((Mutable)new MutableObject((Object)groupbyOp))));
        } else {
            topJoinRef.setValue((Object)new NestedTupleSourceOperator((Mutable)new MutableObject((Object)groupbyOp)));
        }
        opRef.setValue((Object)groupbyOp);
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)groupbyOp, (ITypingContext)context);
        VariableUtilities.substituteVariables((ILogicalOperator)groupbyOp, (LinkedHashMap)((LinkedHashMap)result.second), (ITypingContext)context);
        replacedVarMap.putAll((Map)result.second);
        return new Pair((Object)true, replacedVarMap);
    }
}

