/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.BTreeJobGenParams;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroducePrimaryIndexForAggregationRule
implements IAlgebraicRewriteRule {
    private final List<Mutable<ILogicalOperator>> parents = new ArrayList<Mutable<ILogicalOperator>>();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        this.parents.add(opRef);
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        this.parents.remove(this.parents.size() - 1);
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        if (((ILogicalOperator)opRef.getValue()).getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator localAggregateOperator = (AggregateOperator)opRef.getValue();
        if (localAggregateOperator.isGlobal()) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue());
        Pair<Mutable<ILogicalOperator>, Mutable<ILogicalOperator>> scanAndAssignOpRef = this.findScanAndAssignOperator((ILogicalOperator)localAggregateOperator, context.getMetadataProvider());
        if (scanAndAssignOpRef == null) {
            return false;
        }
        boolean transformed = this.replaceDatascan(localAggregateOperator, scanAndAssignOpRef, context);
        if (transformed) {
            OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        }
        return transformed;
    }

    private Pair<Mutable<ILogicalOperator>, Mutable<ILogicalOperator>> findScanAndAssignOperator(ILogicalOperator localAggregateOperator, IMetadataProvider metadataProvider) throws AlgebricksException {
        Mutable scanOpRef = (Mutable)localAggregateOperator.getInputs().get(0);
        MutableObject assignOpRef = null;
        if (((ILogicalOperator)scanOpRef.getValue()).getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator assignOperator = (AssignOperator)scanOpRef.getValue();
            assignOpRef = new MutableObject((Object)assignOperator);
            scanOpRef = (Mutable)((ILogicalOperator)scanOpRef.getValue()).getInputs().get(0);
        }
        if (((ILogicalOperator)scanOpRef.getValue()).getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN && ((ILogicalOperator)scanOpRef.getValue()).getOperatorTag() != LogicalOperatorTag.UNNEST_MAP) {
            return null;
        }
        if (((ILogicalOperator)scanOpRef.getValue()).getOperatorTag() == LogicalOperatorTag.UNNEST_MAP) {
            String datasetName;
            UnnestMapOperator unnestMapOperator = (UnnestMapOperator)scanOpRef.getValue();
            ILogicalExpression logicalExpression = (ILogicalExpression)unnestMapOperator.getExpressionRef().getValue();
            if (logicalExpression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                return null;
            }
            AbstractFunctionCallExpression functionCallExpression = (AbstractFunctionCallExpression)logicalExpression;
            if (functionCallExpression.getFunctionIdentifier() != BuiltinFunctions.INDEX_SEARCH) {
                return null;
            }
            String indexName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)functionCallExpression, (int)0);
            String dataverseName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)functionCallExpression, (int)2);
            Index index = ((MetadataProvider)metadataProvider).getIndex(dataverseName, datasetName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)functionCallExpression, (int)3), indexName);
            if (!index.isPrimaryIndex()) {
                return null;
            }
        }
        return Pair.of((Object)scanOpRef, (Object)assignOpRef);
    }

    private boolean replaceDatascan(AggregateOperator localAggregateOperator, Pair<Mutable<ILogicalOperator>, Mutable<ILogicalOperator>> scanAndAssignOpRef, IOptimizationContext context) throws AlgebricksException {
        BTreeJobGenParams originalBTreeParameters;
        Mutable scanOperatorRef = (Mutable)scanAndAssignOpRef.getLeft();
        Mutable assignOperatorRef = (Mutable)scanAndAssignOpRef.getRight();
        AbstractScanOperator scanOperator = (AbstractScanOperator)scanOperatorRef.getValue();
        Pair<Dataset, Index> datasetAndIndex = this.findDatasetAndSecondaryPrimaryIndex(scanOperator, originalBTreeParameters = new BTreeJobGenParams(), context);
        if (datasetAndIndex == null) {
            return false;
        }
        Dataset dataset = (Dataset)datasetAndIndex.getLeft();
        Index primaryIndex = (Index)datasetAndIndex.getRight();
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            BTreeJobGenParams newBTreeParameters;
            boolean retainInput;
            Set<LogicalVariable> variablesProducedByScanOp = this.getVariablesProducedByScanOp(scanOperator, dataset.getPrimaryKeys().size(), scanOperator.getVariables().size());
            boolean variablesAreUsed = this.scanOperatorVariablesAreUsed(localAggregateOperator, (Mutable<ILogicalOperator>)assignOperatorRef, variablesProducedByScanOp);
            if (variablesAreUsed) {
                return false;
            }
            if (scanOperator.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
                retainInput = AccessMethodUtils.retainInputs(scanOperator.getVariables(), (ILogicalOperator)scanOperator, this.parents);
                newBTreeParameters = new BTreeJobGenParams(primaryIndex.getIndexName(), DatasetConfig.IndexType.BTREE, dataset.getDataverseName(), dataset.getDatasetName(), retainInput, ((ILogicalOperator)((Mutable)scanOperator.getInputs().get(0)).getValue()).getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED);
                ArrayList<LogicalVariable> empty = new ArrayList<LogicalVariable>();
                newBTreeParameters.setLowKeyInclusive(true);
                newBTreeParameters.setHighKeyInclusive(true);
                newBTreeParameters.setIsEqCondition(false);
                newBTreeParameters.setLowKeyVarList(empty, 0, 0);
                newBTreeParameters.setHighKeyVarList(empty, 0, 0);
            } else {
                retainInput = originalBTreeParameters.getRetainInput();
                newBTreeParameters = new BTreeJobGenParams(primaryIndex.getIndexName(), DatasetConfig.IndexType.BTREE, dataset.getDataverseName(), dataset.getDatasetName(), retainInput, originalBTreeParameters.getRequiresBroadcast());
                newBTreeParameters.setLowKeyInclusive(originalBTreeParameters.isLowKeyInclusive());
                newBTreeParameters.setHighKeyInclusive(originalBTreeParameters.isHighKeyInclusive());
                newBTreeParameters.setIsEqCondition(originalBTreeParameters.isEqCondition());
                newBTreeParameters.setLowKeyVarList(originalBTreeParameters.getLowKeyVarList(), 0, originalBTreeParameters.getLowKeyVarList().size());
                newBTreeParameters.setHighKeyVarList(originalBTreeParameters.getHighKeyVarList(), 0, originalBTreeParameters.getHighKeyVarList().size());
            }
            ARecordType recordType = (ARecordType)((MetadataProvider)context.getMetadataProvider()).findType(dataset);
            ARecordType metaRecordType = (ARecordType)((MetadataProvider)context.getMetadataProvider()).findMetaType(dataset);
            AbstractUnnestMapOperator primaryIndexUnnestOperator = (AbstractUnnestMapOperator)AccessMethodUtils.createSecondaryIndexUnnestMap(dataset, recordType, metaRecordType, primaryIndex, (ILogicalOperator)((Mutable)scanOperator.getInputs().get(0)).getValue(), newBTreeParameters, context, retainInput, false, false);
            primaryIndexUnnestOperator.getVariables().clear();
            for (int i = 0; i < dataset.getPrimaryKeys().size(); ++i) {
                primaryIndexUnnestOperator.getVariables().add(scanOperator.getVariables().get(i));
            }
            scanOperatorRef.setValue((Object)primaryIndexUnnestOperator);
            return true;
        }
        return false;
    }

    private Pair<Dataset, Index> findDatasetAndSecondaryPrimaryIndex(AbstractScanOperator scanOperator, BTreeJobGenParams originalBTreeParameters, IOptimizationContext context) throws AlgebricksException {
        Dataset dataset;
        if (scanOperator.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            DataSourceScanOperator dss = (DataSourceScanOperator)scanOperator;
            DataSource ds = (DataSource)dss.getDataSource();
            if (ds.getDatasourceType() != 0) {
                return null;
            }
            dataset = ((DatasetDataSource)ds).getDataset();
        } else {
            AbstractFunctionCallExpression primaryIndexFunctionCall = (AbstractFunctionCallExpression)((UnnestMapOperator)scanOperator).getExpressionRef().getValue();
            originalBTreeParameters.readFromFuncArgs(primaryIndexFunctionCall.getArguments());
            if (originalBTreeParameters.isEqCondition()) {
                return null;
            }
            dataset = ((MetadataProvider)context.getMetadataProvider()).findDataset(originalBTreeParameters.getDataverseName(), originalBTreeParameters.getDatasetName());
        }
        List indexes = ((MetadataProvider)context.getMetadataProvider()).getDatasetIndexes(dataset.getDataverseName(), dataset.getDatasetName());
        for (Index index : indexes) {
            if (!index.getKeyFieldNames().isEmpty()) continue;
            return Pair.of((Object)dataset, (Object)index);
        }
        return null;
    }

    private Set<LogicalVariable> getVariablesProducedByScanOp(AbstractScanOperator scanOperator, int startPosition, int endPosition) {
        HashSet<LogicalVariable> variableSet = new HashSet<LogicalVariable>();
        for (int i = startPosition; i < endPosition; ++i) {
            variableSet.add((LogicalVariable)scanOperator.getVariables().get(i));
        }
        return variableSet;
    }

    private boolean scanOperatorVariablesAreUsed(AggregateOperator localAggregateOperator, Mutable<ILogicalOperator> assignOperatorRef, Set<LogicalVariable> variablesProducedByScanOp) throws AlgebricksException {
        HashSet variablesUsedByParents = new HashSet();
        for (Mutable<ILogicalOperator> parent : this.parents) {
            VariableUtilities.getUsedVariables((ILogicalOperator)((ILogicalOperator)parent.getValue()), variablesUsedByParents);
        }
        VariableUtilities.getUsedVariables((ILogicalOperator)localAggregateOperator, variablesUsedByParents);
        if (assignOperatorRef != null) {
            VariableUtilities.getUsedVariables((ILogicalOperator)((ILogicalOperator)assignOperatorRef.getValue()), variablesUsedByParents);
        }
        for (LogicalVariable producedVariable : variablesProducedByScanOp) {
            if (!variablesUsedByParents.contains(producedVariable)) continue;
            return true;
        }
        return false;
    }
}

