/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.dataflow.data.common.ExpressionTypeComputer;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.base.AnalysisUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.BTreeAccessMethod;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.InvertedIndexAccessMethod;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.asterix.optimizer.rules.am.RTreeAccessMethod;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractDataSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public abstract class AbstractIntroduceAccessMethodRule
implements IAlgebraicRewriteRule {
    public static final String NO_INDEX_ONLY_PLAN_OPTION = "noindexonly";
    public static final boolean NO_INDEX_ONLY_PLAN_OPTION_DEFAULT_VALUE = false;
    protected MetadataProvider metadataProvider;
    private final ImmutableSet<FunctionIdentifier> funcIDSetThatRetainFieldName = ImmutableSet.of((Object)BuiltinFunctions.WORD_TOKENS, (Object)BuiltinFunctions.GRAM_TOKENS, (Object)BuiltinFunctions.SUBSTRING, (Object)BuiltinFunctions.SUBSTRING_BEFORE, (Object)BuiltinFunctions.SUBSTRING_AFTER, (Object)BuiltinFunctions.CREATE_POLYGON, (Object[])new FunctionIdentifier[]{BuiltinFunctions.CREATE_MBR, BuiltinFunctions.CREATE_RECTANGLE, BuiltinFunctions.CREATE_CIRCLE, BuiltinFunctions.CREATE_LINE, BuiltinFunctions.CREATE_POINT, BuiltinFunctions.NUMERIC_ADD, BuiltinFunctions.NUMERIC_SUBTRACT, BuiltinFunctions.NUMERIC_MULTIPLY, BuiltinFunctions.NUMERIC_DIVIDE, BuiltinFunctions.NUMERIC_MOD});

    public abstract Map<FunctionIdentifier, List<IAccessMethod>> getAccessMethods();

    protected static void registerAccessMethod(IAccessMethod accessMethod, Map<FunctionIdentifier, List<IAccessMethod>> accessMethods) {
        List<Pair<FunctionIdentifier, Boolean>> funcs = accessMethod.getOptimizableFunctions();
        for (Pair<FunctionIdentifier, Boolean> funcIdent : funcs) {
            List<IAccessMethod> l = accessMethods.get(funcIdent.first);
            if (l == null) {
                l = new ArrayList<IAccessMethod>();
                accessMethods.put((FunctionIdentifier)funcIdent.first, l);
            }
            l.add(accessMethod);
        }
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    protected void setMetadataDeclarations(IOptimizationContext context) {
        this.metadataProvider = (MetadataProvider)context.getMetadataProvider();
    }

    protected void fillSubTreeIndexExprs(OptimizableOperatorSubTree subTree, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context) throws AlgebricksException {
        this.fillSubTreeIndexExprs(subTree, analyzedAMs, context, false);
    }

    protected void fillSubTreeIndexExprs(OptimizableOperatorSubTree subTree, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context, boolean isArbitraryFormOfSubtree) throws AlgebricksException {
        for (Map.Entry<IAccessMethod, AccessMethodAnalysisContext> entry : analyzedAMs.entrySet()) {
            AccessMethodAnalysisContext amCtx = entry.getValue();
            if (!isArbitraryFormOfSubtree) {
                this.fillAllIndexExprs(subTree, amCtx, context);
                continue;
            }
            this.fillVarFieldTypeForOptFuncExprs(subTree, amCtx, (ITypingContext)context);
        }
    }

    protected void fillVarFieldTypeForOptFuncExprs(OptimizableOperatorSubTree subTree, AccessMethodAnalysisContext analysisCtx, ITypingContext context) throws AlgebricksException {
        ILogicalOperator rootOp = subTree.getRoot();
        IVariableTypeEnvironment envSubtree = context.getOutputTypeEnvironment(rootOp);
        HashSet liveVarsAtRootOp = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)rootOp, liveVarsAtRootOp);
        for (IOptimizableFuncExpr optFuncExpr : analysisCtx.getMatchedFuncExprs()) {
            for (LogicalVariable var : liveVarsAtRootOp) {
                int optVarIndex = optFuncExpr.findLogicalVar(var);
                if (optVarIndex < 0) continue;
                optFuncExpr.setOptimizableSubTree(optVarIndex, subTree);
                IAType fieldType = (IAType)envSubtree.getVarType(var);
                optFuncExpr.setFieldType(optVarIndex, fieldType);
            }
        }
    }

    protected void pruneIndexCandidates(Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        Iterator<Map.Entry<IAccessMethod, AccessMethodAnalysisContext>> amIt = analyzedAMs.entrySet().iterator();
        while (amIt.hasNext()) {
            Map.Entry<IAccessMethod, AccessMethodAnalysisContext> entry = amIt.next();
            AccessMethodAnalysisContext amCtx = entry.getValue();
            this.pruneIndexCandidates(entry.getKey(), amCtx, context, typeEnvironment);
            if (!amCtx.isIndexExprsAndVarsEmpty()) continue;
            amIt.remove();
        }
    }

    protected Pair<IAccessMethod, Index> chooseBestIndex(Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs) {
        List<Pair<IAccessMethod, Index>> list = this.chooseAllIndexes(analyzedAMs);
        return list.isEmpty() ? null : list.get(0);
    }

    protected List<Pair<IAccessMethod, Index>> chooseAllIndexes(Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs) {
        ArrayList<Pair<IAccessMethod, Index>> result = new ArrayList<Pair<IAccessMethod, Index>>();
        HashMap resultVarsToIndexTypesMap = new HashMap();
        for (Map.Entry<IAccessMethod, AccessMethodAnalysisContext> amEntry : analyzedAMs.entrySet()) {
            AccessMethodAnalysisContext analysisCtx = amEntry.getValue();
            Iterator<Map.Entry<Index, List<Pair<Integer, Integer>>>> indexIt = analysisCtx.getIteratorForIndexExprsAndVars();
            while (indexIt.hasNext()) {
                boolean isKeywordOrNgramIndexChosen;
                Map.Entry<Index, List<Pair<Integer, Integer>>> indexEntry = indexIt.next();
                IAccessMethod chosenAccessMethod = amEntry.getKey();
                Index chosenIndex = indexEntry.getKey();
                DatasetConfig.IndexType indexType = chosenIndex.getIndexType();
                boolean bl = isKeywordOrNgramIndexChosen = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX || indexType == DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX || indexType == DatasetConfig.IndexType.SINGLE_PARTITION_NGRAM_INVIX;
                if (!(chosenAccessMethod == BTreeAccessMethod.INSTANCE && indexType == DatasetConfig.IndexType.BTREE || chosenAccessMethod == RTreeAccessMethod.INSTANCE && indexType == DatasetConfig.IndexType.RTREE) && (chosenAccessMethod != InvertedIndexAccessMethod.INSTANCE || !isKeywordOrNgramIndexChosen)) continue;
                if (resultVarsToIndexTypesMap.containsKey(indexEntry.getValue())) {
                    List appliedIndexTypes = (List)resultVarsToIndexTypesMap.get(indexEntry.getValue());
                    if (appliedIndexTypes.contains(indexType)) continue;
                    appliedIndexTypes.add(indexType);
                    result.add((Pair<IAccessMethod, Index>)new Pair((Object)chosenAccessMethod, (Object)chosenIndex));
                    continue;
                }
                ArrayList<DatasetConfig.IndexType> addedIndexTypes = new ArrayList<DatasetConfig.IndexType>();
                addedIndexTypes.add(indexType);
                resultVarsToIndexTypesMap.put(indexEntry.getValue(), addedIndexTypes);
                result.add((Pair<IAccessMethod, Index>)new Pair((Object)chosenAccessMethod, (Object)chosenIndex));
            }
        }
        return result;
    }

    public void pruneIndexCandidates(IAccessMethod accessMethod, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        Iterator<Map.Entry<Index, List<Pair<Integer, Integer>>>> indexExprAndVarIt = analysisCtx.getIteratorForIndexExprsAndVars();
        int numMatchedKeys = 0;
        ArrayList<Object> matchedExpressions = new ArrayList<Object>();
        while (indexExprAndVarIt.hasNext()) {
            Map.Entry<Index, List<Pair<Integer, Integer>>> indexExprAndVarEntry = indexExprAndVarIt.next();
            Index index = indexExprAndVarEntry.getKey();
            boolean allUsed = true;
            int lastFieldMatched = -1;
            boolean foundKeyField = false;
            matchedExpressions.clear();
            numMatchedKeys = 0;
            for (int i = 0; i < index.getKeyFieldNames().size(); ++i) {
                List keyField = (List)index.getKeyFieldNames().get(i);
                final IAType keyType = (IAType)index.getKeyFieldTypes().get(i);
                Iterator<Pair<Integer, Integer>> exprsAndVarIter = indexExprAndVarEntry.getValue().iterator();
                while (exprsAndVarIter.hasNext()) {
                    int j;
                    final Pair<Integer, Integer> exprAndVarIdx = exprsAndVarIter.next();
                    final IOptimizableFuncExpr optFuncExpr = analysisCtx.getMatchedFuncExpr((Integer)exprAndVarIdx.first);
                    if (!accessMethod.exprIsOptimizable(index, optFuncExpr)) {
                        exprsAndVarIter.remove();
                        continue;
                    }
                    boolean typeMatch = true;
                    ArrayList<IAType> matchedTypes = new ArrayList<IAType>();
                    for (int j2 = 0; j2 < optFuncExpr.getNumLogicalVars(); ++j2) {
                        if (j2 == (Integer)exprAndVarIdx.second) continue;
                        matchedTypes.add(optFuncExpr.getFieldType(j2));
                    }
                    if (matchedTypes.size() < 2 && optFuncExpr.getNumLogicalVars() == 1) {
                        matchedTypes.add((IAType)ExpressionTypeComputer.INSTANCE.getType(optFuncExpr.getConstantExpr(0), context.getMetadataProvider(), typeEnvironment));
                    }
                    matchedTypes.add((IAType)ExpressionTypeComputer.INSTANCE.getType(optFuncExpr.getLogicalExpr((Integer)exprAndVarIdx.second), null, new IVariableTypeEnvironment(){

                        public Object getVarType(LogicalVariable var) throws AlgebricksException {
                            if (var.equals((Object)optFuncExpr.getSourceVar((Integer)exprAndVarIdx.second))) {
                                return keyType;
                            }
                            throw new IllegalArgumentException();
                        }

                        public Object getVarType(LogicalVariable var, List<LogicalVariable> nonNullVariables, List<List<LogicalVariable>> correlatedNullableVariableLists) throws AlgebricksException {
                            if (var.equals((Object)optFuncExpr.getSourceVar((Integer)exprAndVarIdx.second))) {
                                return keyType;
                            }
                            throw new IllegalArgumentException();
                        }

                        public void setVarType(LogicalVariable var, Object type) {
                            throw new IllegalArgumentException();
                        }

                        public Object getType(ILogicalExpression expr) throws AlgebricksException {
                            return ExpressionTypeComputer.INSTANCE.getType(expr, null, (IVariableTypeEnvironment)this);
                        }

                        public boolean substituteProducedVariable(LogicalVariable v1, LogicalVariable v2) throws AlgebricksException {
                            throw new IllegalArgumentException();
                        }
                    }));
                    boolean jaccardSimilarity = optFuncExpr.getFuncExpr().getFunctionIdentifier().getName().startsWith("similarity-jaccard-check");
                    ArrayList<IAType> elementTypes = matchedTypes;
                    if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS || optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION) {
                        for (j = 0; j < matchedTypes.size(); ++j) {
                            if (((IAType)matchedTypes.get(j)).getTypeTag() != ATypeTag.ARRAY && ((IAType)matchedTypes.get(j)).getTypeTag() != ATypeTag.MULTISET) continue;
                            elementTypes.set(j, ((AbstractCollectionType)matchedTypes.get(j)).getItemType());
                        }
                    }
                    for (j = 0; j < matchedTypes.size(); ++j) {
                        for (int k = j + 1; k < matchedTypes.size(); ++k) {
                            typeMatch &= this.isMatched((IAType)elementTypes.get(j), (IAType)elementTypes.get(k), jaccardSimilarity);
                        }
                    }
                    if (optFuncExpr.findFieldName(keyField) == -1 || !(foundKeyField = typeMatch && optFuncExpr.getOperatorSubTree((Integer)exprAndVarIdx.second).hasDataSourceScan())) continue;
                    matchedExpressions.add(exprAndVarIdx.first);
                    ++numMatchedKeys;
                    if (lastFieldMatched != i - 1) break;
                    lastFieldMatched = i;
                    break;
                }
                if (foundKeyField) continue;
                allUsed = false;
                if (lastFieldMatched < 0) break;
                exprsAndVarIter = indexExprAndVarEntry.getValue().iterator();
                while (exprsAndVarIter.hasNext()) {
                    if (matchedExpressions.contains(exprsAndVarIter.next().first)) continue;
                    exprsAndVarIter.remove();
                }
                break;
            }
            if (!allUsed && accessMethod.matchAllIndexExprs()) {
                indexExprAndVarIt.remove();
                continue;
            }
            if (accessMethod.matchPrefixIndexExprs() && lastFieldMatched < 0) {
                indexExprAndVarIt.remove();
                continue;
            }
            analysisCtx.putNumberOfMatchedKeys(index, numMatchedKeys);
        }
    }

    private boolean isMatched(IAType type1, IAType type2, boolean useListDomain) throws AlgebricksException {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (ATypeHierarchy.isSameTypeDomain((ATypeTag)((IAType)Index.getNonNullableType((IAType)type1).first).getTypeTag(), (ATypeTag)((IAType)Index.getNonNullableType((IAType)type2).first).getTypeTag(), (boolean)useListDomain)) {
            return true;
        }
        return ATypeHierarchy.canPromote((ATypeTag)((IAType)Index.getNonNullableType((IAType)type1).first).getTypeTag(), (ATypeTag)((IAType)Index.getNonNullableType((IAType)type2).first).getTypeTag());
    }

    protected boolean analyzeSelectOrJoinOpConditionAndUpdateAnalyzedAM(ILogicalExpression cond, List<AbstractLogicalOperator> assignsAndUnnests, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)cond;
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        if (funcIdent == AlgebricksBuiltinFunctions.OR) {
            return false;
        }
        if (funcIdent == AlgebricksBuiltinFunctions.AND) {
            boolean found = false;
            for (Mutable arg : funcExpr.getArguments()) {
                ILogicalExpression argExpr = (ILogicalExpression)arg.getValue();
                if (argExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                AbstractFunctionCallExpression argFuncExpr = (AbstractFunctionCallExpression)argExpr;
                boolean matchFound = this.analyzeFunctionExprAndUpdateAnalyzedAM(argFuncExpr, assignsAndUnnests, analyzedAMs, context, typeEnvironment);
                found = found || matchFound;
            }
            return found;
        }
        return this.analyzeFunctionExprAndUpdateAnalyzedAM(funcExpr, assignsAndUnnests, analyzedAMs, context, typeEnvironment);
    }

    protected boolean analyzeFunctionExprAndUpdateAnalyzedAM(AbstractFunctionCallExpression funcExpr, List<AbstractLogicalOperator> assignsAndUnnests, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        if (funcIdent == AlgebricksBuiltinFunctions.AND) {
            return false;
        }
        List<IAccessMethod> relevantAMs = this.getAccessMethods().get(funcIdent);
        if (relevantAMs == null) {
            return false;
        }
        boolean atLeastOneMatchFound = false;
        AccessMethodAnalysisContext newAnalysisCtx = new AccessMethodAnalysisContext();
        for (IAccessMethod accessMethod : relevantAMs) {
            boolean matchFound;
            AccessMethodAnalysisContext analysisCtx = analyzedAMs.get(accessMethod);
            if (analysisCtx == null) {
                analysisCtx = newAnalysisCtx;
            }
            if (!(matchFound = accessMethod.analyzeFuncExprArgsAndUpdateAnalysisCtx(funcExpr, assignsAndUnnests, analysisCtx, context, typeEnvironment))) continue;
            if (analysisCtx == newAnalysisCtx) {
                analyzedAMs.put(accessMethod, analysisCtx);
                newAnalysisCtx = new AccessMethodAnalysisContext();
            }
            atLeastOneMatchFound = true;
        }
        return atLeastOneMatchFound;
    }

    protected boolean fillIndexExprs(List<Index> datasetIndexes, List<String> fieldName, IAType fieldType, IOptimizableFuncExpr optFuncExpr, int matchedFuncExprIndex, int varIdx, OptimizableOperatorSubTree matchedSubTree, AccessMethodAnalysisContext analysisCtx) throws AlgebricksException {
        ArrayList<Index> indexCandidates = new ArrayList<Index>();
        for (Index index : datasetIndexes) {
            boolean isFieldTypeUnknown;
            if (!index.getKeyFieldNames().contains(fieldName) || index.getPendingOp() != 0) continue;
            indexCandidates.add(index);
            boolean bl = isFieldTypeUnknown = fieldType == BuiltinType.AMISSING || fieldType == BuiltinType.ANY;
            if (isFieldTypeUnknown && (!index.isOverridingKeyFieldTypes() || index.isEnforced())) {
                IAType indexedType = (IAType)index.getKeyFieldTypes().get(index.getKeyFieldNames().indexOf(fieldName));
                optFuncExpr.setFieldType(varIdx, indexedType);
            }
            analysisCtx.addIndexExpr(matchedSubTree.getDataset(), index, matchedFuncExprIndex, varIdx);
        }
        return !indexCandidates.isEmpty();
    }

    protected void fillAllIndexExprs(OptimizableOperatorSubTree subTree, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context) throws AlgebricksException {
        int optFuncExprIndex = 0;
        ArrayList<Index> datasetIndexes = new ArrayList();
        LogicalVariable datasetMetaVar = null;
        if (subTree.getDataSourceType() != OptimizableOperatorSubTree.DataSourceType.COLLECTION_SCAN && subTree.getDataSourceType() != OptimizableOperatorSubTree.DataSourceType.INDEXONLY_PLAN_SECONDARY_INDEX_LOOKUP) {
            datasetIndexes = this.metadataProvider.getDatasetIndexes(subTree.getDataset().getDataverseName(), subTree.getDataset().getDatasetName());
            List<LogicalVariable> datasetVars = subTree.getDataSourceVariables();
            if (subTree.getDataset().hasMetaPart()) {
                datasetMetaVar = datasetVars.get(datasetVars.size() - 1);
            }
        }
        for (IOptimizableFuncExpr optFuncExpr : analysisCtx.getMatchedFuncExprs()) {
            for (int assignOrUnnestIndex = 0; assignOrUnnestIndex < subTree.getAssignsAndUnnests().size(); ++assignOrUnnestIndex) {
                AbstractLogicalOperator op = subTree.getAssignsAndUnnests().get(assignOrUnnestIndex);
                if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                    this.analyzeAssignOp((AssignOperator)op, optFuncExpr, subTree, assignOrUnnestIndex, datasetMetaVar, context, datasetIndexes, optFuncExprIndex, analysisCtx);
                    continue;
                }
                this.analyzeUnnestOp((UnnestOperator)op, optFuncExpr, subTree, assignOrUnnestIndex, datasetMetaVar, context, datasetIndexes, optFuncExprIndex, analysisCtx);
            }
            List<LogicalVariable> dsVarList = subTree.getDataSourceVariables();
            this.matchVarsFromOptFuncExprToDataSourceScan(optFuncExpr, optFuncExprIndex, datasetIndexes, dsVarList, subTree, analysisCtx, context, false);
            ArrayList<LogicalVariable> additionalDsVarList = null;
            if (subTree.hasIxJoinOuterAdditionalDataSource()) {
                additionalDsVarList = new ArrayList<LogicalVariable>();
                for (int i = 0; i < subTree.getIxJoinOuterAdditionalDataSourceRefs().size(); ++i) {
                    additionalDsVarList.addAll(subTree.getIxJoinOuterAdditionalDataSourceVariables(i));
                }
                this.matchVarsFromOptFuncExprToDataSourceScan(optFuncExpr, optFuncExprIndex, datasetIndexes, additionalDsVarList, subTree, analysisCtx, context, true);
            }
            ++optFuncExprIndex;
        }
    }

    private void analyzeUnnestOp(UnnestOperator unnestOp, IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree subTree, int assignOrUnnestIndex, LogicalVariable datasetMetaVar, IOptimizationContext context, List<Index> datasetIndexes, int optFuncExprIndex, AccessMethodAnalysisContext analysisCtx) throws AlgebricksException {
        LogicalVariable var = unnestOp.getVariable();
        int funcVarIndex = optFuncExpr.findLogicalVar(var);
        if (funcVarIndex == -1) {
            return;
        }
        optFuncExpr.setOptimizableSubTree(funcVarIndex, subTree);
        List<String> fieldName = null;
        if (subTree.getDataSourceType() == OptimizableOperatorSubTree.DataSourceType.COLLECTION_SCAN) {
            optFuncExpr.setLogicalExpr(funcVarIndex, (ILogicalExpression)new VariableReferenceExpression(var));
        } else {
            fieldName = this.getFieldNameFromSubTree(optFuncExpr, subTree, assignOrUnnestIndex, 0, subTree.getRecordType(), funcVarIndex, (ILogicalExpression)((Mutable)optFuncExpr.getFuncExpr().getArguments().get(funcVarIndex)).getValue(), subTree.getMetaRecordType(), datasetMetaVar);
            if (fieldName.isEmpty()) {
                return;
            }
        }
        IAType fieldType = (IAType)context.getOutputTypeEnvironment((ILogicalOperator)unnestOp).getType(optFuncExpr.getLogicalExpr(funcVarIndex));
        optFuncExpr.setFieldName(funcVarIndex, fieldName);
        optFuncExpr.setFieldType(funcVarIndex, fieldType);
        this.setTypeTag(context, subTree, optFuncExpr, funcVarIndex);
        if (subTree.hasDataSource()) {
            this.fillIndexExprs(datasetIndexes, fieldName, fieldType, optFuncExpr, optFuncExprIndex, funcVarIndex, subTree, analysisCtx);
        }
    }

    private void analyzeAssignOp(AssignOperator assignOp, IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree subTree, int assignOrUnnestIndex, LogicalVariable datasetMetaVar, IOptimizationContext context, List<Index> datasetIndexes, int optFuncExprIndex, AccessMethodAnalysisContext analysisCtx) throws AlgebricksException {
        List varList = assignOp.getVariables();
        for (int varIndex = 0; varIndex < varList.size(); ++varIndex) {
            LogicalVariable var = (LogicalVariable)varList.get(varIndex);
            int optVarIndex = optFuncExpr.findLogicalVar(var);
            if (optVarIndex == -1) continue;
            optFuncExpr.setOptimizableSubTree(optVarIndex, subTree);
            List<String> fieldName = this.getFieldNameFromSubTree(optFuncExpr, subTree, assignOrUnnestIndex, varIndex, subTree.getRecordType(), optVarIndex, (ILogicalExpression)((Mutable)optFuncExpr.getFuncExpr().getArguments().get(optVarIndex)).getValue(), subTree.getMetaRecordType(), datasetMetaVar);
            IAType fieldType = (IAType)context.getOutputTypeEnvironment((ILogicalOperator)assignOp).getVarType(var);
            optFuncExpr.setFieldName(optVarIndex, fieldName);
            optFuncExpr.setFieldType(optVarIndex, fieldType);
            this.setTypeTag(context, subTree, optFuncExpr, optVarIndex);
            if (!subTree.hasDataSource()) continue;
            this.fillIndexExprs(datasetIndexes, fieldName, fieldType, optFuncExpr, optFuncExprIndex, optVarIndex, subTree, analysisCtx);
        }
    }

    private void matchVarsFromOptFuncExprToDataSourceScan(IOptimizableFuncExpr optFuncExpr, int optFuncExprIndex, List<Index> datasetIndexes, List<LogicalVariable> dsVarList, OptimizableOperatorSubTree subTree, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, boolean fromAdditionalDataSource) throws AlgebricksException {
        for (int varIndex = 0; varIndex < dsVarList.size(); ++varIndex) {
            IAType fieldType;
            List fieldName;
            int funcVarIndex;
            LogicalVariable var;
            block3: {
                List subTreePKs;
                block2: {
                    var = dsVarList.get(varIndex);
                    funcVarIndex = optFuncExpr.findLogicalVar(var);
                    if (funcVarIndex == -1) continue;
                    fieldName = null;
                    fieldType = null;
                    subTreePKs = null;
                    if (fromAdditionalDataSource) break block2;
                    subTreePKs = subTree.getDataset().getPrimaryKeys();
                    if (varIndex > subTreePKs.size() - 1) break block3;
                    fieldName = (List)subTreePKs.get(varIndex);
                    fieldType = (IAType)context.getOutputTypeEnvironment((ILogicalOperator)subTree.getDataSourceRef().getValue()).getVarType(var);
                    break block3;
                }
                for (int i = 0; i < subTree.getIxJoinOuterAdditionalDatasets().size(); ++i) {
                    if (subTree.getIxJoinOuterAdditionalDatasets().get(i) == null || !(subTreePKs = subTree.getIxJoinOuterAdditionalDatasets().get(i).getPrimaryKeys()).contains(var) || varIndex > subTreePKs.size() - 1) continue;
                    fieldName = (List)subTreePKs.get(varIndex);
                    fieldType = (IAType)context.getOutputTypeEnvironment((ILogicalOperator)subTree.getIxJoinOuterAdditionalDataSourceRefs().get(i).getValue()).getVarType(var);
                    break;
                }
            }
            optFuncExpr.setFieldName(funcVarIndex, fieldName);
            optFuncExpr.setOptimizableSubTree(funcVarIndex, subTree);
            optFuncExpr.setSourceVar(funcVarIndex, var);
            optFuncExpr.setLogicalExpr(funcVarIndex, (ILogicalExpression)new VariableReferenceExpression(var));
            this.setTypeTag(context, subTree, optFuncExpr, funcVarIndex);
            if (!subTree.hasDataSourceScan()) continue;
            this.fillIndexExprs(datasetIndexes, fieldName, fieldType, optFuncExpr, optFuncExprIndex, funcVarIndex, subTree, analysisCtx);
        }
    }

    private void setTypeTag(IOptimizationContext context, OptimizableOperatorSubTree subTree, IOptimizableFuncExpr optFuncExpr, int funcVarIndex) throws AlgebricksException {
        IAType type = (IAType)context.getOutputTypeEnvironment(subTree.getRoot()).getVarType(optFuncExpr.getLogicalVar(funcVarIndex));
        optFuncExpr.setFieldType(funcVarIndex, type);
    }

    protected List<String> getFieldNameFromSubTree(IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree subTree, int opIndex, int assignVarIndex, ARecordType recordType, int funcVarIndex, ILogicalExpression parentFuncExpr, ARecordType metaType, LogicalVariable metaVar) throws AlgebricksException {
        ILogicalExpression argExpr;
        int i;
        AbstractLogicalExpression expr = null;
        AbstractFunctionCallExpression childFuncExpr = null;
        AbstractLogicalOperator op = subTree.getAssignsAndUnnests().get(opIndex);
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator assignOp = (AssignOperator)op;
            expr = (AbstractLogicalExpression)((Mutable)assignOp.getExpressions().get(assignVarIndex)).getValue();
            if (expr.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                return Collections.emptyList();
            }
            childFuncExpr = (AbstractFunctionCallExpression)expr;
        } else {
            UnnestOperator unnestOp = (UnnestOperator)op;
            expr = (AbstractLogicalExpression)unnestOp.getExpressionRef().getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                return Collections.emptyList();
            }
            childFuncExpr = (AbstractFunctionCallExpression)expr;
            if (childFuncExpr.getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
                return Collections.emptyList();
            }
            expr = (AbstractLogicalExpression)((Mutable)childFuncExpr.getArguments().get(0)).getValue();
        }
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return Collections.emptyList();
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        boolean isByName = false;
        boolean isFieldAccess = false;
        String fieldName = null;
        ArrayList<String> nestedAccessFieldName = null;
        int fieldIndex = -1;
        if (funcIdent == BuiltinFunctions.FIELD_ACCESS_BY_NAME) {
            fieldName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)1);
            if (fieldName == null) {
                return Collections.emptyList();
            }
            isFieldAccess = true;
            isByName = true;
        } else if (funcIdent == BuiltinFunctions.FIELD_ACCESS_BY_INDEX) {
            Integer idx = ConstantExpressionUtil.getIntArgument((AbstractFunctionCallExpression)funcExpr, (int)1);
            if (idx == null) {
                return Collections.emptyList();
            }
            fieldIndex = idx;
            isFieldAccess = true;
        } else if (funcIdent == BuiltinFunctions.FIELD_ACCESS_NESTED) {
            ILogicalExpression nameArg = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
            if (nameArg.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                return Collections.emptyList();
            }
            ConstantExpression constExpr = (ConstantExpression)nameArg;
            AOrderedList orderedNestedFieldName = (AOrderedList)((AsterixConstantValue)constExpr.getValue()).getObject();
            nestedAccessFieldName = new ArrayList<String>();
            for (i = 0; i < orderedNestedFieldName.size(); ++i) {
                nestedAccessFieldName.add(((AString)orderedNestedFieldName.getItem(i)).getStringValue());
            }
            isFieldAccess = true;
            isByName = true;
        }
        if (isFieldAccess) {
            LogicalVariable sourceVar = ((VariableReferenceExpression)((Mutable)funcExpr.getArguments().get(0)).getValue()).getVariableReference();
            if (optFuncExpr != null) {
                optFuncExpr.setLogicalExpr(funcVarIndex, parentFuncExpr);
            }
            int[] assignAndExpressionIndexes = null;
            for (int i2 = opIndex + 1; i2 < subTree.getAssignsAndUnnests().size(); ++i2) {
                List varList;
                AbstractLogicalOperator subOp = subTree.getAssignsAndUnnests().get(i2);
                if (subOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                    varList = ((AssignOperator)subOp).getVariables();
                } else {
                    if (subOp.getOperatorTag() != LogicalOperatorTag.UNNEST) break;
                    varList = ((UnnestOperator)subOp).getVariables();
                }
                for (int varIndex = 0; varIndex < varList.size(); ++varIndex) {
                    int[] returnValues;
                    LogicalVariable var = (LogicalVariable)varList.get(varIndex);
                    ArrayList parentVars = new ArrayList();
                    expr.getUsedVariables(parentVars);
                    if (!parentVars.contains(var)) continue;
                    assignAndExpressionIndexes = returnValues = new int[]{i2, varIndex};
                }
            }
            if (assignAndExpressionIndexes != null && assignAndExpressionIndexes[0] > -1) {
                List<String> parentFieldNames = this.getFieldNameFromSubTree(optFuncExpr, subTree, (int)assignAndExpressionIndexes[0], (int)assignAndExpressionIndexes[1], recordType, funcVarIndex, parentFuncExpr, metaType, metaVar);
                if (parentFieldNames.isEmpty()) {
                    return Collections.emptyList();
                }
                if (!isByName) {
                    IAType subFieldType = sourceVar.equals((Object)metaVar) ? metaType.getSubFieldType(parentFieldNames) : recordType.getSubFieldType(parentFieldNames);
                    if ((subFieldType = TypeComputeUtils.getActualType((IAType)subFieldType)).getTypeTag() != ATypeTag.OBJECT) {
                        throw CompilationException.create((int)18, (Serializable[])new Serializable[]{subFieldType, ARecordType.class.getName()});
                    }
                    fieldName = ((ARecordType)subFieldType).getFieldNames()[fieldIndex];
                }
                if (optFuncExpr != null) {
                    optFuncExpr.setSourceVar(funcVarIndex, (LogicalVariable)((AssignOperator)op).getVariables().get(assignVarIndex));
                }
                if (nestedAccessFieldName != null) {
                    for (i = 0; i < nestedAccessFieldName.size(); ++i) {
                        parentFieldNames.add((String)nestedAccessFieldName.get(i));
                    }
                } else {
                    parentFieldNames.add(fieldName);
                }
                return parentFieldNames;
            }
            if (optFuncExpr != null) {
                optFuncExpr.setSourceVar(funcVarIndex, (LogicalVariable)((AssignOperator)op).getVariables().get(assignVarIndex));
            }
            if (isByName) {
                if (nestedAccessFieldName != null) {
                    return nestedAccessFieldName;
                }
                return new ArrayList<String>(Arrays.asList(fieldName));
            }
            return new ArrayList<String>(Arrays.asList(sourceVar.equals((Object)metaVar) ? metaType.getFieldNames()[fieldIndex] : recordType.getFieldNames()[fieldIndex]));
        }
        if (!this.funcIDSetThatRetainFieldName.contains((Object)funcIdent)) {
            return Collections.emptyList();
        }
        if (optFuncExpr != null && optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CHECK) {
            optFuncExpr.setPartialField(true);
        }
        if ((argExpr = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return Collections.emptyList();
        }
        LogicalVariable curVar = ((VariableReferenceExpression)argExpr).getVariableReference();
        for (int assignOrUnnestIndex = opIndex + 1; assignOrUnnestIndex < subTree.getAssignsAndUnnests().size(); ++assignOrUnnestIndex) {
            AbstractLogicalOperator curOp = subTree.getAssignsAndUnnests().get(assignOrUnnestIndex);
            if (curOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                AssignOperator assignOp = (AssignOperator)curOp;
                List varList = assignOp.getVariables();
                for (int varIndex = 0; varIndex < varList.size(); ++varIndex) {
                    LogicalVariable var = (LogicalVariable)varList.get(varIndex);
                    if (!var.equals((Object)curVar) || optFuncExpr == null) continue;
                    optFuncExpr.setSourceVar(funcVarIndex, var);
                    return this.getFieldNameFromSubTree(optFuncExpr, subTree, assignOrUnnestIndex, varIndex, recordType, funcVarIndex, (ILogicalExpression)childFuncExpr, metaType, metaVar);
                }
                continue;
            }
            UnnestOperator unnestOp = (UnnestOperator)curOp;
            LogicalVariable var = unnestOp.getVariable();
            if (!var.equals((Object)curVar)) continue;
            this.getFieldNameFromSubTree(optFuncExpr, subTree, assignOrUnnestIndex, 0, recordType, funcVarIndex, (ILogicalExpression)childFuncExpr, metaType, metaVar);
        }
        return Collections.emptyList();
    }

    protected void fillFieldNamesInTheSubTree(OptimizableOperatorSubTree subTree) throws AlgebricksException {
        LogicalVariable datasetMetaVar = null;
        if (subTree.getDataSourceType() != OptimizableOperatorSubTree.DataSourceType.COLLECTION_SCAN && subTree.getDataSourceType() != OptimizableOperatorSubTree.DataSourceType.INDEXONLY_PLAN_SECONDARY_INDEX_LOOKUP) {
            List<LogicalVariable> datasetVars = subTree.getDataSourceVariables();
            if (subTree.getDataset().hasMetaPart()) {
                datasetMetaVar = datasetVars.get(datasetVars.size() - 1);
            }
        }
        for (int assignOrUnnestIndex = 0; assignOrUnnestIndex < subTree.getAssignsAndUnnests().size(); ++assignOrUnnestIndex) {
            AbstractLogicalOperator op = subTree.getAssignsAndUnnests().get(assignOrUnnestIndex);
            if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                AssignOperator assignOp = (AssignOperator)op;
                List varList = assignOp.getVariables();
                for (int varIndex = 0; varIndex < varList.size(); ++varIndex) {
                    LogicalVariable var = (LogicalVariable)varList.get(varIndex);
                    List<String> fieldName = this.getFieldNameFromSubTree(null, subTree, assignOrUnnestIndex, varIndex, subTree.getRecordType(), -1, null, subTree.getMetaRecordType(), datasetMetaVar);
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    subTree.getVarsToFieldNameMap().put(var, fieldName);
                }
                continue;
            }
            if (op.getOperatorTag() == LogicalOperatorTag.UNNEST) {
                UnnestOperator unnestOp = (UnnestOperator)op;
                LogicalVariable var = unnestOp.getVariable();
                List<String> fieldName = null;
                if (subTree.getDataSourceType() == OptimizableOperatorSubTree.DataSourceType.COLLECTION_SCAN || (fieldName = this.getFieldNameFromSubTree(null, subTree, assignOrUnnestIndex, 0, subTree.getRecordType(), -1, null, subTree.getMetaRecordType(), datasetMetaVar)) == null || fieldName.isEmpty()) continue;
                subTree.getVarsToFieldNameMap().put(var, fieldName);
                continue;
            }
            LeftOuterUnnestMapOperator leftOuterUnnestMapOp = null;
            UnnestMapOperator unnestMapOp = null;
            List varList = null;
            if (op.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP) {
                unnestMapOp = (UnnestMapOperator)op;
                varList = unnestMapOp.getVariables();
            } else {
                if (op.getOperatorTag() != LogicalOperatorTag.LEFT_OUTER_UNNEST_MAP) continue;
                leftOuterUnnestMapOp = (LeftOuterUnnestMapOperator)op;
                varList = leftOuterUnnestMapOp.getVariables();
            }
            for (int varIndex = 0; varIndex < varList.size(); ++varIndex) {
                LogicalVariable var = (LogicalVariable)varList.get(varIndex);
                List<String> fieldName = this.getFieldNameFromSubTree(null, subTree, assignOrUnnestIndex, varIndex, subTree.getRecordType(), -1, null, subTree.getMetaRecordType(), datasetMetaVar);
                if (fieldName == null || fieldName.isEmpty()) continue;
                subTree.getVarsToFieldNameMap().put(var, fieldName);
            }
        }
        if (subTree.hasDataSourceScan()) {
            ArrayList<LogicalVariable> primaryKeyVarList = new ArrayList<LogicalVariable>();
            if (subTree.getDataset().getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                subTree.getPrimaryKeyVars(null, primaryKeyVarList);
                Index primaryIndex = this.getPrimaryIndexFromDataSourceScanOp((ILogicalOperator)subTree.getDataSourceRef().getValue());
                for (int i = 0; i < primaryKeyVarList.size(); ++i) {
                    subTree.getVarsToFieldNameMap().put((LogicalVariable)primaryKeyVarList.get(i), (List<String>)primaryIndex.getKeyFieldNames().get(i));
                }
            }
        }
    }

    protected Index getPrimaryIndexFromDataSourceScanOp(ILogicalOperator dataSourceScanOp) throws AlgebricksException {
        if (dataSourceScanOp.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
            return null;
        }
        Pair<String, String> datasetInfo = AnalysisUtil.getDatasetInfo((AbstractDataSourceOperator)((DataSourceScanOperator)dataSourceScanOp));
        String dataverseName = (String)datasetInfo.first;
        String datasetName = (String)datasetInfo.second;
        Index idxUsedInUnnestMap = this.metadataProvider.getIndex(dataverseName, datasetName, datasetName);
        return idxUsedInUnnestMap;
    }
}

