/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.List;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceUnnestForCollectionToSequenceRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        IAType innerExprType;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assign = (AssignOperator)op;
        List exprs = assign.getExpressions();
        if (exprs.size() != 1) {
            return false;
        }
        ILogicalExpression expr = (ILogicalExpression)((Mutable)exprs.get(0)).getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression func = (AbstractFunctionCallExpression)expr;
        if (func.getFunctionIdentifier() != BuiltinFunctions.COLLECTION_TO_SEQUENCE) {
            return false;
        }
        IVariableTypeEnvironment env = assign.computeInputTypeEnvironment((ITypingContext)context);
        ILogicalExpression argExpr = (ILogicalExpression)((Mutable)func.getArguments().get(0)).getValue();
        IAType outerExprType = (IAType)env.getType(expr);
        if (outerExprType.equals(innerExprType = (IAType)env.getType(argExpr))) {
            assign.getExpressions().set(0, new MutableObject((Object)argExpr));
            return true;
        }
        LogicalVariable var = (LogicalVariable)assign.getVariables().get(0);
        UnnestOperator unnest = new UnnestOperator(var, (Mutable)new MutableObject((Object)new UnnestingFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), new Mutable[]{new MutableObject((Object)argExpr)})));
        unnest.getInputs().addAll(assign.getInputs());
        opRef.setValue((Object)unnest);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unnest);
        return true;
    }
}

