/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceIndex;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceSecondaryIndexInsertDeleteRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        String datasetName;
        String dataverseName;
        DelegateOperator eOp;
        AbstractLogicalOperator op0 = (AbstractLogicalOperator)opRef.getValue();
        if (op0.getOperatorTag() != LogicalOperatorTag.DELEGATE_OPERATOR && op0.getOperatorTag() != LogicalOperatorTag.SINK) {
            return false;
        }
        if (op0.getOperatorTag() == LogicalOperatorTag.DELEGATE_OPERATOR && !((eOp = (DelegateOperator)op0).getDelegate() instanceof CommitOperator)) {
            return false;
        }
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)((Mutable)op0.getInputs().get(0)).getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.INSERT_DELETE_UPSERT) {
            return false;
        }
        InsertDeleteUpsertOperator primaryIndexModificationOp = (InsertDeleteUpsertOperator)((Mutable)op0.getInputs().get(0)).getValue();
        boolean isBulkload = primaryIndexModificationOp.isBulkload();
        ILogicalExpression newRecordExpr = (ILogicalExpression)primaryIndexModificationOp.getPayloadExpression().getValue();
        List newMetaExprs = primaryIndexModificationOp.getAdditionalNonFilteringExpressions();
        LogicalVariable newMetaVar = null;
        AbstractLogicalOperator inputOp = (AbstractLogicalOperator)((Mutable)primaryIndexModificationOp.getInputs().get(0)).getValue();
        LogicalVariable newRecordVar = this.getRecordVar(context, inputOp, newRecordExpr, 0);
        if (newMetaExprs != null && !newMetaExprs.isEmpty()) {
            if (newMetaExprs.size() > 1) {
                throw new AlgebricksException("Number of meta records can't be more than 1. Number of meta records found = " + newMetaExprs.size());
            }
            newMetaVar = this.getRecordVar(context, inputOp, (ILogicalExpression)((Mutable)newMetaExprs.get(0)).getValue(), 1);
        }
        DataSource datasetSource = (DataSource)primaryIndexModificationOp.getDataSource();
        MetadataProvider mp = (MetadataProvider)context.getMetadataProvider();
        Dataset dataset = mp.findDataset(dataverseName = datasetSource.getId().getDataverseName(), datasetName = datasetSource.getId().getDatasourceName());
        if (dataset == null) {
            throw new AlgebricksException("Unknown dataset " + datasetName + " in dataverse " + dataverseName);
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return false;
        }
        String itemTypeName = dataset.getItemTypeName();
        IAType itemType = mp.findType(dataset.getItemTypeDataverseName(), itemTypeName);
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new AlgebricksException("Only record types can be indexed.");
        }
        ARecordType recType = (ARecordType)itemType;
        ARecordType metaType = null;
        if (dataset.hasMetaPart()) {
            metaType = (ARecordType)mp.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
        }
        List indexes = mp.getDatasetIndexes(dataset.getDataverseName(), dataset.getDatasetName());
        InsertDeleteUpsertOperator currentTop = primaryIndexModificationOp;
        boolean hasSecondaryIndex = false;
        Collections.sort(indexes, (o1, o2) -> o1.getIndexType().ordinal() - o2.getIndexType().ordinal());
        int secondaryIndexTotalCnt = indexes.size() - 1;
        if (secondaryIndexTotalCnt <= 0) {
            return false;
        }
        op0.getInputs().clear();
        List filteringFields = ((InternalDatasetDetails)dataset.getDatasetDetails()).getFilterField();
        ArrayList<MutableObject> filteringExpressions = null;
        if (filteringFields != null) {
            ArrayList filteringVars = new ArrayList();
            filteringExpressions = new ArrayList<MutableObject>();
            for (Mutable filteringExpression : primaryIndexModificationOp.getAdditionalFilteringExpressions()) {
                ((ILogicalExpression)filteringExpression.getValue()).getUsedVariables(filteringVars);
                for (LogicalVariable var : filteringVars) {
                    filteringExpressions.add(new MutableObject((Object)new VariableReferenceExpression(var)));
                }
            }
        }
        ReplicateOperator replicateOp = null;
        if (secondaryIndexTotalCnt > 1 && primaryIndexModificationOp.isBulkload()) {
            replicateOp = new ReplicateOperator(secondaryIndexTotalCnt);
            replicateOp.getInputs().add(new MutableObject((Object)currentTop));
            replicateOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)replicateOp);
            currentTop = replicateOp;
        }
        HashMap<IndexFieldId, LogicalVariable> fieldVarsForBeforeOperation = new HashMap<IndexFieldId, LogicalVariable>();
        HashMap<IndexFieldId, LogicalVariable> fieldVarsForNewRecord = new HashMap<IndexFieldId, LogicalVariable>();
        if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.INSERT || primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT || primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.DELETE) {
            this.injectFieldAccessesForIndexes(context, dataset, indexes, fieldVarsForNewRecord, recType, metaType, newRecordVar, newMetaVar, (ILogicalOperator)primaryIndexModificationOp, false);
            if (replicateOp != null) {
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)replicateOp);
            }
        }
        if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            List beforeOpMetaVars = primaryIndexModificationOp.getBeforeOpAdditionalNonFilteringVars();
            LogicalVariable beforeOpMetaVar = beforeOpMetaVars == null ? null : (LogicalVariable)beforeOpMetaVars.get(0);
            currentTop = this.injectFieldAccessesForIndexes(context, dataset, indexes, fieldVarsForBeforeOperation, recType, metaType, primaryIndexModificationOp.getBeforeOpRecordVar(), beforeOpMetaVar, (ILogicalOperator)currentTop, true);
        }
        for (Index index : indexes) {
            IndexInsertDeleteUpsertOperator indexUpdate;
            IndexInsertDeleteUpsertOperator replicateOutput;
            if (!index.isSecondaryIndex()) continue;
            hasSecondaryIndex = true;
            List secondaryKeyFields = index.getKeyFieldNames();
            List secondaryKeyTypes = index.getKeyFieldTypes();
            ArrayList<LogicalVariable> secondaryKeyVars = new ArrayList<LogicalVariable>();
            ArrayList<MutableObject> secondaryExpressions = new ArrayList<MutableObject>();
            ArrayList<MutableObject> beforeOpSecondaryExpressions = new ArrayList<MutableObject>();
            for (int i = 0; i < secondaryKeyFields.size(); ++i) {
                IndexFieldId indexFieldId = new IndexFieldId((Integer)index.getKeyFieldSourceIndicators().get(i), (List)secondaryKeyFields.get(i), ((IAType)secondaryKeyTypes.get(i)).getTypeTag());
                LogicalVariable skVar = (LogicalVariable)fieldVarsForNewRecord.get(indexFieldId);
                secondaryKeyVars.add(skVar);
                secondaryExpressions.add(new MutableObject((Object)new VariableReferenceExpression(skVar)));
                if (primaryIndexModificationOp.getOperation() != InsertDeleteUpsertOperator.Kind.UPSERT) continue;
                beforeOpSecondaryExpressions.add(new MutableObject((Object)new VariableReferenceExpression((LogicalVariable)fieldVarsForBeforeOperation.get(indexFieldId))));
            }
            if (index.getIndexType() != DatasetConfig.IndexType.RTREE) {
                Mutable<ILogicalExpression> filterExpression = primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT ? null : this.createFilterExpression(secondaryKeyVars, context.getOutputTypeEnvironment((ILogicalOperator)currentTop), index.isOverridingKeyFieldTypes());
                DataSourceIndex dataSourceIndex = new DataSourceIndex(index, dataverseName, datasetName, mp);
                if (index.getIndexType() != DatasetConfig.IndexType.BTREE && primaryIndexModificationOp.isBulkload()) {
                    boolean isPartitioned = index.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || index.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
                    ArrayList<LogicalVariable> tokenizeKeyVars = new ArrayList<LogicalVariable>();
                    ArrayList<MutableObject> tokenizeKeyExprs = new ArrayList<MutableObject>();
                    LogicalVariable tokenVar = context.newVar();
                    tokenizeKeyVars.add(tokenVar);
                    tokenizeKeyExprs.add(new MutableObject((Object)new VariableReferenceExpression(tokenVar)));
                    Pair keyPairType = Index.getNonNullableOpenFieldType((IAType)((IAType)index.getKeyFieldTypes().get(0)), (List)((List)secondaryKeyFields.get(0)), (ARecordType)recType);
                    IAType secondaryKeyType = (IAType)keyPairType.first;
                    ArrayList<Object> varTypes = new ArrayList<Object>();
                    varTypes.add(NonTaggedFormatUtil.getTokenType((IAType)secondaryKeyType));
                    if (isPartitioned) {
                        LogicalVariable lengthVar = context.newVar();
                        tokenizeKeyVars.add(lengthVar);
                        tokenizeKeyExprs.add(new MutableObject((Object)new VariableReferenceExpression(lengthVar)));
                        varTypes.add(BuiltinType.SHORTWITHOUTTYPEINFO);
                    }
                    TokenizeOperator tokenUpdate = new TokenizeOperator((IDataSourceIndex)dataSourceIndex, primaryIndexModificationOp.getPrimaryKeyExpressions(), secondaryExpressions, tokenizeKeyVars, filterExpression, primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), isPartitioned, varTypes);
                    tokenUpdate.getInputs().add(new MutableObject((Object)currentTop));
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)tokenUpdate);
                    replicateOutput = tokenUpdate;
                    indexUpdate = new IndexInsertDeleteUpsertOperator((IDataSourceIndex)dataSourceIndex, primaryIndexModificationOp.getPrimaryKeyExpressions(), tokenizeKeyExprs, filterExpression, primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), primaryIndexModificationOp.getAdditionalNonFilteringExpressions() == null ? 0 : primaryIndexModificationOp.getAdditionalNonFilteringExpressions().size());
                    indexUpdate.setAdditionalFilteringExpressions(filteringExpressions);
                    indexUpdate.getInputs().add(new MutableObject((Object)tokenUpdate));
                } else {
                    indexUpdate = new IndexInsertDeleteUpsertOperator((IDataSourceIndex)dataSourceIndex, primaryIndexModificationOp.getPrimaryKeyExpressions(), secondaryExpressions, filterExpression, primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), primaryIndexModificationOp.getAdditionalNonFilteringExpressions() == null ? 0 : primaryIndexModificationOp.getAdditionalNonFilteringExpressions().size());
                    indexUpdate.setAdditionalFilteringExpressions(filteringExpressions);
                    replicateOutput = indexUpdate;
                    if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                        indexUpdate.setBeforeOpSecondaryKeyExprs(beforeOpSecondaryExpressions);
                        if (filteringFields != null) {
                            indexUpdate.setBeforeOpAdditionalFilteringExpression((Mutable)new MutableObject((Object)new VariableReferenceExpression(primaryIndexModificationOp.getBeforeOpFilterVar())));
                        }
                    }
                    indexUpdate.getInputs().add(new MutableObject((Object)currentTop));
                }
            } else {
                Pair keyPairType = Index.getNonNullableOpenFieldType((IAType)((IAType)index.getKeyFieldTypes().get(0)), (List)((List)secondaryKeyFields.get(0)), (ARecordType)recType);
                IAType spatialType = (IAType)keyPairType.first;
                boolean isPointMBR = spatialType.getTypeTag() == ATypeTag.POINT || spatialType.getTypeTag() == ATypeTag.POINT3D;
                int dimension = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
                int numKeys = isPointMBR && isBulkload ? dimension : dimension * 2;
                ArrayList<LogicalVariable> keyVarList = new ArrayList<LogicalVariable>();
                ArrayList<MutableObject> keyExprList = new ArrayList<MutableObject>();
                for (int i = 0; i < numKeys; ++i) {
                    LogicalVariable keyVar = context.newVar();
                    keyVarList.add(keyVar);
                    ScalarFunctionCallExpression createMBR = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_MBR));
                    createMBR.getArguments().add(new MutableObject((Object)new VariableReferenceExpression((LogicalVariable)secondaryKeyVars.get(0))));
                    createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(dimension)))));
                    createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(i)))));
                    keyExprList.add(new MutableObject((Object)createMBR));
                }
                secondaryExpressions.clear();
                for (LogicalVariable secondaryKeyVar : keyVarList) {
                    secondaryExpressions.add(new MutableObject((Object)new VariableReferenceExpression(secondaryKeyVar)));
                }
                if (isPointMBR && isBulkload) {
                    for (LogicalVariable secondaryKeyVar : keyVarList) {
                        secondaryExpressions.add(new MutableObject((Object)new VariableReferenceExpression(secondaryKeyVar)));
                    }
                }
                AssignOperator assignCoordinates = new AssignOperator(keyVarList, keyExprList);
                assignCoordinates.getInputs().add(new MutableObject((Object)currentTop));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignCoordinates);
                replicateOutput = assignCoordinates;
                Mutable<ILogicalExpression> filterExpression = null;
                AssignOperator originalAssignCoordinates = null;
                if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                    ArrayList<LogicalVariable> originalKeyVarList = new ArrayList<LogicalVariable>();
                    ArrayList<MutableObject> originalKeyExprList = new ArrayList<MutableObject>();
                    for (int i = 0; i < numKeys; ++i) {
                        LogicalVariable keyVar = context.newVar();
                        originalKeyVarList.add(keyVar);
                        ScalarFunctionCallExpression createMBR = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_MBR));
                        createMBR.getArguments().add(beforeOpSecondaryExpressions.get(0));
                        createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(dimension)))));
                        createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(i)))));
                        originalKeyExprList.add(new MutableObject((Object)createMBR));
                    }
                    beforeOpSecondaryExpressions.clear();
                    for (LogicalVariable secondaryKeyVar : originalKeyVarList) {
                        beforeOpSecondaryExpressions.add(new MutableObject((Object)new VariableReferenceExpression(secondaryKeyVar)));
                    }
                    originalAssignCoordinates = new AssignOperator(originalKeyVarList, originalKeyExprList);
                    originalAssignCoordinates.getInputs().add(new MutableObject((Object)assignCoordinates));
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)originalAssignCoordinates);
                } else {
                    boolean forceFilter = (Boolean)keyPairType.second;
                    filterExpression = this.createFilterExpression(keyVarList, context.getOutputTypeEnvironment((ILogicalOperator)assignCoordinates), forceFilter);
                }
                DataSourceIndex dataSourceIndex = new DataSourceIndex(index, dataverseName, datasetName, mp);
                indexUpdate = new IndexInsertDeleteUpsertOperator((IDataSourceIndex)dataSourceIndex, primaryIndexModificationOp.getPrimaryKeyExpressions(), secondaryExpressions, filterExpression, primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), primaryIndexModificationOp.getAdditionalNonFilteringExpressions() == null ? 0 : primaryIndexModificationOp.getAdditionalNonFilteringExpressions().size());
                indexUpdate.setAdditionalFilteringExpressions(filteringExpressions);
                if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                    if (filteringFields != null) {
                        indexUpdate.setBeforeOpAdditionalFilteringExpression((Mutable)new MutableObject((Object)new VariableReferenceExpression(primaryIndexModificationOp.getBeforeOpFilterVar())));
                    }
                    indexUpdate.setBeforeOpSecondaryKeyExprs(beforeOpSecondaryExpressions);
                    indexUpdate.getInputs().add(new MutableObject((Object)originalAssignCoordinates));
                } else {
                    indexUpdate.getInputs().add(new MutableObject((Object)assignCoordinates));
                }
            }
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)indexUpdate);
            if (!primaryIndexModificationOp.isBulkload() || secondaryIndexTotalCnt == 1) {
                currentTop = indexUpdate;
            } else {
                replicateOp.getOutputs().add(new MutableObject((Object)replicateOutput));
                if (index.getKeyFieldNames().isEmpty() && index.getIndexType() == DatasetConfig.IndexType.BTREE) {
                    int positionOfSecondaryPrimaryIndex = replicateOp.getOutputs().size() - 1;
                    replicateOp.getOutputMaterializationFlags()[positionOfSecondaryPrimaryIndex] = true;
                }
            }
            if (!primaryIndexModificationOp.isBulkload()) continue;
            op0.getInputs().add(new MutableObject((Object)indexUpdate));
        }
        if (!hasSecondaryIndex) {
            return false;
        }
        if (!primaryIndexModificationOp.isBulkload()) {
            op0.getInputs().clear();
            op0.getInputs().add(new MutableObject((Object)currentTop));
        }
        return true;
    }

    private LogicalVariable getRecordVar(IOptimizationContext context, AbstractLogicalOperator inputOp, ILogicalExpression recordExpr, int expectedRecordIndex) throws AlgebricksException {
        if (this.exprIsRecord(context.getOutputTypeEnvironment((ILogicalOperator)inputOp), recordExpr)) {
            return ((VariableReferenceExpression)recordExpr).getVariableReference();
        }
        FunctionIdentifier fid = null;
        AbstractLogicalOperator currentInputOp = inputOp;
        while (fid != BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR) {
            AssignOperator assignOp;
            ILogicalExpression assignExpr;
            if (currentInputOp.getInputs().isEmpty()) {
                return null;
            }
            if ((currentInputOp = (AbstractLogicalOperator)((Mutable)currentInputOp.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.ASSIGN || (assignExpr = (ILogicalExpression)((Mutable)(assignOp = (AssignOperator)currentInputOp).getExpressions().get(expectedRecordIndex)).getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            ScalarFunctionCallExpression funcExpr = (ScalarFunctionCallExpression)((Mutable)assignOp.getExpressions().get(expectedRecordIndex)).getValue();
            fid = funcExpr.getFunctionIdentifier();
        }
        return (LogicalVariable)((AssignOperator)currentInputOp).getVariables().get(0);
    }

    private boolean exprIsRecord(IVariableTypeEnvironment typeEnvironment, ILogicalExpression recordExpr) throws AlgebricksException {
        if (recordExpr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            IAType type = (IAType)typeEnvironment.getType(recordExpr);
            return type != null && type.getTypeTag() == ATypeTag.OBJECT;
        }
        return false;
    }

    private ILogicalOperator injectFieldAccessesForIndexes(IOptimizationContext context, Dataset dataset, List<Index> indexes, Map<IndexFieldId, LogicalVariable> fieldAccessVars, ARecordType recType, ARecordType metaType, LogicalVariable recordVar, LogicalVariable metaVar, ILogicalOperator currentTop, boolean afterOp) throws AlgebricksException {
        ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> exprs = new ArrayList<MutableObject>();
        for (Index index : indexes) {
            if (index.isPrimaryIndex()) continue;
            List skTypes = index.getKeyFieldTypes();
            List skNames = index.getKeyFieldNames();
            List indicators = index.getKeyFieldSourceIndicators();
            for (int i = 0; i < index.getKeyFieldNames().size(); ++i) {
                AbstractFunctionCallExpression theFieldAccessFunc;
                ARecordType sourceType;
                IndexFieldId indexFieldId = new IndexFieldId((Integer)indicators.get(i), (List)skNames.get(i), ((IAType)skTypes.get(i)).getTypeTag());
                if (fieldAccessVars.containsKey(indexFieldId)) continue;
                ARecordType aRecordType = dataset.hasMetaPart() ? ((Integer)indicators.get(i) == 0 ? recType : metaType) : (sourceType = recType);
                LogicalVariable sourceVar = dataset.hasMetaPart() ? ((Integer)indicators.get(i) == 0 ? recordVar : metaVar) : recordVar;
                LogicalVariable fieldVar = context.newVar();
                MutableObject varRef = new MutableObject((Object)new VariableReferenceExpression(sourceVar));
                IAType fieldType = sourceType.getSubFieldType(indexFieldId.fieldName);
                if (fieldType == null) {
                    context.addNotToBeInlinedVar(fieldVar);
                    AbstractFunctionCallExpression fieldAccessFunc = IntroduceSecondaryIndexInsertDeleteRule.getOpenOrNestedFieldAccessFunction((Mutable<ILogicalExpression>)varRef, indexFieldId.fieldName);
                    theFieldAccessFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)(index.isEnforced() ? BuiltinFunctions.CAST_TYPE : BuiltinFunctions.CAST_TYPE_LAX)));
                    theFieldAccessFunc.getArguments().add(new MutableObject((Object)fieldAccessFunc));
                    TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)theFieldAccessFunc, (IAType)((IAType)skTypes.get(i)), (IAType)BuiltinType.ANY);
                } else {
                    int pos = indexFieldId.fieldName.size() > 1 ? -1 : sourceType.getFieldIndex((String)indexFieldId.fieldName.get(0));
                    theFieldAccessFunc = pos == -1 ? IntroduceSecondaryIndexInsertDeleteRule.getOpenOrNestedFieldAccessFunction((Mutable<ILogicalExpression>)varRef, indexFieldId.fieldName) : IntroduceSecondaryIndexInsertDeleteRule.getClosedFieldAccessFunction((Mutable<ILogicalExpression>)varRef, pos);
                }
                vars.add(fieldVar);
                exprs.add(new MutableObject((Object)theFieldAccessFunc));
                fieldAccessVars.put(indexFieldId, fieldVar);
            }
        }
        AssignOperator castedFieldAssignOperator = new AssignOperator(vars, exprs);
        return IntroduceSecondaryIndexInsertDeleteRule.introduceNewOp(context, currentTop, (ILogicalOperator)castedFieldAssignOperator, afterOp);
    }

    private static ILogicalOperator introduceNewOp(IOptimizationContext context, ILogicalOperator currentTopOp, ILogicalOperator newOp, boolean afterOp) throws AlgebricksException {
        if (afterOp) {
            newOp.getInputs().add(new MutableObject((Object)currentTopOp));
            context.computeAndSetTypeEnvironmentForOperator(newOp);
            return newOp;
        }
        newOp.getInputs().addAll(currentTopOp.getInputs());
        currentTopOp.getInputs().clear();
        currentTopOp.getInputs().add(new MutableObject((Object)newOp));
        context.computeAndSetTypeEnvironmentForOperator(newOp);
        context.computeAndSetTypeEnvironmentForOperator(currentTopOp);
        return currentTopOp;
    }

    private static AbstractFunctionCallExpression getClosedFieldAccessFunction(Mutable<ILogicalExpression> varRef, int position) {
        MutableObject indexRef = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(position))));
        return new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{varRef, indexRef});
    }

    private static AbstractFunctionCallExpression getOpenOrNestedFieldAccessFunction(Mutable<ILogicalExpression> varRef, List<String> fields) {
        ScalarFunctionCallExpression func;
        if (fields.size() > 1) {
            AOrderedList fieldList = IntroduceSecondaryIndexInsertDeleteRule.stringListToAOrderedList(fields);
            Mutable<ILogicalExpression> fieldRef = IntroduceSecondaryIndexInsertDeleteRule.constantToMutableLogicalExpression((IAObject)fieldList);
            func = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_NESTED), new Mutable[]{varRef, fieldRef});
        } else {
            AString fieldList = new AString(fields.get(0));
            Mutable<ILogicalExpression> fieldRef = IntroduceSecondaryIndexInsertDeleteRule.constantToMutableLogicalExpression((IAObject)fieldList);
            func = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_NAME), new Mutable[]{varRef, fieldRef});
        }
        return func;
    }

    private static AOrderedList stringListToAOrderedList(List<String> fields) {
        AOrderedList fieldList = new AOrderedList(new AOrderedListType((IAType)BuiltinType.ASTRING, null));
        for (int i = 0; i < fields.size(); ++i) {
            fieldList.add((IAObject)new AString(fields.get(i)));
        }
        return fieldList;
    }

    private static Mutable<ILogicalExpression> constantToMutableLogicalExpression(IAObject constantObject) {
        return new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(constantObject)));
    }

    private Mutable<ILogicalExpression> createFilterExpression(List<LogicalVariable> secondaryKeyVars, IVariableTypeEnvironment typeEnv, boolean forceFilter) throws AlgebricksException {
        ArrayList<MutableObject> filterExpressions = new ArrayList<MutableObject>();
        for (LogicalVariable secondaryKeyVar : secondaryKeyVars) {
            IAType secondaryKeyType = (IAType)typeEnv.getVarType(secondaryKeyVar);
            if (!NonTaggedFormatUtil.isOptional((IAType)secondaryKeyType) && !forceFilter) continue;
            ScalarFunctionCallExpression isUnknownFuncExpr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.IS_UNKNOWN), new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(secondaryKeyVar))});
            ScalarFunctionCallExpression notFuncExpr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), new Mutable[]{new MutableObject((Object)isUnknownFuncExpr)});
            filterExpressions.add(new MutableObject((Object)notFuncExpr));
        }
        if (filterExpressions.isEmpty()) {
            return null;
        }
        Object filterExpression = filterExpressions.size() > 1 ? new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), filterExpressions)) : (Mutable)filterExpressions.get(0);
        return filterExpression;
    }

    private final class IndexFieldId {
        private final int indicator;
        private final List<String> fieldName;
        private final ATypeTag fieldType;

        private IndexFieldId(int indicator, List<String> fieldName, ATypeTag fieldType) {
            this.indicator = indicator;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        public int hashCode() {
            int result = this.indicator;
            result = 31 * result + this.fieldName.hashCode();
            result = 31 * result + this.fieldType.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexFieldId that = (IndexFieldId)o;
            if (this.indicator != that.indicator) {
                return false;
            }
            if (!this.fieldName.equals(that.fieldName)) {
                return false;
            }
            return this.fieldType == that.fieldType;
        }
    }
}

