/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceAutogenerateIDRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable inputRecord;
        AbstractLogicalOperator currentOp = (AbstractLogicalOperator)opRef.getValue();
        if (currentOp.getOperatorTag() == LogicalOperatorTag.DELEGATE_OPERATOR) {
            DelegateOperator dOp = (DelegateOperator)currentOp;
            if (!(dOp.getDelegate() instanceof CommitOperator)) {
                return false;
            }
            if (!((CommitOperator)dOp.getDelegate()).isSink()) {
                return false;
            }
        } else if (currentOp.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT && currentOp.getOperatorTag() != LogicalOperatorTag.SINK) {
            return false;
        }
        ArrayDeque<AbstractLogicalOperator> opStack = new ArrayDeque<AbstractLogicalOperator>();
        opStack.push(currentOp);
        while (currentOp.getInputs().size() == 1 && (currentOp = (AbstractLogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.INSERT_DELETE_UPSERT) {
            opStack.push(currentOp);
        }
        if (currentOp.getOperatorTag() != LogicalOperatorTag.INSERT_DELETE_UPSERT) {
            return false;
        }
        InsertDeleteUpsertOperator insertOp = (InsertDeleteUpsertOperator)currentOp;
        if (insertOp.getOperation() != InsertDeleteUpsertOperator.Kind.INSERT && insertOp.getOperation() != InsertDeleteUpsertOperator.Kind.UPSERT) {
            return false;
        }
        DatasetDataSource dds = (DatasetDataSource)insertOp.getDataSource();
        boolean autogenerated = ((InternalDatasetDetails)dds.getDataset().getDatasetDetails()).isAutogenerated();
        if (!autogenerated) {
            return false;
        }
        if (((DataSource)insertOp.getDataSource()).getDatasourceType() != 0) {
            return false;
        }
        AbstractLogicalOperator parentOp = (AbstractLogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        if (parentOp.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assignOp = (AssignOperator)parentOp;
        AbstractLogicalOperator grandparentOp = (AbstractLogicalOperator)((Mutable)parentOp.getInputs().get(0)).getValue();
        if (grandparentOp.getOperatorTag() == LogicalOperatorTag.PROJECT) {
            ProjectOperator projectOp = (ProjectOperator)grandparentOp;
            inputRecord = (LogicalVariable)projectOp.getVariables().get(0);
        } else if (grandparentOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            DataSourceScanOperator dssOp = (DataSourceScanOperator)grandparentOp;
            inputRecord = (LogicalVariable)dssOp.getVariables().get(0);
        } else {
            return false;
        }
        List pkFieldName = (List)((InternalDatasetDetails)dds.getDataset().getDatasetDetails()).getPrimaryKey().get(0);
        VariableReferenceExpression rec0 = new VariableReferenceExpression(inputRecord);
        AbstractFunctionCallExpression rec1 = this.createPrimaryKeyRecordExpression(pkFieldName);
        AbstractFunctionCallExpression mergedRec = this.createRecordMergeFunction((ILogicalExpression)rec0, (ILogicalExpression)rec1);
        ILogicalExpression nonNullMergedRec = this.createNotNullFunction((ILogicalExpression)mergedRec);
        LogicalVariable v = context.newVar();
        AssignOperator newAssign = new AssignOperator(v, (Mutable)new MutableObject((Object)nonNullMergedRec));
        newAssign.getInputs().add(new MutableObject((Object)grandparentOp));
        assignOp.getInputs().set(0, new MutableObject((Object)newAssign));
        VariableUtilities.substituteVariables((ILogicalOperator)assignOp, (LogicalVariable)inputRecord, (LogicalVariable)v, (ITypingContext)context);
        VariableUtilities.substituteVariables((ILogicalOperator)insertOp, (LogicalVariable)inputRecord, (LogicalVariable)v, (ITypingContext)context);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newAssign);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)insertOp);
        for (AbstractLogicalOperator op : opStack) {
            VariableUtilities.substituteVariables((ILogicalOperator)op, (LogicalVariable)inputRecord, (LogicalVariable)v, (ITypingContext)context);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        }
        return true;
    }

    private ILogicalExpression createNotNullFunction(ILogicalExpression mergedRec) {
        ArrayList<MutableObject> args = new ArrayList<MutableObject>();
        args.add(new MutableObject((Object)mergedRec));
        ScalarFunctionCallExpression notNullFn = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CHECK_UNKNOWN), args);
        return notNullFn;
    }

    private AbstractFunctionCallExpression createPrimaryKeyRecordExpression(List<String> pkFieldName) {
        ScalarFunctionCallExpression uuidFn = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_UUID));
        ArrayList<MutableObject> openRecordConsArgs = new ArrayList<MutableObject>();
        MutableObject pkFieldNameExpression = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(pkFieldName.get(pkFieldName.size() - 1)))));
        openRecordConsArgs.add(pkFieldNameExpression);
        MutableObject pkFieldValueExpression = new MutableObject((Object)uuidFn);
        openRecordConsArgs.add(pkFieldValueExpression);
        ScalarFunctionCallExpression openRecFn = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR), openRecordConsArgs);
        for (int i = pkFieldName.size() - 2; i > -1; --i) {
            AString fieldName = new AString(pkFieldName.get(i));
            openRecordConsArgs = new ArrayList();
            openRecordConsArgs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)fieldName))));
            openRecordConsArgs.add(new MutableObject((Object)openRecFn));
            openRecFn = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR), openRecordConsArgs);
        }
        return openRecFn;
    }

    private AbstractFunctionCallExpression createRecordMergeFunction(ILogicalExpression rec0, ILogicalExpression rec1) {
        ArrayList<MutableObject> recordMergeFnArgs = new ArrayList<MutableObject>();
        recordMergeFnArgs.add(new MutableObject((Object)rec0));
        recordMergeFnArgs.add(new MutableObject((Object)rec1));
        ScalarFunctionCallExpression recordMergeFn = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.RECORD_MERGE), recordMergeFnArgs);
        return recordMergeFn;
    }
}

