/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ByNameToByHandleFieldAccessRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assign = (AssignOperator)op;
        if (assign.getAnnotations().get("PUSHED_FIELD_ACCESS") == null) {
            return false;
        }
        ByNameToByHandleFieldAccessRule.byNameToByHandle(assign, context);
        return true;
    }

    private static void byNameToByHandle(AssignOperator fieldAccessOp, IOptimizationContext context) {
        VariableReferenceExpression x;
        Mutable opUnder = (Mutable)fieldAccessOp.getInputs().get(0);
        AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)((Mutable)fieldAccessOp.getExpressions().get(0)).getValue();
        ILogicalExpression a1 = (ILogicalExpression)((Mutable)fce.getArguments().get(0)).getValue();
        if (a1.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            x = (VariableReferenceExpression)a1;
        } else {
            LogicalVariable var1 = context.newVar();
            ArrayList<LogicalVariable> varArray = new ArrayList<LogicalVariable>(1);
            varArray.add(var1);
            ArrayList<MutableObject> exprArray = new ArrayList<MutableObject>(1);
            exprArray.add(new MutableObject((Object)a1));
            AssignOperator assignVar = new AssignOperator(varArray, exprArray);
            x = new VariableReferenceExpression(var1);
            assignVar.getInputs().add(opUnder);
            opUnder = new MutableObject((Object)assignVar);
        }
        LogicalVariable t = context.newVar();
        ScalarFunctionCallExpression typeOf = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.TYPE_OF));
        typeOf.getArguments().add(new MutableObject((Object)x));
        AssignOperator typAssign = new AssignOperator(t, (Mutable)new MutableObject((Object)typeOf));
        typAssign.getInputs().add(opUnder);
        LogicalVariable w = context.newVar();
        ScalarFunctionCallExpression getHandle = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.GET_HANDLE));
        getHandle.getArguments().add(new MutableObject((Object)new VariableReferenceExpression(t)));
        getHandle.getArguments().add(new MutableObject(((Mutable)fce.getArguments().get(1)).getValue()));
        AssignOperator handleAssign = new AssignOperator(w, (Mutable)new MutableObject((Object)getHandle));
        handleAssign.getInputs().add(new MutableObject((Object)typAssign));
        ScalarFunctionCallExpression getData = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.GET_DATA));
        VariableReferenceExpression ref2 = new VariableReferenceExpression(x.getVariableReference());
        getData.getArguments().add(new MutableObject((Object)ref2));
        getData.getArguments().add(new MutableObject((Object)new VariableReferenceExpression(w)));
        ((Mutable)fieldAccessOp.getExpressions().get(0)).setValue((Object)getData);
        List faInputs = fieldAccessOp.getInputs();
        faInputs.clear();
        faInputs.add(new MutableObject((Object)handleAssign));
        fieldAccessOp.removeAnnotation("PUSHED_FIELD_ACCESS");
    }
}

