/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.event.CouchbaseEvent;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;

public class Events {
    private static final ObjectMapper JACKSON = new ObjectMapper();

    public static Map<String, Object> identityMap(CouchbaseEvent source) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, String> event = new HashMap<String, String>();
        event.put("name", source.getClass().getSimpleName().replaceAll("Event$", ""));
        event.put("type", source.type().toString());
        root.put("event", event);
        return root;
    }

    public static String toJson(CouchbaseEvent source, boolean pretty) {
        try {
            if (pretty) {
                return JACKSON.writerWithDefaultPrettyPrinter().writeValueAsString(source.toMap());
            }
            return JACKSON.writeValueAsString(source.toMap());
        }
        catch (JsonProcessingException e) {
            throw new CouchbaseException("Could not convert CouchbaseEvent " + source.toString() + " to JSON: ", e);
        }
    }
}

