/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.HashMap;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.controllers.NodeParameters;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.ipc.NodeControllerRemoteProxy;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegisterNodeWork
extends SynchronizableWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final NodeRegistration reg;
    private final int registrationId;

    public RegisterNodeWork(ClusterControllerService ccs, NodeRegistration reg, int registrationId) {
        this.ccs = ccs;
        this.reg = reg;
        this.registrationId = registrationId;
    }

    protected void doRun() throws Exception {
        CCNCFunctions.NodeRegistrationResult result;
        String id = this.reg.getNodeId();
        IIPCHandle ncIPCHandle = this.ccs.getClusterIPC().getHandle(this.reg.getNodeControllerAddress());
        HashMap<IOption, Object> ncConfiguration = new HashMap<IOption, Object>();
        try {
            LOGGER.log(Level.WARN, "Registering INodeController: id = " + id);
            NodeControllerRemoteProxy nc = new NodeControllerRemoteProxy(this.ccs.getCcId(), this.ccs.getClusterIPC().getReconnectingHandle(this.reg.getNodeControllerAddress()));
            NodeControllerState state = new NodeControllerState(nc, this.reg);
            INodeManager nodeManager = this.ccs.getNodeManager();
            nodeManager.addNode(id, state);
            IApplicationConfig cfg = state.getNCConfig().getConfigManager().getNodeEffectiveConfig(id);
            for (IOption option : cfg.getOptions()) {
                ncConfiguration.put(option, cfg.get(option));
            }
            LOGGER.log(Level.INFO, "Registered INodeController: id = " + id);
            NodeParameters params = new NodeParameters();
            params.setClusterControllerInfo(this.ccs.getClusterControllerInfo());
            params.setDistributedState(this.ccs.getContext().getDistributedState());
            params.setHeartbeatPeriod(this.ccs.getCCConfig().getHeartbeatPeriodMillis());
            params.setProfileDumpPeriod(this.ccs.getCCConfig().getProfileDumpPeriod());
            params.setRegistrationId(this.registrationId);
            result = new CCNCFunctions.NodeRegistrationResult(params, null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Node registration failed", (Throwable)e);
            result = new CCNCFunctions.NodeRegistrationResult(null, e);
        }
        LOGGER.warn("sending registration response to node");
        ncIPCHandle.send(-1L, (Object)result, null);
        LOGGER.warn("notifying node join");
        this.ccs.getContext().notifyNodeJoin(id, ncConfiguration);
    }
}

