/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.config.ConfigUtils;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.utils.ConfigurationUtil;
import org.apache.hyracks.control.common.work.IPCResponder;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.util.MXHelper;
import org.apache.hyracks.util.PidHelper;

public class GetNodeDetailsJSONWork
extends SynchronizableWork {
    private static final Section[] CC_SECTIONS = new Section[]{Section.CC, Section.COMMON};
    private static final Section[] NC_SECTIONS = new Section[]{Section.NC, Section.COMMON};
    private final INodeManager nodeManager;
    private final CCConfig ccConfig;
    private final String nodeId;
    private final boolean includeStats;
    private final boolean includeConfig;
    private final IPCResponder<String> callback;
    private ObjectNode detail;
    private ObjectMapper om = new ObjectMapper();

    public GetNodeDetailsJSONWork(INodeManager nodeManager, CCConfig ccConfig, String nodeId, boolean includeStats, boolean includeConfig, IPCResponder<String> callback) {
        this.nodeManager = nodeManager;
        this.ccConfig = ccConfig;
        this.nodeId = nodeId;
        this.includeStats = includeStats;
        this.includeConfig = includeConfig;
        this.callback = callback;
    }

    public GetNodeDetailsJSONWork(INodeManager nodeManager, CCConfig ccConfig, String nodeId, boolean includeStats, boolean includeConfig) {
        this(nodeManager, ccConfig, nodeId, includeStats, includeConfig, null);
    }

    protected void doRun() throws Exception {
        if (this.nodeId == null) {
            this.detail = this.getCCDetails();
            if (this.includeConfig) {
                ConfigUtils.addConfigToJSON((ObjectNode)this.detail, (IApplicationConfig)this.ccConfig.getAppConfig(), (Section[])CC_SECTIONS);
                this.detail.putPOJO("app.args", (Object)this.ccConfig.getAppArgs());
            }
        } else {
            NodeControllerState ncs = this.nodeManager.getNodeControllerState(this.nodeId);
            if (ncs != null) {
                this.detail = ncs.toDetailedJSON(this.includeStats, this.includeConfig);
                if (this.includeConfig) {
                    NCConfig ncConfig = ncs.getNCConfig();
                    ConfigUtils.addConfigToJSON((ObjectNode)this.detail, (IApplicationConfig)ncConfig.getConfigManager().getNodeEffectiveConfig(this.nodeId), (Section[])NC_SECTIONS);
                    this.detail.putPOJO("app.args", (Object)ncConfig.getAppArgs());
                }
            }
        }
        if (this.callback != null) {
            this.callback.setValue(this.detail == null ? null : this.om.writeValueAsString((Object)this.detail));
        }
    }

    private ObjectNode getCCDetails() {
        ObjectNode o = this.om.createObjectNode();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        List<GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        if (this.includeConfig) {
            o.put("os_name", osMXBean.getName());
            o.put("arch", osMXBean.getArch());
            o.put("os_version", osMXBean.getVersion());
            o.put("num_processors", osMXBean.getAvailableProcessors());
            o.put("vm_name", runtimeMXBean.getVmName());
            o.put("vm_version", runtimeMXBean.getVmVersion());
            o.put("vm_vendor", runtimeMXBean.getVmVendor());
            o.putPOJO("classpath", (Object)ConfigurationUtil.toPathElements((String)runtimeMXBean.getClassPath()));
            o.putPOJO("library_path", (Object)ConfigurationUtil.toPathElements((String)runtimeMXBean.getLibraryPath()));
            o.putPOJO("boot_classpath", (Object)ConfigurationUtil.toPathElements((String)MXHelper.getBootClassPath()));
            o.putPOJO("input_arguments", runtimeMXBean.getInputArguments());
            o.putPOJO("system_properties", runtimeMXBean.getSystemProperties());
            o.put("pid", PidHelper.getPid());
        }
        if (this.includeStats) {
            MemoryUsage heapUsage = memoryMXBean.getHeapMemoryUsage();
            MemoryUsage nonheapUsage = memoryMXBean.getNonHeapMemoryUsage();
            ArrayList<ObjectNode> gcs = new ArrayList<ObjectNode>();
            for (GarbageCollectorMXBean gcMXBean : gcMXBeans) {
                ObjectNode gc = this.om.createObjectNode();
                gc.put("name", gcMXBean.getName());
                gc.put("collection-time", gcMXBean.getCollectionTime());
                gc.put("collection-count", gcMXBean.getCollectionCount());
                gcs.add(gc);
            }
            o.putPOJO("gcs", gcs);
            o.put("date", new Date().toString());
            o.put("heap_init_size", heapUsage.getInit());
            o.put("heap_used_size", heapUsage.getUsed());
            o.put("heap_committed_size", heapUsage.getCommitted());
            o.put("heap_max_size", heapUsage.getMax());
            o.put("nonheap_init_size", nonheapUsage.getInit());
            o.put("nonheap_used_size", nonheapUsage.getUsed());
            o.put("nonheap_committed_size", nonheapUsage.getCommitted());
            o.put("nonheap_max_size", nonheapUsage.getMax());
            o.put("thread_count", threadMXBean.getThreadCount());
            o.put("peak_thread_count", threadMXBean.getPeakThreadCount());
            o.put("started_thread_count", threadMXBean.getTotalStartedThreadCount());
            o.put("system_load_average", osMXBean.getSystemLoadAverage());
        }
        return o;
    }

    public ObjectNode getDetail() {
        return this.detail;
    }
}

