/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.executor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.constraints.expressions.LValueConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionLocationExpression;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicy;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.cc.executor.ActivityClusterPlanner;
import org.apache.hyracks.control.cc.executor.ActivityPartitionDetails;
import org.apache.hyracks.control.cc.executor.PartitionConstraintSolver;
import org.apache.hyracks.control.cc.executor.RankedRunnableTaskCluster;
import org.apache.hyracks.control.cc.executor.Runnability;
import org.apache.hyracks.control.cc.job.ActivityClusterPlan;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.job.Task;
import org.apache.hyracks.control.cc.job.TaskAttempt;
import org.apache.hyracks.control.cc.job.TaskCluster;
import org.apache.hyracks.control.cc.job.TaskClusterAttempt;
import org.apache.hyracks.control.cc.partitions.PartitionMatchMaker;
import org.apache.hyracks.control.cc.work.JobCleanupWork;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.hyracks.control.common.job.TaskAttemptDescriptor;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.NoOpCallback;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final JobRun jobRun;
    private final PartitionConstraintSolver solver;
    private final DeployedJobSpecId deployedJobSpecId;
    private final Map<PartitionId, TaskCluster> partitionProducingTaskClusterMap;
    private final Set<TaskCluster> inProgressTaskClusters;
    private final Random random;
    private boolean cancelled = false;

    public JobExecutor(ClusterControllerService ccs, JobRun jobRun, Collection<Constraint> constraints, DeployedJobSpecId deployedJobSpecId) {
        this.ccs = ccs;
        this.jobRun = jobRun;
        this.deployedJobSpecId = deployedJobSpecId;
        this.solver = new PartitionConstraintSolver();
        this.partitionProducingTaskClusterMap = new HashMap<PartitionId, TaskCluster>();
        this.inProgressTaskClusters = new HashSet<TaskCluster>();
        this.solver.addConstraints(constraints);
        this.random = new Random();
    }

    public boolean isDeployed() {
        return this.deployedJobSpecId != null;
    }

    public JobRun getJobRun() {
        return this.jobRun;
    }

    public PartitionConstraintSolver getSolver() {
        return this.solver;
    }

    public void startJob() throws HyracksException {
        this.startRunnableActivityClusters();
        this.ccs.getContext().notifyJobStart(this.jobRun.getJobId());
    }

    public void cancelJob(IResultCallback<Void> callback) throws HyracksException {
        if (this.jobRun.getPendingStatus() != null) {
            callback.setValue(null);
            return;
        }
        this.cancelled = true;
        this.abortOngoingTaskClusters(ta -> false, ta -> null);
        this.abortJob(Collections.singletonList(HyracksException.create((int)25, (Serializable[])new Serializable[]{this.jobRun.getJobId()})), callback);
    }

    private void findRunnableTaskClusterRoots(Set<TaskCluster> frontier, Collection<ActivityCluster> roots) throws HyracksException {
        for (ActivityCluster root : roots) {
            this.findRunnableTaskClusterRoots(frontier, root);
        }
    }

    private void findRunnableTaskClusterRoots(Set<TaskCluster> frontier, ActivityCluster candidate) throws HyracksException {
        boolean depsComplete = true;
        for (ActivityCluster depAC : candidate.getDependencies()) {
            if (!this.isPlanned(depAC)) {
                depsComplete = false;
                this.findRunnableTaskClusterRoots(frontier, depAC);
                continue;
            }
            boolean tcRootsComplete = true;
            for (TaskCluster tc : this.getActivityClusterPlan(depAC).getTaskClusters()) {
                TaskClusterAttempt tca;
                if (!tc.getProducedPartitions().isEmpty() || (tca = JobExecutor.findLastTaskClusterAttempt(tc)) != null && tca.getStatus() == TaskClusterAttempt.TaskClusterStatus.COMPLETED) continue;
                tcRootsComplete = false;
                break;
            }
            if (tcRootsComplete) continue;
            depsComplete = false;
            this.findRunnableTaskClusterRoots(frontier, depAC);
        }
        if (!depsComplete) {
            return;
        }
        if (!this.isPlanned(candidate)) {
            ActivityClusterPlanner acp = new ActivityClusterPlanner(this);
            ActivityClusterPlan acPlan = acp.planActivityCluster(candidate);
            this.jobRun.getActivityClusterPlanMap().put(candidate.getId(), acPlan);
            this.partitionProducingTaskClusterMap.putAll(acp.getPartitionProducingTaskClusterMap());
        }
        for (TaskCluster tc : this.getActivityClusterPlan(candidate).getTaskClusters()) {
            TaskClusterAttempt tca;
            if (!tc.getProducedPartitions().isEmpty() || (tca = JobExecutor.findLastTaskClusterAttempt(tc)) != null && tca.getStatus() == TaskClusterAttempt.TaskClusterStatus.COMPLETED) continue;
            frontier.add(tc);
        }
    }

    private ActivityClusterPlan getActivityClusterPlan(ActivityCluster ac) {
        return this.jobRun.getActivityClusterPlanMap().get(ac.getId());
    }

    private boolean isPlanned(ActivityCluster ac) {
        return this.jobRun.getActivityClusterPlanMap().get(ac.getId()) != null;
    }

    private void startRunnableActivityClusters() throws HyracksException {
        HashSet<TaskCluster> taskClusterRoots = new HashSet<TaskCluster>();
        this.findRunnableTaskClusterRoots(taskClusterRoots, this.jobRun.getActivityClusterGraph().getActivityClusterMap().values());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.log(Level.INFO, "Runnable TC roots: " + taskClusterRoots + ", inProgressTaskClusters: " + this.inProgressTaskClusters);
        }
        if (taskClusterRoots.isEmpty() && this.inProgressTaskClusters.isEmpty()) {
            this.ccs.getWorkQueue().schedule((AbstractWork)new JobCleanupWork(this.ccs.getJobManager(), this.jobRun.getJobId(), JobStatus.TERMINATED, null, (IResultCallback<Void>)NoOpCallback.INSTANCE));
            return;
        }
        this.startRunnableTaskClusters(taskClusterRoots);
    }

    private void startRunnableTaskClusters(Set<TaskCluster> tcRoots) throws HyracksException {
        HashMap<TaskCluster, Runnability> runnabilityMap = new HashMap<TaskCluster, Runnability>();
        for (TaskCluster taskCluster : tcRoots) {
            this.assignRunnabilityRank(taskCluster, runnabilityMap);
        }
        PriorityQueue<RankedRunnableTaskCluster> queue = new PriorityQueue<RankedRunnableTaskCluster>();
        for (Map.Entry entry : runnabilityMap.entrySet()) {
            int priority;
            TaskCluster tc = (TaskCluster)entry.getKey();
            Runnability runnability = (Runnability)entry.getValue();
            if (runnability.getTag() != Runnability.Tag.RUNNABLE || (priority = runnability.getPriority()) < 0 || priority >= Integer.MAX_VALUE) continue;
            queue.add(new RankedRunnableTaskCluster(priority, tc));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ranked TCs: " + queue);
        }
        HashMap<String, List<TaskAttemptDescriptor>> hashMap = new HashMap<String, List<TaskAttemptDescriptor>>();
        for (RankedRunnableTaskCluster rrtc : queue) {
            TaskCluster tc = rrtc.getTaskCluster();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found runnable TC: " + tc);
                List<TaskClusterAttempt> attempts = tc.getAttempts();
                LOGGER.debug("Attempts so far:" + attempts.size());
                for (TaskClusterAttempt tcAttempt : attempts) {
                    LOGGER.debug("Status: " + (Object)((Object)tcAttempt.getStatus()));
                }
            }
            this.assignTaskLocations(tc, hashMap);
        }
        if (hashMap.isEmpty()) {
            return;
        }
        this.startTasks(hashMap);
    }

    private Runnability assignRunnabilityRank(TaskCluster goal, Map<TaskCluster, Runnability> runnabilityMap) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Computing runnability: " + goal);
        }
        if (runnabilityMap.containsKey(goal)) {
            return runnabilityMap.get(goal);
        }
        TaskClusterAttempt lastAttempt = JobExecutor.findLastTaskClusterAttempt(goal);
        if (lastAttempt != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Last Attempt Status: " + (Object)((Object)lastAttempt.getStatus()));
            }
            if (lastAttempt.getStatus() == TaskClusterAttempt.TaskClusterStatus.COMPLETED) {
                Runnability runnability = new Runnability(Runnability.Tag.COMPLETED, Integer.MIN_VALUE);
                runnabilityMap.put(goal, runnability);
                return runnability;
            }
            if (lastAttempt.getStatus() == TaskClusterAttempt.TaskClusterStatus.RUNNING) {
                Runnability runnability = new Runnability(Runnability.Tag.RUNNING, Integer.MIN_VALUE);
                runnabilityMap.put(goal, runnability);
                return runnability;
            }
        }
        Map<ConnectorDescriptorId, IConnectorPolicy> connectorPolicyMap = this.jobRun.getConnectorPolicyMap();
        PartitionMatchMaker pmm = this.jobRun.getPartitionMatchMaker();
        Runnability aggregateRunnability = new Runnability(Runnability.Tag.RUNNABLE, 0);
        for (PartitionId pid : goal.getRequiredPartitions()) {
            Runnability runnability;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Inspecting required partition: " + pid);
            }
            ConnectorDescriptorId cdId = pid.getConnectorDescriptorId();
            IConnectorPolicy cPolicy = connectorPolicyMap.get(cdId);
            PartitionState maxState = pmm.getMaximumAvailableState(pid);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Policy: " + cPolicy + " maxState: " + maxState);
            }
            if (PartitionState.COMMITTED.equals((Object)maxState)) {
                runnability = new Runnability(Runnability.Tag.RUNNABLE, 0);
            } else if (PartitionState.STARTED.equals((Object)maxState) && !cPolicy.consumerWaitsForProducerToFinish()) {
                runnability = new Runnability(Runnability.Tag.RUNNABLE, 1);
            } else {
                runnability = this.assignRunnabilityRank(this.partitionProducingTaskClusterMap.get(pid), runnabilityMap);
                switch (runnability.getTag()) {
                    case RUNNABLE: {
                        if (cPolicy.consumerWaitsForProducerToFinish()) {
                            runnability = new Runnability(Runnability.Tag.NOT_RUNNABLE, Integer.MAX_VALUE);
                            break;
                        }
                        runnability = new Runnability(Runnability.Tag.RUNNABLE, runnability.getPriority() + 1);
                        break;
                    }
                    case NOT_RUNNABLE: {
                        break;
                    }
                    case RUNNING: {
                        if (cPolicy.consumerWaitsForProducerToFinish()) {
                            runnability = new Runnability(Runnability.Tag.NOT_RUNNABLE, Integer.MAX_VALUE);
                            break;
                        }
                        runnability = new Runnability(Runnability.Tag.RUNNABLE, 1);
                        break;
                    }
                }
            }
            aggregateRunnability = Runnability.getWorstCase(aggregateRunnability, runnability);
            if (aggregateRunnability.getTag() == Runnability.Tag.NOT_RUNNABLE) break;
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("aggregateRunnability: " + aggregateRunnability);
        }
        runnabilityMap.put(goal, aggregateRunnability);
        return aggregateRunnability;
    }

    private void assignTaskLocations(TaskCluster tc, Map<String, List<TaskAttemptDescriptor>> taskAttemptMap) throws HyracksException {
        TaskAttempt taskAttempt;
        TaskId tid;
        Task ts;
        int i;
        ActivityClusterGraph acg = this.jobRun.getActivityClusterGraph();
        Task[] tasks = tc.getTasks();
        List<TaskClusterAttempt> tcAttempts = tc.getAttempts();
        int attempts = tcAttempts.size();
        TaskClusterAttempt tcAttempt = new TaskClusterAttempt(tc, attempts);
        HashMap<TaskId, TaskAttempt> taskAttempts = new HashMap<TaskId, TaskAttempt>();
        HashMap<TaskId, LValueConstraintExpression> locationMap = new HashMap<TaskId, LValueConstraintExpression>();
        for (i = 0; i < tasks.length; ++i) {
            ts = tasks[i];
            tid = ts.getTaskId();
            taskAttempt = new TaskAttempt(tcAttempt, new TaskAttemptId(new TaskId(tid.getActivityId(), tid.getPartition()), attempts), ts);
            taskAttempt.setStatus(TaskAttempt.TaskStatus.INITIALIZED, null);
            locationMap.put(tid, (LValueConstraintExpression)new PartitionLocationExpression(tid.getActivityId().getOperatorDescriptorId(), tid.getPartition()));
            taskAttempts.put(tid, taskAttempt);
        }
        tcAttempt.setTaskAttempts(taskAttempts);
        this.solver.solve(locationMap.values());
        for (i = 0; i < tasks.length; ++i) {
            ts = tasks[i];
            tid = ts.getTaskId();
            taskAttempt = (TaskAttempt)taskAttempts.get(tid);
            String nodeId = this.assignLocation(acg, locationMap, tid, taskAttempt);
            taskAttempt.setNodeId(nodeId);
            taskAttempt.setStatus(TaskAttempt.TaskStatus.RUNNING, null);
            taskAttempt.setStartTime(System.currentTimeMillis());
            List<TaskAttemptDescriptor> tads2 = taskAttemptMap.get(nodeId);
            if (tads2 == null) {
                tads2 = new ArrayList<TaskAttemptDescriptor>();
                taskAttemptMap.put(nodeId, tads2);
            }
            OperatorDescriptorId opId = tid.getActivityId().getOperatorDescriptorId();
            this.jobRun.registerOperatorLocation(opId, tid.getPartition(), nodeId);
            ActivityPartitionDetails apd = ts.getActivityPlan().getActivityPartitionDetails();
            TaskAttemptDescriptor tad = new TaskAttemptDescriptor(taskAttempt.getTaskAttemptId(), apd.getPartitionCount(), apd.getInputPartitionCounts(), apd.getOutputPartitionCounts());
            tads2.add(tad);
        }
        tcAttempt.initializePendingTaskCounter();
        tcAttempts.add(tcAttempt);
        INodeManager nodeManager = this.ccs.getNodeManager();
        taskAttemptMap.forEach((key, tads) -> {
            for (TaskAttemptDescriptor tad : tads) {
                TaskAttemptId taid = tad.getTaskAttemptId();
                int attempt = taid.getAttempt();
                TaskId tid = taid.getTaskId();
                ActivityId aid = tid.getActivityId();
                List inConnectors = acg.getActivityInputs(aid);
                int[] inPartitionCounts = tad.getInputPartitionCounts();
                if (inPartitionCounts == null) continue;
                NetworkAddress[][] partitionLocations = new NetworkAddress[inPartitionCounts.length][];
                for (int i = 0; i < inPartitionCounts.length; ++i) {
                    ConnectorDescriptorId cdId = ((IConnectorDescriptor)inConnectors.get(i)).getConnectorId();
                    IConnectorPolicy policy = this.jobRun.getConnectorPolicyMap().get(cdId);
                    if (attempt > 0 && policy.materializeOnSendSide() && policy.consumerWaitsForProducerToFinish()) continue;
                    ActivityId producerAid = acg.getProducerActivity(cdId);
                    partitionLocations[i] = new NetworkAddress[inPartitionCounts[i]];
                    for (int j = 0; j < inPartitionCounts[i]; ++j) {
                        TaskId producerTaskId = new TaskId(producerAid, j);
                        String nodeId = this.findTaskLocation(producerTaskId);
                        partitionLocations[i][j] = nodeManager.getNodeControllerState(nodeId).getDataPort();
                    }
                }
                tad.setInputPartitionLocations((NetworkAddress[][])partitionLocations);
            }
        });
        tcAttempt.setStatus(TaskClusterAttempt.TaskClusterStatus.RUNNING);
        tcAttempt.setStartTime(System.currentTimeMillis());
        this.inProgressTaskClusters.add(tc);
    }

    private String assignLocation(ActivityClusterGraph acg, Map<TaskId, LValueConstraintExpression> locationMap, TaskId tid, TaskAttempt taskAttempt) throws HyracksException {
        ActivityId aid = tid.getActivityId();
        ActivityCluster ac = (ActivityCluster)acg.getActivityMap().get(aid);
        Set blockers = (Set)ac.getBlocked2BlockerMap().get(aid);
        String nodeId = null;
        if (blockers != null) {
            ActivityId blocker;
            Iterator iterator = blockers.iterator();
            while (iterator.hasNext() && (nodeId = this.findTaskLocation(new TaskId(blocker = (ActivityId)iterator.next(), tid.getPartition()))) == null) {
            }
        }
        INodeManager nodeManager = this.ccs.getNodeManager();
        Collection<String> liveNodes = nodeManager.getAllNodeIds();
        if (nodeId == null) {
            LValueConstraintExpression pLocationExpr = locationMap.get(tid);
            Object location = this.solver.getValue(pLocationExpr);
            if (location == null) {
                nodeId = liveNodes.toArray(new String[liveNodes.size()])[this.random.nextInt(liveNodes.size())];
            } else if (location instanceof String) {
                nodeId = (String)location;
            } else if (location instanceof String[]) {
                for (String choice : (String[])location) {
                    if (!liveNodes.contains(choice)) continue;
                    nodeId = choice;
                    break;
                }
                if (nodeId == null) {
                    throw new HyracksException("No satisfiable location found for " + taskAttempt.getTaskAttemptId());
                }
            } else {
                throw new HyracksException("Unknown type of value for " + pLocationExpr + ": " + location + "(" + location.getClass() + ")");
            }
        }
        if (nodeId == null) {
            throw new HyracksException("No satisfiable location found for " + taskAttempt.getTaskAttemptId());
        }
        if (!liveNodes.contains(nodeId)) {
            throw new HyracksException("Node " + nodeId + " not live");
        }
        return nodeId;
    }

    private String findTaskLocation(TaskId tid) {
        ActivityId aid = tid.getActivityId();
        ActivityCluster ac = (ActivityCluster)this.jobRun.getActivityClusterGraph().getActivityMap().get(aid);
        Task[] tasks = this.getActivityClusterPlan(ac).getActivityPlanMap().get(aid).getTasks();
        List<TaskClusterAttempt> tcAttempts = tasks[tid.getPartition()].getTaskCluster().getAttempts();
        if (tcAttempts == null || tcAttempts.isEmpty()) {
            return null;
        }
        TaskClusterAttempt lastTCA = tcAttempts.get(tcAttempts.size() - 1);
        TaskAttempt ta = lastTCA.getTaskAttempts().get(tid);
        return ta == null ? null : ta.getNodeId();
    }

    private static TaskClusterAttempt findLastTaskClusterAttempt(TaskCluster tc) {
        List<TaskClusterAttempt> attempts = tc.getAttempts();
        if (!attempts.isEmpty()) {
            return attempts.get(attempts.size() - 1);
        }
        return null;
    }

    private void startTasks(Map<String, List<TaskAttemptDescriptor>> taskAttemptMap) throws HyracksException {
        DeploymentId deploymentId = this.jobRun.getDeploymentId();
        JobId jobId = this.jobRun.getJobId();
        ActivityClusterGraph acg = this.jobRun.getActivityClusterGraph();
        HashMap<ConnectorDescriptorId, IConnectorPolicy> connectorPolicies = new HashMap<ConnectorDescriptorId, IConnectorPolicy>(this.jobRun.getConnectorPolicyMap());
        INodeManager nodeManager = this.ccs.getNodeManager();
        try {
            byte[] acgBytes = this.isDeployed() ? null : JavaSerializationUtils.serialize((Serializable)acg);
            for (Map.Entry<String, List<TaskAttemptDescriptor>> entry : taskAttemptMap.entrySet()) {
                String nodeId = entry.getKey();
                List<TaskAttemptDescriptor> taskDescriptors = entry.getValue();
                NodeControllerState node = nodeManager.getNodeControllerState(nodeId);
                if (node == null) continue;
                node.getActiveJobIds().add(this.jobRun.getJobId());
                boolean changed = this.jobRun.getParticipatingNodeIds().add(nodeId);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Starting: " + taskDescriptors + " at " + entry.getKey());
                }
                byte[] jagBytes = (byte[])(changed ? acgBytes : null);
                node.getNodeController().startTasks(deploymentId, jobId, jagBytes, taskDescriptors, connectorPolicies, this.jobRun.getFlags(), this.ccs.createOrGetJobParameterByteStore(jobId).getParameterMap(), this.deployedJobSpecId, this.jobRun.getStartTime());
            }
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    public void abortJob(List<Exception> exceptions, IResultCallback<Void> callback) {
        HashSet<TaskCluster> inProgressTaskClustersCopy = new HashSet<TaskCluster>(this.inProgressTaskClusters);
        for (TaskCluster tc : inProgressTaskClustersCopy) {
            this.abortTaskCluster(JobExecutor.findLastTaskClusterAttempt(tc), TaskClusterAttempt.TaskClusterStatus.ABORTED);
        }
        assert (this.inProgressTaskClusters.isEmpty());
        this.ccs.getWorkQueue().schedule((AbstractWork)new JobCleanupWork(this.ccs.getJobManager(), this.jobRun.getJobId(), JobStatus.FAILURE, exceptions, callback));
    }

    private void abortTaskCluster(TaskClusterAttempt tcAttempt, TaskClusterAttempt.TaskClusterStatus failedOrAbortedStatus) {
        LOGGER.debug("Aborting task cluster: " + tcAttempt.getAttempt());
        HashSet<TaskAttemptId> abortTaskIds = new HashSet<TaskAttemptId>();
        HashMap<String, List> abortTaskAttemptMap = new HashMap<String, List>();
        for (TaskAttempt ta : tcAttempt.getTaskAttempts().values()) {
            TaskAttemptId taId = ta.getTaskAttemptId();
            TaskAttempt.TaskStatus status = ta.getStatus();
            abortTaskIds.add(taId);
            LOGGER.debug("Checking " + taId + ": " + (Object)((Object)ta.getStatus()));
            if (status != TaskAttempt.TaskStatus.RUNNING && status != TaskAttempt.TaskStatus.COMPLETED) continue;
            ta.setStatus(TaskAttempt.TaskStatus.ABORTED, null);
            ta.setEndTime(System.currentTimeMillis());
            ArrayList<TaskAttemptId> abortTaskAttempts2 = (ArrayList<TaskAttemptId>)abortTaskAttemptMap.get(ta.getNodeId());
            if (status == TaskAttempt.TaskStatus.RUNNING && abortTaskAttempts2 == null) {
                abortTaskAttempts2 = new ArrayList<TaskAttemptId>();
                abortTaskAttemptMap.put(ta.getNodeId(), abortTaskAttempts2);
            }
            if (status != TaskAttempt.TaskStatus.RUNNING) continue;
            abortTaskAttempts2.add(taId);
        }
        JobId jobId = this.jobRun.getJobId();
        LOGGER.info("Abort map for job: " + jobId + ": " + abortTaskAttemptMap);
        INodeManager nodeManager = this.ccs.getNodeManager();
        abortTaskAttemptMap.forEach((key, abortTaskAttempts) -> {
            NodeControllerState node = nodeManager.getNodeControllerState((String)key);
            if (node != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Aborting: " + abortTaskAttempts + " at " + key);
                }
                try {
                    node.getNodeController().abortTasks(jobId, abortTaskAttempts);
                }
                catch (Exception e) {
                    LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
                }
            }
        });
        this.inProgressTaskClusters.remove(tcAttempt.getTaskCluster());
        TaskCluster tc = tcAttempt.getTaskCluster();
        PartitionMatchMaker pmm = this.jobRun.getPartitionMatchMaker();
        pmm.removeUncommittedPartitions(tc.getProducedPartitions(), abortTaskIds);
        pmm.removePartitionRequests(tc.getRequiredPartitions(), abortTaskIds);
        tcAttempt.setStatus(failedOrAbortedStatus);
        tcAttempt.setEndTime(System.currentTimeMillis());
    }

    private void abortDoomedTaskClusters() throws HyracksException {
        LOGGER.log(Level.INFO, "aborting doomed task clusters");
        HashSet<TaskCluster> doomedTaskClusters = new HashSet<TaskCluster>();
        for (TaskCluster tc : this.inProgressTaskClusters) {
            if (!tc.getProducedPartitions().isEmpty()) continue;
            this.findDoomedTaskClusters(tc, doomedTaskClusters);
        }
        LOGGER.log(Level.INFO, "number of doomed task clusters found = " + doomedTaskClusters.size());
        for (TaskCluster tc : doomedTaskClusters) {
            TaskClusterAttempt tca = JobExecutor.findLastTaskClusterAttempt(tc);
            if (tca == null) continue;
            this.abortTaskCluster(tca, TaskClusterAttempt.TaskClusterStatus.ABORTED);
        }
    }

    private boolean findDoomedTaskClusters(TaskCluster tc, Set<TaskCluster> doomedTaskClusters) {
        if (doomedTaskClusters.contains(tc)) {
            return true;
        }
        TaskClusterAttempt lastAttempt = JobExecutor.findLastTaskClusterAttempt(tc);
        if (lastAttempt != null) {
            switch (lastAttempt.getStatus()) {
                case ABORTED: 
                case FAILED: 
                case COMPLETED: {
                    return false;
                }
            }
        }
        Map<ConnectorDescriptorId, IConnectorPolicy> connectorPolicyMap = this.jobRun.getConnectorPolicyMap();
        PartitionMatchMaker pmm = this.jobRun.getPartitionMatchMaker();
        boolean doomed = false;
        for (TaskCluster depTC : tc.getDependencyTaskClusters()) {
            if (!this.findDoomedTaskClusters(depTC, doomedTaskClusters)) continue;
            doomed = true;
        }
        for (PartitionId pid : tc.getRequiredPartitions()) {
            ConnectorDescriptorId cdId = pid.getConnectorDescriptorId();
            IConnectorPolicy cPolicy = connectorPolicyMap.get(cdId);
            PartitionState maxState = pmm.getMaximumAvailableState(pid);
            if (maxState != null && (!cPolicy.consumerWaitsForProducerToFinish() || maxState == PartitionState.COMMITTED) || !this.findDoomedTaskClusters(this.partitionProducingTaskClusterMap.get(pid), doomedTaskClusters)) continue;
            doomed = true;
        }
        if (doomed) {
            doomedTaskClusters.add(tc);
        }
        return doomed;
    }

    public void notifyTaskComplete(TaskAttempt ta) {
        try {
            TaskAttemptId taId = ta.getTaskAttemptId();
            TaskCluster tc = ta.getTask().getTaskCluster();
            TaskClusterAttempt lastAttempt = JobExecutor.findLastTaskClusterAttempt(tc);
            if (lastAttempt == null || taId.getAttempt() != lastAttempt.getAttempt()) {
                LOGGER.warn(() -> "Ignoring task complete notification: " + taId + " -- Current last attempt = " + lastAttempt);
                return;
            }
            TaskAttempt.TaskStatus taStatus = ta.getStatus();
            if (taStatus != TaskAttempt.TaskStatus.RUNNING) {
                LOGGER.warn(() -> "Spurious task complete notification: " + taId + " Current state = " + (Object)((Object)taStatus));
                return;
            }
            ta.setStatus(TaskAttempt.TaskStatus.COMPLETED, null);
            ta.setEndTime(System.currentTimeMillis());
            if (lastAttempt.decrementPendingTasksCounter() == 0) {
                lastAttempt.setStatus(TaskClusterAttempt.TaskClusterStatus.COMPLETED);
                lastAttempt.setEndTime(System.currentTimeMillis());
                this.inProgressTaskClusters.remove(tc);
                this.startRunnableActivityClusters();
            }
        }
        catch (Exception e) {
            LOGGER.error(() -> "Unexpected failure. Aborting job " + this.jobRun.getJobId(), (Throwable)e);
            this.abortJob(Collections.singletonList(e), (IResultCallback<Void>)NoOpCallback.INSTANCE);
        }
    }

    public void notifyTaskFailure(TaskAttempt ta, List<Exception> exceptions) {
        try {
            LOGGER.log(Level.INFO, "Received failure notification for TaskAttempt " + ta.getTaskAttemptId());
            TaskAttemptId taId = ta.getTaskAttemptId();
            TaskCluster tc = ta.getTask().getTaskCluster();
            TaskClusterAttempt lastAttempt = JobExecutor.findLastTaskClusterAttempt(tc);
            if (lastAttempt != null && taId.getAttempt() == lastAttempt.getAttempt()) {
                LOGGER.log(Level.INFO, "Marking TaskAttempt " + ta.getTaskAttemptId() + " as failed");
                ta.setStatus(TaskAttempt.TaskStatus.FAILED, exceptions);
                this.abortTaskCluster(lastAttempt, TaskClusterAttempt.TaskClusterStatus.FAILED);
                this.abortDoomedTaskClusters();
                int maxReattempts = this.jobRun.getActivityClusterGraph().getMaxReattempts();
                LOGGER.log(Level.INFO, "Marking TaskAttempt " + ta.getTaskAttemptId() + " as failed and the number of max re-attempts = " + maxReattempts);
                if (lastAttempt.getAttempt() >= maxReattempts || this.isCancelled()) {
                    LOGGER.log(Level.INFO, "Aborting the job of " + ta.getTaskAttemptId());
                    this.abortJob(exceptions, (IResultCallback<Void>)NoOpCallback.INSTANCE);
                    return;
                }
                LOGGER.log(Level.INFO, "We will try to start runnable activity clusters of " + ta.getTaskAttemptId());
                this.startRunnableActivityClusters();
            } else {
                LOGGER.warn("Ignoring task failure notification: " + taId + " -- Current last attempt = " + lastAttempt);
            }
        }
        catch (Exception e) {
            this.abortJob(Collections.singletonList(e), (IResultCallback<Void>)NoOpCallback.INSTANCE);
        }
    }

    public void notifyNodeFailures(Collection<String> deadNodes) {
        try {
            this.jobRun.getPartitionMatchMaker().notifyNodeFailures(deadNodes);
            this.jobRun.getParticipatingNodeIds().removeAll(deadNodes);
            this.jobRun.getCleanupPendingNodeIds().removeAll(deadNodes);
            if (this.jobRun.getPendingStatus() != null && this.jobRun.getCleanupPendingNodeIds().isEmpty()) {
                IJobManager jobManager = this.ccs.getJobManager();
                jobManager.finalComplete(this.jobRun);
                return;
            }
            this.abortOngoingTaskClusters(ta -> deadNodes.contains(ta.getNodeId()), ta -> HyracksException.create((int)26, (Serializable[])new Serializable[]{ta.getNodeId()}));
            this.startRunnableActivityClusters();
        }
        catch (Exception e) {
            LOGGER.error(() -> "Unexpected failure. Aborting job " + this.jobRun.getJobId(), (Throwable)e);
            this.abortJob(Collections.singletonList(e), (IResultCallback<Void>)NoOpCallback.INSTANCE);
        }
    }

    private void abortOngoingTaskClusters(ITaskFilter taskFilter, IExceptionGenerator exceptionGenerator) throws HyracksException {
        for (ActivityCluster ac : this.jobRun.getActivityClusterGraph().getActivityClusterMap().values()) {
            TaskCluster[] taskClusters;
            if (!this.isPlanned(ac) || (taskClusters = this.getActivityClusterPlan(ac).getTaskClusters()) == null) continue;
            for (TaskCluster tc : taskClusters) {
                TaskClusterAttempt lastTaskClusterAttempt = JobExecutor.findLastTaskClusterAttempt(tc);
                if (lastTaskClusterAttempt == null || lastTaskClusterAttempt.getStatus() != TaskClusterAttempt.TaskClusterStatus.COMPLETED && lastTaskClusterAttempt.getStatus() != TaskClusterAttempt.TaskClusterStatus.RUNNING) continue;
                boolean abort = false;
                for (TaskAttempt ta : lastTaskClusterAttempt.getTaskAttempts().values()) {
                    assert (ta.getStatus() == TaskAttempt.TaskStatus.COMPLETED || ta.getStatus() == TaskAttempt.TaskStatus.RUNNING);
                    if (!taskFilter.directlyMarkAsFailed(ta)) continue;
                    ta.setStatus(TaskAttempt.TaskStatus.FAILED, Collections.singletonList(exceptionGenerator.getException(ta)));
                    ta.setEndTime(System.currentTimeMillis());
                    abort = true;
                }
                if (!abort) continue;
                this.abortTaskCluster(lastTaskClusterAttempt, TaskClusterAttempt.TaskClusterStatus.ABORTED);
            }
            this.abortDoomedTaskClusters();
        }
    }

    private boolean isCancelled() {
        return this.cancelled;
    }

    private static interface IExceptionGenerator {
        public HyracksException getException(TaskAttempt var1);
    }

    private static interface ITaskFilter {
        public boolean directlyMarkAsFailed(TaskAttempt var1);
    }
}

