/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.dataset;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.dataset.DatasetDirectoryRecord;
import org.apache.hyracks.api.dataset.DatasetJobRecord;
import org.apache.hyracks.api.dataset.IDatasetManager;
import org.apache.hyracks.api.dataset.IDatasetStateRecord;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.dataset.ResultSetMetaData;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.control.cc.dataset.IDatasetDirectoryService;
import org.apache.hyracks.control.cc.dataset.JobResultInfo;
import org.apache.hyracks.control.cc.dataset.Waiter;
import org.apache.hyracks.control.common.dataset.AbstractDatasetManager;
import org.apache.hyracks.control.common.dataset.ResultStateSweeper;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatasetDirectoryService
extends AbstractDatasetManager
implements IDatasetDirectoryService {
    private static final Logger LOGGER = LogManager.getLogger();
    private final long resultSweepThreshold;
    private final Map<JobId, JobResultInfo> jobResultLocations;

    public DatasetDirectoryService(long resultTTL, long resultSweepThreshold) {
        super(resultTTL);
        this.resultSweepThreshold = resultSweepThreshold;
        this.jobResultLocations = new LinkedHashMap<JobId, JobResultInfo>();
    }

    @Override
    public void init(ExecutorService executor) {
        executor.execute((Runnable)new ResultStateSweeper((IDatasetManager)this, this.resultSweepThreshold, LOGGER));
    }

    public synchronized void notifyJobCreation(JobId jobId, JobSpecification spec) throws HyracksException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(this.getClass().getSimpleName() + " notified of new job " + jobId);
        }
        if (this.jobResultLocations.get(jobId) != null) {
            throw HyracksDataException.create((int)15, (Serializable[])new Serializable[]{jobId});
        }
        this.jobResultLocations.put(jobId, new JobResultInfo(new DatasetJobRecord(), null));
    }

    public synchronized void notifyJobStart(JobId jobId) throws HyracksException {
        this.jobResultLocations.get(jobId).getRecord().start();
    }

    public void notifyJobFinish(JobId jobId, JobStatus jobStatus, List<Exception> exceptions) throws HyracksException {
    }

    private DatasetJobRecord getDatasetJobRecord(JobId jobId) {
        JobResultInfo jri = this.jobResultLocations.get(jobId);
        return jri == null ? null : jri.getRecord();
    }

    private DatasetJobRecord getNonNullDatasetJobRecord(JobId jobId) throws HyracksDataException {
        DatasetJobRecord djr = this.getDatasetJobRecord(jobId);
        if (djr == null) {
            throw HyracksDataException.create((int)24, (Serializable[])new Serializable[]{jobId});
        }
        return djr;
    }

    @Override
    public synchronized void registerResultPartitionLocation(JobId jobId, ResultSetId rsId, boolean orderedResult, boolean emptyResult, int partition, int nPartitions, NetworkAddress networkAddress) throws HyracksDataException {
        DatasetJobRecord djr = this.getNonNullDatasetJobRecord(jobId);
        djr.setResultSetMetaData(rsId, orderedResult, nPartitions);
        DatasetDirectoryRecord record = djr.getOrCreateDirectoryRecord(rsId, partition);
        record.setNetworkAddress(networkAddress);
        record.setEmpty(emptyResult);
        record.start();
        JobResultInfo jobResultInfo = this.jobResultLocations.get(jobId);
        Waiter waiter = jobResultInfo.getWaiter(rsId);
        if (waiter != null) {
            try {
                DatasetDirectoryRecord[] updatedRecords = this.updatedRecords(jobId, rsId, waiter.knownRecords);
                if (updatedRecords != null) {
                    jobResultInfo.removeWaiter(rsId);
                    waiter.callback.setValue((Object)updatedRecords);
                }
            }
            catch (Exception e) {
                waiter.callback.setException(e);
            }
        }
        this.notifyAll();
    }

    @Override
    public synchronized void reportResultPartitionWriteCompletion(JobId jobId, ResultSetId rsId, int partition) throws HyracksDataException {
        DatasetJobRecord djr = this.getNonNullDatasetJobRecord(jobId);
        djr.getDirectoryRecord(rsId, partition).writeEOS();
        djr.updateState(rsId);
        this.notifyAll();
    }

    @Override
    public synchronized void reportJobFailure(JobId jobId, List<Exception> exceptions) {
        LOGGER.log(Level.INFO, "job " + jobId + " failed and is being reported to " + this.getClass().getSimpleName(), (Throwable)exceptions.get(0));
        DatasetJobRecord djr = this.getDatasetJobRecord(jobId);
        LOGGER.log(Level.INFO, "Dataset job record is " + djr);
        if (djr != null) {
            LOGGER.log(Level.INFO, "Setting exceptions in Dataset job record");
            djr.fail(exceptions);
        }
        JobResultInfo jobResultInfo = this.jobResultLocations.get(jobId);
        LOGGER.log(Level.INFO, "Job result info is " + jobResultInfo);
        if (jobResultInfo != null) {
            LOGGER.log(Level.INFO, "Setting exceptions in Job result info");
            jobResultInfo.setException(exceptions.isEmpty() ? null : exceptions.get(0));
        }
        this.notifyAll();
    }

    @Override
    public synchronized DatasetJobRecord.Status getResultStatus(JobId jobId, ResultSetId rsId) throws HyracksDataException {
        return this.getNonNullDatasetJobRecord(jobId).getStatus();
    }

    public synchronized Set<JobId> getJobIds() {
        return this.jobResultLocations.keySet();
    }

    public IDatasetStateRecord getState(JobId jobId) {
        return this.getDatasetJobRecord(jobId);
    }

    public synchronized void sweep(JobId jobId) {
        this.jobResultLocations.remove(jobId);
    }

    @Override
    public synchronized void getResultPartitionLocations(JobId jobId, ResultSetId rsId, DatasetDirectoryRecord[] knownRecords, IResultCallback<DatasetDirectoryRecord[]> callback) throws HyracksDataException {
        DatasetDirectoryRecord[] updatedRecords = this.updatedRecords(jobId, rsId, knownRecords);
        if (updatedRecords == null) {
            this.jobResultLocations.get(jobId).addWaiter(rsId, knownRecords, callback);
        } else {
            callback.setValue((Object)updatedRecords);
        }
    }

    private DatasetDirectoryRecord[] updatedRecords(JobId jobId, ResultSetId rsId, DatasetDirectoryRecord[] knownRecords) throws HyracksDataException {
        DatasetJobRecord djr = this.getNonNullDatasetJobRecord(jobId);
        if (djr.getStatus().getState() == DatasetJobRecord.State.FAILED) {
            List caughtExceptions = djr.getStatus().getExceptions();
            if (caughtExceptions != null && !caughtExceptions.isEmpty()) {
                Exception cause = (Exception)caughtExceptions.get(caughtExceptions.size() - 1);
                if (cause instanceof HyracksDataException) {
                    throw (HyracksDataException)((Object)cause);
                }
                throw HyracksDataException.create((int)16, (Throwable)cause, (Serializable[])new Serializable[]{rsId, jobId});
            }
            throw HyracksDataException.create((int)17, (Serializable[])new Serializable[]{rsId, jobId});
        }
        ResultSetMetaData resultSetMetaData = djr.getResultSetMetaData(rsId);
        if (resultSetMetaData == null) {
            return null;
        }
        Object[] records = resultSetMetaData.getRecords();
        return Arrays.equals(records, knownRecords) ? null : records;
    }

    public PrintWriter print(PrintWriter pw) {
        for (JobId jId : this.getJobIds()) {
            pw.print(jId.toString());
            pw.print(" - ");
            pw.println(String.valueOf(this.getDatasetJobRecord(jId)));
        }
        pw.flush();
        return pw;
    }
}

