/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.application;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.application.IClusterLifecycleListener;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.context.ICCContext;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IJobLifecycleListener;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.application.ServiceContext;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.utils.HyracksThreadFactory;

public class CCServiceContext
extends ServiceContext
implements ICCServiceContext {
    private final ICCContext ccContext;
    protected final Set<String> initPendingNodeIds;
    protected final Set<String> deinitPendingNodeIds;
    private List<IJobLifecycleListener> jobLifecycleListeners;
    private List<IClusterLifecycleListener> clusterLifecycleListeners;
    private final ClusterControllerService ccs;

    public CCServiceContext(ClusterControllerService ccs, ServerContext serverCtx, ICCContext ccContext, IApplicationConfig appConfig) throws IOException {
        super(serverCtx, appConfig, (ThreadFactory)new HyracksThreadFactory("ClusterController"));
        this.ccContext = ccContext;
        this.ccs = ccs;
        this.initPendingNodeIds = new HashSet<String>();
        this.deinitPendingNodeIds = new HashSet<String>();
        this.jobLifecycleListeners = new ArrayList<IJobLifecycleListener>();
        this.clusterLifecycleListeners = new ArrayList<IClusterLifecycleListener>();
    }

    public ICCContext getCCContext() {
        return this.ccContext;
    }

    public void setDistributedState(Serializable state) {
        this.distributedState = state;
    }

    public void addJobLifecycleListener(IJobLifecycleListener jobLifecycleListener) {
        this.jobLifecycleListeners.add(jobLifecycleListener);
    }

    public synchronized void notifyJobStart(JobId jobId) throws HyracksException {
        for (IJobLifecycleListener l : this.jobLifecycleListeners) {
            l.notifyJobStart(jobId);
        }
    }

    public synchronized void notifyJobFinish(JobId jobId, JobStatus jobStatus, List<Exception> exceptions) throws HyracksException {
        for (IJobLifecycleListener l : this.jobLifecycleListeners) {
            l.notifyJobFinish(jobId, jobStatus, exceptions);
        }
    }

    public synchronized void notifyJobCreation(JobId jobId, JobSpecification spec) throws HyracksException {
        for (IJobLifecycleListener l : this.jobLifecycleListeners) {
            l.notifyJobCreation(jobId, spec);
        }
    }

    public void addClusterLifecycleListener(IClusterLifecycleListener clusterLifecycleListener) {
        this.clusterLifecycleListeners.add(clusterLifecycleListener);
    }

    public void notifyNodeJoin(String nodeId, Map<IOption, Object> ncConfiguration) throws HyracksException {
        for (IClusterLifecycleListener l : this.clusterLifecycleListeners) {
            l.notifyNodeJoin(nodeId, ncConfiguration);
        }
    }

    public void notifyNodeFailure(Collection<String> deadNodeIds) throws HyracksException {
        for (IClusterLifecycleListener l : this.clusterLifecycleListeners) {
            l.notifyNodeFailure(deadNodeIds);
        }
    }

    public IControllerService getControllerService() {
        return this.ccs;
    }

    public Object getApplicationContext() {
        return this.ccs.getApplicationContext();
    }
}

