/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class AInt64
implements IAObject {
    protected long value;

    public AInt64(long value) {
        this.value = value;
    }

    public long getLongValue() {
        return this.value;
    }

    @Override
    public IAType getType() {
        return BuiltinType.AINT64;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof AInt64)) {
            return false;
        }
        return this.value == ((AInt64)obj).getLongValue();
    }

    @Override
    public int hash() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("AInt64", this.value);
        return json;
    }
}

