/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import org.apache.asterix.dataflow.data.nontagged.keynormalizers.AUUIDNormalizedKeyComputerFactory;
import org.apache.asterix.dataflow.data.nontagged.keynormalizers.AWrappedAscNormalizedKeyComputerFactory;
import org.apache.asterix.dataflow.data.nontagged.keynormalizers.AWrappedDescNormalizedKeyComputerFactory;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.data.INormalizedKeyComputerFactoryProvider;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.dataflow.common.data.normalizers.ByteArrayNormalizedKeyComputerFactory;
import org.apache.hyracks.dataflow.common.data.normalizers.DoubleNormalizedKeyComputerFactory;
import org.apache.hyracks.dataflow.common.data.normalizers.FloatNormalizedKeyComputerFactory;
import org.apache.hyracks.dataflow.common.data.normalizers.Integer64NormalizedKeyComputerFactory;
import org.apache.hyracks.dataflow.common.data.normalizers.IntegerNormalizedKeyComputerFactory;
import org.apache.hyracks.dataflow.common.data.normalizers.UTF8StringNormalizedKeyComputerFactory;

public class NormalizedKeyComputerFactoryProvider
implements INormalizedKeyComputerFactoryProvider {
    public static final NormalizedKeyComputerFactoryProvider INSTANCE = new NormalizedKeyComputerFactoryProvider();

    private NormalizedKeyComputerFactoryProvider() {
    }

    public INormalizedKeyComputerFactory getNormalizedKeyComputerFactory(Object type, boolean ascending) {
        IAType aqlType = (IAType)type;
        if (ascending) {
            switch (aqlType.getTypeTag()) {
                case DATE: 
                case TIME: 
                case YEARMONTHDURATION: 
                case INTEGER: {
                    return new AWrappedAscNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new IntegerNormalizedKeyComputerFactory());
                }
                case DATETIME: 
                case DAYTIMEDURATION: 
                case BIGINT: {
                    return new AWrappedAscNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new Integer64NormalizedKeyComputerFactory());
                }
                case FLOAT: {
                    return new AWrappedAscNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new FloatNormalizedKeyComputerFactory());
                }
                case DOUBLE: {
                    return new AWrappedAscNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new DoubleNormalizedKeyComputerFactory());
                }
                case STRING: {
                    return new AWrappedAscNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new UTF8StringNormalizedKeyComputerFactory());
                }
                case BINARY: {
                    return new AWrappedAscNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new ByteArrayNormalizedKeyComputerFactory());
                }
                case UUID: {
                    return new AWrappedAscNormalizedKeyComputerFactory(new AUUIDNormalizedKeyComputerFactory());
                }
            }
            return null;
        }
        switch (aqlType.getTypeTag()) {
            case DATE: 
            case TIME: 
            case YEARMONTHDURATION: 
            case INTEGER: {
                return new AWrappedDescNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new IntegerNormalizedKeyComputerFactory());
            }
            case DATETIME: 
            case DAYTIMEDURATION: 
            case BIGINT: {
                return new AWrappedDescNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new Integer64NormalizedKeyComputerFactory());
            }
            case FLOAT: {
                return new AWrappedDescNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new FloatNormalizedKeyComputerFactory());
            }
            case DOUBLE: {
                return new AWrappedDescNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new DoubleNormalizedKeyComputerFactory());
            }
            case STRING: {
                return new AWrappedDescNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new UTF8StringNormalizedKeyComputerFactory());
            }
            case BINARY: {
                return new AWrappedDescNormalizedKeyComputerFactory((INormalizedKeyComputerFactory)new ByteArrayNormalizedKeyComputerFactory());
            }
            case UUID: {
                return new AWrappedDescNormalizedKeyComputerFactory(new AUUIDNormalizedKeyComputerFactory());
            }
        }
        return null;
    }
}

