/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.APolygon;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.marshalling.ShortSerializerDeserializer;

public class APolygonSerializerDeserializer
implements ISerializerDeserializer<APolygon> {
    private static final long serialVersionUID = 1L;
    public static final APolygonSerializerDeserializer INSTANCE = new APolygonSerializerDeserializer();

    private APolygonSerializerDeserializer() {
    }

    public APolygon deserialize(DataInput in) throws HyracksDataException {
        int numberOfPoints = ShortSerializerDeserializer.read((DataInput)in);
        APoint[] points = new APoint[numberOfPoints];
        for (int i = 0; i < numberOfPoints; ++i) {
            points[i] = APointSerializerDeserializer.read(in);
        }
        return new APolygon(points);
    }

    public void serialize(APolygon instance, DataOutput out) throws HyracksDataException {
        int n = instance.getNumberOfPoints();
        ShortSerializerDeserializer.write((short)n, (DataOutput)out);
        for (int i = 0; i < n; ++i) {
            APointSerializerDeserializer.write(instance.getPoints()[i], out);
        }
    }

    public static int getNumberOfPointsOffset() throws HyracksDataException {
        return 1;
    }

    public static int getCoordinateOffset(int pointId, Coordinate coordinate) throws HyracksDataException {
        switch (coordinate) {
            case X: {
                return 3 + pointId * 16;
            }
            case Y: {
                return 11 + pointId * 16;
            }
        }
        throw HyracksDataException.create((int)24, (Serializable[])new Serializable[0]);
    }

    public static void parse(String polygon, DataOutput out) throws HyracksDataException {
        try {
            String[] points = polygon.split(" ");
            if (points.length < 3) {
                throw HyracksDataException.create((int)25, (Serializable[])new Serializable[0]);
            }
            out.writeByte(ATypeTag.POLYGON.serialize());
            out.writeShort(points.length);
            for (int i = 0; i < points.length; ++i) {
                String[] split = points[i].split(",");
                APointSerializerDeserializer.serialize(Double.parseDouble(split[0]), Double.parseDouble(split[1]), out);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((int)26, (Throwable)e, (Serializable[])new Serializable[]{polygon});
        }
    }
}

