/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.printers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.hyracks.algebricks.data.utils.WriteValueTools;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.bytes.HexPrinter;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class PrintTools {
    private static final GregorianCalendarSystem gCalInstance = GregorianCalendarSystem.getInstance();
    private static long CHRONON_OF_DAY = 86400000L;

    public static void printDateString(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
        long chrononTime = (long)AInt32SerializerDeserializer.getInt(b, s + 1) * CHRONON_OF_DAY;
        try {
            gCalInstance.getExtendStringRepUntilField(chrononTime, 0, ps, GregorianCalendarSystem.Fields.YEAR, GregorianCalendarSystem.Fields.DAY, false);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static void printDateTimeString(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
        long chrononTime = AInt64SerializerDeserializer.getLong(b, s + 1);
        try {
            gCalInstance.getExtendStringRepUntilField(chrononTime, 0, ps, GregorianCalendarSystem.Fields.YEAR, GregorianCalendarSystem.Fields.MILLISECOND, true);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static void printDayTimeDurationString(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
        boolean positive = true;
        long milliseconds = AInt64SerializerDeserializer.getLong(b, s + 1);
        if (milliseconds < 0L) {
            milliseconds *= -1L;
            positive = false;
        }
        int millisecond = gCalInstance.getDurationMillisecond(milliseconds);
        int second = gCalInstance.getDurationSecond(milliseconds);
        int minute = gCalInstance.getDurationMinute(milliseconds);
        int hour = gCalInstance.getDurationHour(milliseconds);
        int day = gCalInstance.getDurationDay(milliseconds);
        if (!positive) {
            ps.print("-");
        }
        try {
            ps.print("P");
            if (day != 0) {
                WriteValueTools.writeInt((int)day, (OutputStream)ps);
                ps.print("D");
            }
            if (hour != 0 || minute != 0 || second != 0 || millisecond != 0) {
                ps.print("T");
            }
            if (hour != 0) {
                WriteValueTools.writeInt((int)hour, (OutputStream)ps);
                ps.print("H");
            }
            if (minute != 0) {
                WriteValueTools.writeInt((int)minute, (OutputStream)ps);
                ps.print("M");
            }
            if (second != 0 || millisecond != 0) {
                WriteValueTools.writeInt((int)second, (OutputStream)ps);
            }
            if (millisecond > 0) {
                ps.print(".");
                WriteValueTools.writeInt((int)millisecond, (OutputStream)ps);
            }
            if (second != 0 || millisecond != 0) {
                ps.print("S");
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static void printYearMonthDurationString(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
        GregorianCalendarSystem gCalInstance = GregorianCalendarSystem.getInstance();
        boolean positive = true;
        int months = AInt32SerializerDeserializer.getInt(b, s + 1);
        if (months < 0) {
            months *= -1;
            positive = false;
        }
        int month = gCalInstance.getDurationMonth(months);
        int year = gCalInstance.getDurationYear(months);
        if (!positive) {
            ps.print("-");
        }
        try {
            ps.print("P");
            if (year != 0) {
                WriteValueTools.writeInt((int)year, (OutputStream)ps);
                ps.print("Y");
            }
            if (month != 0) {
                WriteValueTools.writeInt((int)month, (OutputStream)ps);
                ps.print("M");
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static void printDurationString(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
        boolean positive = true;
        int months = AInt32SerializerDeserializer.getInt(b, s + 1);
        long milliseconds = AInt64SerializerDeserializer.getLong(b, s + 5);
        if (months < 0 || milliseconds < 0L) {
            months *= -1;
            milliseconds *= -1L;
            positive = false;
        }
        int month = gCalInstance.getDurationMonth(months);
        int year = gCalInstance.getDurationYear(months);
        int millisecond = gCalInstance.getDurationMillisecond(milliseconds);
        int second = gCalInstance.getDurationSecond(milliseconds);
        int minute = gCalInstance.getDurationMinute(milliseconds);
        int hour = gCalInstance.getDurationHour(milliseconds);
        int day = gCalInstance.getDurationDay(milliseconds);
        if (!positive) {
            ps.print("-");
        }
        try {
            ps.print("P");
            if (year != 0) {
                WriteValueTools.writeInt((int)year, (OutputStream)ps);
                ps.print("Y");
            }
            if (month != 0) {
                WriteValueTools.writeInt((int)month, (OutputStream)ps);
                ps.print("M");
            }
            if (day != 0) {
                WriteValueTools.writeInt((int)day, (OutputStream)ps);
                ps.print("D");
            }
            if (hour != 0 || minute != 0 || second != 0 || millisecond != 0) {
                ps.print("T");
            }
            if (hour != 0) {
                WriteValueTools.writeInt((int)hour, (OutputStream)ps);
                ps.print("H");
            }
            if (minute != 0) {
                WriteValueTools.writeInt((int)minute, (OutputStream)ps);
                ps.print("M");
            }
            if (second != 0 || millisecond != 0) {
                WriteValueTools.writeInt((int)second, (OutputStream)ps);
            }
            if (millisecond > 0) {
                ps.print(".");
                WriteValueTools.writeInt((int)millisecond, (OutputStream)ps);
            }
            if (second != 0 || millisecond != 0) {
                ps.print("S");
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static void printTimeString(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
        int time = AInt32SerializerDeserializer.getInt(b, s + 1);
        try {
            gCalInstance.getExtendStringRepUntilField(time, 0, ps, GregorianCalendarSystem.Fields.HOUR, GregorianCalendarSystem.Fields.MILLISECOND, true);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static void printDoubleForJson(byte[] b, int s, PrintStream ps) throws HyracksDataException {
        double d = ADoubleSerializerDeserializer.getDouble(b, s + 1);
        if (Double.isFinite(d)) {
            ps.print(d);
        } else {
            ps.append('\"');
            ps.print(Double.isNaN(d) ? "NaN" : (d == Double.POSITIVE_INFINITY ? "INF" : "-INF"));
            ps.append('\"');
        }
    }

    public static void printDouble(byte[] b, int s, PrintStream ps) throws HyracksDataException {
        double d = ADoubleSerializerDeserializer.getDouble(b, s + 1);
        if (Double.isFinite(d)) {
            ps.print(d);
        } else {
            ps.print(Double.isNaN(d) ? "NaN" : (d == Double.POSITIVE_INFINITY ? "INF" : "-INF"));
        }
    }

    public static void printFloatForJson(byte[] b, int s, PrintStream ps) throws HyracksDataException {
        float f = AFloatSerializerDeserializer.getFloat(b, s + 1);
        if (Float.isFinite(f)) {
            ps.print(f);
        } else {
            ps.print('\"');
            ps.print(Float.isNaN(f) ? "NaN" : (f == Float.POSITIVE_INFINITY ? "INF" : "-INF"));
            ps.print('\"');
        }
    }

    public static void printFloat(byte[] b, int s, PrintStream ps) throws HyracksDataException {
        float f = AFloatSerializerDeserializer.getFloat(b, s + 1);
        if (Float.isFinite(f)) {
            ps.print(f);
        } else {
            ps.print(Float.isNaN(f) ? "NaN" : (f == Float.POSITIVE_INFINITY ? "INF" : "-INF"));
        }
    }

    public static void writeUTF8StringAsCSV(byte[] b, int s, int l, OutputStream os) throws IOException {
        int sz;
        int position;
        int stringLength = UTF8StringUtil.getUTFLength((byte[])b, (int)s);
        int maxPosition = position + stringLength;
        os.write(34);
        for (position = s + UTF8StringUtil.getNumBytesToStoreLength((int)stringLength); position < maxPosition; position += sz) {
            char c = UTF8StringUtil.charAt((byte[])b, (int)position);
            sz = UTF8StringUtil.charSize((byte[])b, (int)position);
            if (c == '\"') {
                os.write(34);
            }
            os.write(c);
        }
        os.write(34);
    }

    public static void writeUTF8StringAsJSON(byte[] b, int s, int l, OutputStream os) throws IOException {
        int utfLength = UTF8StringUtil.getUTFLength((byte[])b, (int)s);
        int position = s + UTF8StringUtil.getNumBytesToStoreLength((int)utfLength);
        int maxPosition = position + utfLength;
        os.write(34);
        block17: while (position < maxPosition) {
            char c = UTF8StringUtil.charAt((byte[])b, (int)position);
            int sz = UTF8StringUtil.charSize((byte[])b, (int)position);
            switch (c) {
                case '\b': {
                    os.write(92);
                    os.write(98);
                    position += sz;
                    continue block17;
                }
                case '\f': {
                    os.write(92);
                    os.write(102);
                    position += sz;
                    continue block17;
                }
                case '\n': {
                    os.write(92);
                    os.write(110);
                    position += sz;
                    continue block17;
                }
                case '\r': {
                    os.write(92);
                    os.write(114);
                    position += sz;
                    continue block17;
                }
                case '\t': {
                    os.write(92);
                    os.write(116);
                    position += sz;
                    continue block17;
                }
                case '\"': 
                case '\\': {
                    os.write(92);
                }
            }
            switch (sz) {
                case 1: {
                    if (c > '\u001f' && c != '\u007f') break;
                    PrintTools.writeUEscape(os, c);
                    ++position;
                    sz = 0;
                    break;
                }
                case 2: {
                    switch (b[position]) {
                        case -64: {
                            if (b[position + 1] != -128) break;
                            PrintTools.writeUEscape(os, c);
                            position += 2;
                            sz = 0;
                            break;
                        }
                        case -62: {
                            if (b[position + 1] > -97) break;
                            PrintTools.writeUEscape(os, c);
                            position += 2;
                            sz = 0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (!Character.isHighSurrogate(c)) break;
                    position += PrintTools.writeSupplementaryChar(os, b, maxPosition, position, c, sz);
                    sz = 0;
                }
            }
            while (sz > 0) {
                os.write(b[position]);
                ++position;
                --sz;
            }
        }
        os.write(34);
    }

    private static void writeUEscape(OutputStream os, char c) throws IOException {
        os.write(92);
        os.write(117);
        os.write(48);
        os.write(48);
        os.write(HexPrinter.hex((int)(c >>> 4 & 0xF), (HexPrinter.CASE)HexPrinter.CASE.LOWER_CASE));
        os.write(HexPrinter.hex((int)(c & 0xF), (HexPrinter.CASE)HexPrinter.CASE.LOWER_CASE));
    }

    private static int writeSupplementaryChar(OutputStream os, byte[] src, int limit, int highSurrogatePos, char highSurrogate, int highSurrogateSize) throws IOException {
        int lowSurrogatePos = highSurrogatePos + highSurrogateSize;
        if (lowSurrogatePos >= limit) {
            throw new IllegalStateException("malformed utf8 input");
        }
        char lowSurrogate = UTF8StringUtil.charAt((byte[])src, (int)lowSurrogatePos);
        int lowSurrogateSize = UTF8StringUtil.charSize((byte[])src, (int)lowSurrogatePos);
        os.write(new String(new char[]{highSurrogate, lowSurrogate}).getBytes());
        return highSurrogateSize + lowSurrogateSize;
    }

    public static enum CASE {
        LOWER_CASE,
        UPPER_CASE;

    }
}

