/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.common;

import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.ExternalFunctionInfo;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public class ExpressionTypeComputer
implements IExpressionTypeComputer {
    public static final ExpressionTypeComputer INSTANCE = new ExpressionTypeComputer();

    private ExpressionTypeComputer() {
    }

    public Object getType(ILogicalExpression expr, IMetadataProvider<?, ?> metadataProvider, IVariableTypeEnvironment env) throws AlgebricksException {
        switch (expr.getExpressionTag()) {
            case CONSTANT: {
                return this.getTypeForConstant((ConstantExpression)expr, env);
            }
            case FUNCTION_CALL: {
                return this.getTypeForFunction((AbstractFunctionCallExpression)expr, env, metadataProvider);
            }
            case VARIABLE: {
                try {
                    return env.getVarType(((VariableReferenceExpression)expr).getVariableReference());
                }
                catch (Exception e) {
                    throw new AlgebricksException("Could not resolve type for " + expr.toString() + ",please check whether the used variable has been defined!", (Throwable)e);
                }
            }
        }
        throw new IllegalStateException();
    }

    private IAType getTypeForFunction(AbstractFunctionCallExpression expr, IVariableTypeEnvironment env, IMetadataProvider<?, ?> mp) throws AlgebricksException {
        FunctionIdentifier fi = expr.getFunctionIdentifier();
        FunctionSignature signature = new FunctionSignature(fi);
        IResultTypeComputer rtc = BuiltinFunctions.isBuiltinCompilerFunction(signature, true) ? BuiltinFunctions.getResultTypeComputer(fi) : ((ExternalFunctionInfo)expr.getFunctionInfo()).getResultTypeComputer();
        if (rtc == null) {
            throw new AlgebricksException("Type computer missing for " + fi);
        }
        return rtc.computeType((ILogicalExpression)expr, env, mp);
    }

    private IAType getTypeForConstant(ConstantExpression expr, IVariableTypeEnvironment env) {
        IAlgebricksConstantValue acv = expr.getValue();
        if (acv.isFalse() || acv.isTrue()) {
            return BuiltinType.ABOOLEAN;
        }
        if (acv.isMissing()) {
            return BuiltinType.AMISSING;
        }
        if (acv.isNull()) {
            return BuiltinType.ANULL;
        }
        AsterixConstantValue value = (AsterixConstantValue)acv;
        return value.getObject().getType();
    }
}

