/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.net.protocols.tcp.ITCPConnectionListener;
import org.apache.hyracks.net.protocols.tcp.TCPConnection;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TCPEndpoint {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ITCPConnectionListener connectionListener;
    private final int nThreads;
    private ServerSocketChannel serverSocketChannel;
    private InetSocketAddress localAddress;
    private IOThread[] ioThreads;
    private int nextThread;

    public TCPEndpoint(ITCPConnectionListener connectionListener, int nThreads) {
        this.connectionListener = connectionListener;
        this.nThreads = nThreads;
    }

    public void start(InetSocketAddress localAddress) throws IOException {
        if (localAddress != null) {
            this.serverSocketChannel = ServerSocketChannel.open();
            ServerSocket serverSocket = this.serverSocketChannel.socket();
            serverSocket.bind(localAddress);
            this.localAddress = (InetSocketAddress)serverSocket.getLocalSocketAddress();
        }
        this.ioThreads = new IOThread[this.nThreads];
        for (int i = 0; i < this.ioThreads.length; ++i) {
            this.ioThreads[i] = new IOThread();
        }
        if (localAddress != null) {
            for (IOThread ioThread : this.ioThreads) {
                ioThread.registerServerSocket(this.serverSocketChannel);
            }
        }
        for (IOThread ioThread : this.ioThreads) {
            ioThread.start();
        }
    }

    private synchronized int getNextThread() {
        int result = this.nextThread;
        this.nextThread = (this.nextThread + 1) % this.nThreads;
        return result;
    }

    public void initiateConnection(InetSocketAddress remoteAddress) {
        int targetThread = this.getNextThread();
        this.ioThreads[targetThread].initiateConnection(remoteAddress);
    }

    private void distributeIncomingConnection(SocketChannel channel) {
        int targetThread = this.getNextThread();
        this.ioThreads[targetThread].addIncomingConnection(channel);
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public String toString() {
        return "TCPEndpoint [Local Address: " + this.localAddress + "]";
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ ServerSocketChannel access$300(TCPEndpoint x0) {
        return x0.serverSocketChannel;
    }

    static /* synthetic */ void access$400(TCPEndpoint x0, SocketChannel x1) {
        x0.distributeIncomingConnection(x1);
    }

    private class IOThread
    extends Thread {
        private final List<InetSocketAddress> pendingConnections;
        private final List<InetSocketAddress> workingPendingConnections;
        private final List<SocketChannel> incomingConnections;
        private final List<SocketChannel> workingIncomingConnections;
        private final Selector selector;

        public IOThread() throws IOException {
            super("TCPEndpoint IO Thread [" + TCPEndpoint.this.localAddress + "]");
            this.setDaemon(true);
            this.setPriority(5);
            this.pendingConnections = new ArrayList<InetSocketAddress>();
            this.workingPendingConnections = new ArrayList<InetSocketAddress>();
            this.incomingConnections = new ArrayList<SocketChannel>();
            this.workingIncomingConnections = new ArrayList<SocketChannel>();
            this.selector = Selector.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block21: while (true) {
                        n = this.selector.select();
                        this.collectOutstandingWork();
                        if (!this.workingPendingConnections.isEmpty()) {
                            for (InetSocketAddress address : this.workingPendingConnections) {
                                channel = SocketChannel.open();
                                this.register(channel);
                                connect = false;
                                failure = false;
                                try {
                                    connect = channel.connect(address);
                                }
                                catch (IOException e) {
                                    failure = true;
                                    var8_14 = TCPEndpoint.access$100(TCPEndpoint.this);
                                    synchronized (var8_14) {
                                        TCPEndpoint.access$100(TCPEndpoint.this).connectionFailure(address, e);
                                    }
                                }
                                if (failure) continue;
                                if (!connect) {
                                    key = channel.register(this.selector, 8);
                                    key.attach(address);
                                    continue;
                                }
                                key = channel.register(this.selector, 0);
                                this.createConnection(key, channel);
                            }
                            this.workingPendingConnections.clear();
                        }
                        if (!this.workingIncomingConnections.isEmpty()) {
                            for (SocketChannel channel : this.workingIncomingConnections) {
                                this.register(channel);
                                sKey = channel.register(this.selector, 0);
                                connection = new TCPConnection(TCPEndpoint.this, channel, sKey, this.selector, TCPConnection.ConnectionType.INCOMING);
                                sKey.attach(connection);
                                failure = TCPEndpoint.access$100(TCPEndpoint.this);
                                synchronized (failure) {
                                    TCPEndpoint.access$100(TCPEndpoint.this).acceptedConnection(connection);
                                }
                            }
                            this.workingIncomingConnections.clear();
                        }
                        if (n <= 0) continue;
                        i = this.selector.selectedKeys().iterator();
                        while (true) {
                            if (i.hasNext()) ** break;
                            continue block21;
                            key = i.next();
                            i.remove();
                            sc = key.channel();
                            readable = key.isReadable();
                            writable = key.isWritable();
                            if (readable || writable) {
                                connection = (TCPConnection)key.attachment();
                                try {
                                    connection.getEventListener().notifyIOReady(connection, readable, writable);
                                }
                                catch (Exception e) {
                                    TCPEndpoint.access$200().error("Unexpected tcp io error in connection {}", (Object)connection, (Object)e);
                                    connection.getEventListener().notifyIOError(e);
                                    connection.close();
                                    var9_17 = TCPEndpoint.access$100(TCPEndpoint.this);
                                    synchronized (var9_17) {
                                        TCPEndpoint.access$100(TCPEndpoint.this).connectionClosed(connection);
                                        continue;
                                    }
                                }
                            }
                            if (key.isAcceptable()) {
                                if (!IOThread.$assertionsDisabled && sc != TCPEndpoint.access$300(TCPEndpoint.this)) {
                                    throw new AssertionError();
                                }
                                channel = TCPEndpoint.access$300(TCPEndpoint.this).accept();
                                TCPEndpoint.access$400(TCPEndpoint.this, channel);
                                continue;
                            }
                            if (!key.isConnectable()) continue;
                            channel = (SocketChannel)sc;
                            finishConnect = false;
                            try {
                                finishConnect = channel.finishConnect();
                            }
                            catch (IOException e) {
                                TCPEndpoint.access$200().error("Failed to finish connect to channel {}", key.attachment(), (Object)e);
                                key.cancel();
                                var10_20 = TCPEndpoint.access$100(TCPEndpoint.this);
                                synchronized (var10_20) {
                                    TCPEndpoint.access$100(TCPEndpoint.this).connectionFailure((InetSocketAddress)key.attachment(), e);
                                }
                            }
                            if (!finishConnect) continue;
                            this.createConnection(key, channel);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    TCPEndpoint.access$200().error("Error in TCPEndpoint {}", (Object)TCPEndpoint.this, (Object)e);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createConnection(SelectionKey key, SocketChannel channel) {
            TCPConnection connection = new TCPConnection(TCPEndpoint.this, channel, key, this.selector, TCPConnection.ConnectionType.OUTGOING);
            key.attach(connection);
            key.interestOps(0);
            ITCPConnectionListener iTCPConnectionListener = TCPEndpoint.this.connectionListener;
            synchronized (iTCPConnectionListener) {
                TCPEndpoint.this.connectionListener.connectionEstablished(connection);
            }
        }

        synchronized void initiateConnection(InetSocketAddress remoteAddress) {
            this.pendingConnections.add(remoteAddress);
            this.selector.wakeup();
        }

        synchronized void addIncomingConnection(SocketChannel channel) {
            this.incomingConnections.add(channel);
            this.selector.wakeup();
        }

        void registerServerSocket(ServerSocketChannel serverSocketChannel) throws IOException {
            serverSocketChannel.configureBlocking(false);
            serverSocketChannel.register(this.selector, 16);
        }

        private synchronized void collectOutstandingWork() {
            if (!this.pendingConnections.isEmpty()) {
                this.workingPendingConnections.addAll(this.pendingConnections);
                this.pendingConnections.clear();
            }
            if (!this.incomingConnections.isEmpty()) {
                this.workingIncomingConnections.addAll(this.incomingConnections);
                this.incomingConnections.clear();
            }
        }

        private void register(SocketChannel channel) throws IOException {
            NetworkUtil.configure((SocketChannel)channel);
            channel.configureBlocking(false);
        }
    }
}

