/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IPartialAggregationTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalGroupingProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.core.jobgen.impl.OperatorSchemaImpl;
import org.apache.hyracks.algebricks.runtime.base.ISerializedAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.aggreg.SerializableAggregatorDescriptorFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.group.HashSpillableTableFactory;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.ISpillableTableFactory;
import org.apache.hyracks.dataflow.std.group.external.ExternalGroupOperatorDescriptor;

public class ExternalGroupByPOperator
extends AbstractPhysicalOperator {
    private final long inputSize;
    private final int frameLimit;
    private List<LogicalVariable> columnSet = new ArrayList<LogicalVariable>();

    public ExternalGroupByPOperator(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> gbyList, int frameLimit, long fileSize) {
        this.frameLimit = frameLimit;
        this.inputSize = fileSize;
        this.computeColumnSet(gbyList);
    }

    public void computeColumnSet(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> gbyList) {
        this.columnSet.clear();
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : gbyList) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            VariableReferenceExpression v = (VariableReferenceExpression)expr;
            this.columnSet.add(v.getVariableReference());
        }
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.EXTERNAL_GROUP_BY;
    }

    @Override
    public String toString() {
        return this.getOperatorTag().toString() + this.columnSet;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    public List<LogicalVariable> getGbyColumns() {
        return this.columnSet;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        LinkedList<ILocalStructuralProperty> propsLocal = new LinkedList<ILocalStructuralProperty>();
        GroupByOperator gOp = (GroupByOperator)op;
        ListSet columnSet = new ListSet();
        if (!columnSet.isEmpty()) {
            propsLocal.add(new LocalGroupingProperty((Set<LogicalVariable>)columnSet));
        }
        for (ILogicalPlan p : gOp.getNestedPlans()) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                ILogicalOperator rOp = (ILogicalOperator)r.getValue();
                propsLocal.addAll(rOp.getDeliveredPhysicalProperties().getLocalProperties());
            }
        }
        ILogicalOperator op2 = (ILogicalOperator)op.getInputs().get(0).getValue();
        IPhysicalPropertiesVector childProp = op2.getDeliveredPhysicalProperties();
        this.deliveredProperties = new StructuralPropertiesVector(childProp.getPartitioningProperty(), propsLocal);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)op;
        if (aop.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED) {
            IPhysicalPropertiesVector[] pv = new StructuralPropertiesVector[]{new StructuralPropertiesVector(new UnorderedPartitionedProperty((Set<LogicalVariable>)new ListSet(this.columnSet), context.getComputationNodeDomain()), null)};
            return new PhysicalRequirements(pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
        }
        return this.emptyUnaryRequirements();
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        List<LogicalVariable> gbyCols = this.getGbyColumns();
        int[] keys = JobGenHelper.variablesToFieldIndexes(gbyCols, inputSchemas[0]);
        GroupByOperator gby = (GroupByOperator)op;
        int numFds = gby.getDecorList().size();
        int[] fdColumns = new int[numFds];
        int j = 0;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : gby.getDecorList()) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                throw new AlgebricksException("pre-sorted group-by expects variable references.");
            }
            VariableReferenceExpression v = (VariableReferenceExpression)expr;
            LogicalVariable decor = v.getVariableReference();
            fdColumns[j++] = inputSchemas[0].findVariable(decor);
        }
        if (gby.getNestedPlans().size() != 1) {
            throw new AlgebricksException("External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
        }
        ILogicalPlan p0 = gby.getNestedPlans().get(0);
        if (p0.getRoots().size() != 1) {
            throw new AlgebricksException("External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
        }
        Mutable<ILogicalOperator> r0 = p0.getRoots().get(0);
        AggregateOperator aggOp = (AggregateOperator)r0.getValue();
        this.compileSubplans(inputSchemas[0], gby, opSchema, context);
        IPartialAggregationTypeComputer partialAggregationTypeComputer = context.getPartialAggregationTypeComputer();
        ArrayList<Object> intermediateTypes = new ArrayList<Object>();
        int n = aggOp.getExpressions().size();
        ISerializedAggregateEvaluatorFactory[] aff = new ISerializedAggregateEvaluatorFactory[n];
        int i = 0;
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        ILogicalOperator aggOpInput = (ILogicalOperator)aggOp.getInputs().get(0).getValue();
        IOperatorSchema aggOpInputSchema = context.getSchema(aggOpInput);
        IOperatorSchema[] aggOpInputSchemas = new IOperatorSchema[]{aggOpInputSchema};
        IVariableTypeEnvironment aggOpInputEnv = context.getTypeEnvironment(aggOpInput);
        IVariableTypeEnvironment outputEnv = context.getTypeEnvironment(op);
        for (Mutable<ILogicalExpression> exprRef : aggOp.getExpressions()) {
            Iterator<Object> aggFun = (AggregateFunctionCallExpression)exprRef.getValue();
            aff[i++] = expressionRuntimeProvider.createSerializableAggregateFunctionFactory((AggregateFunctionCallExpression)((Object)aggFun), aggOpInputEnv, aggOpInputSchemas, context);
            intermediateTypes.add(partialAggregationTypeComputer.getType((ILogicalExpression)((Object)aggFun), aggOpInputEnv, context.getMetadataProvider()));
        }
        int[] keyAndDecFields = new int[keys.length + fdColumns.length];
        for (i = 0; i < keys.length; ++i) {
            keyAndDecFields[i] = keys[i];
        }
        for (i = 0; i < fdColumns.length; ++i) {
            keyAndDecFields[keys.length + i] = fdColumns[i];
        }
        ArrayList<Object> keyAndDecVariables = new ArrayList<Object>();
        for (Pair pair : gby.getGroupByList()) {
            keyAndDecVariables.add(pair.first);
        }
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> pair : gby.getDecorList()) {
            keyAndDecVariables.add(GroupByOperator.getDecorVariable(pair));
        }
        for (LogicalVariable logicalVariable : keyAndDecVariables) {
            aggOpInputEnv.setVarType(logicalVariable, outputEnv.getVarType(logicalVariable));
        }
        JobSpecification spec = builder.getJobSpec();
        IBinaryComparatorFactory[] iBinaryComparatorFactoryArray = JobGenHelper.variablesToAscBinaryComparatorFactories(gbyCols, aggOpInputEnv, context);
        RecordDescriptor recordDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), opSchema, context);
        IBinaryHashFunctionFamily[] hashFunctionFactories = JobGenHelper.variablesToBinaryHashFunctionFamilies(gbyCols, aggOpInputEnv, context);
        ISerializedAggregateEvaluatorFactory[] merges = new ISerializedAggregateEvaluatorFactory[n];
        ArrayList<LogicalVariable> usedVars = new ArrayList<LogicalVariable>();
        IOperatorSchema[] localInputSchemas = new IOperatorSchema[]{new OperatorSchemaImpl()};
        for (i = 0; i < n; ++i) {
            Iterator aggFun = (AggregateFunctionCallExpression)aggOp.getMergeExpressions().get(i).getValue();
            ((AbstractFunctionCallExpression)((Object)aggFun)).getUsedVariables(usedVars);
        }
        i = 0;
        for (Object e : intermediateTypes) {
            aggOpInputEnv.setVarType((LogicalVariable)usedVars.get(i++), e);
        }
        for (LogicalVariable logicalVariable : keyAndDecVariables) {
            localInputSchemas[0].addVariable(logicalVariable);
        }
        for (LogicalVariable logicalVariable : usedVars) {
            localInputSchemas[0].addVariable(logicalVariable);
        }
        for (i = 0; i < n; ++i) {
            AggregateFunctionCallExpression mergeFun = (AggregateFunctionCallExpression)aggOp.getMergeExpressions().get(i).getValue();
            merges[i] = expressionRuntimeProvider.createSerializableAggregateFunctionFactory(mergeFun, aggOpInputEnv, localInputSchemas, context);
        }
        SerializableAggregatorDescriptorFactory aggregatorFactory = new SerializableAggregatorDescriptorFactory(aff);
        SerializableAggregatorDescriptorFactory serializableAggregatorDescriptorFactory = new SerializableAggregatorDescriptorFactory(merges);
        INormalizedKeyComputerFactory normalizedKeyFactory = JobGenHelper.variablesToAscNormalizedKeyComputerFactory(gbyCols, aggOpInputEnv, context);
        int memoryBudgetInBytes = context.getFrameSize() * this.frameLimit;
        int groupByColumnsCount = gby.getGroupByList().size() + numFds;
        int hashTableSize = ExternalGroupOperatorDescriptor.calculateGroupByTableCardinality((long)memoryBudgetInBytes, (int)groupByColumnsCount, (int)context.getFrameSize());
        ExternalGroupOperatorDescriptor gbyOpDesc = new ExternalGroupOperatorDescriptor((IOperatorDescriptorRegistry)spec, hashTableSize, this.inputSize, keyAndDecFields, this.frameLimit, iBinaryComparatorFactoryArray, normalizedKeyFactory, (IAggregatorDescriptorFactory)aggregatorFactory, (IAggregatorDescriptorFactory)serializableAggregatorDescriptorFactory, recordDescriptor, recordDescriptor, (ISpillableTableFactory)new HashSpillableTableFactory(hashFunctionFactories));
        this.contributeOpDesc(builder, gby, (IOperatorDescriptor)gbyOpDesc);
        ILogicalOperator src = (ILogicalOperator)op.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, op, 0);
    }

    @Override
    public Pair<int[], int[]> getInputOutputDependencyLabels(ILogicalOperator op) {
        int[] inputDependencyLabels = new int[]{0};
        int[] outputDependencyLabels = new int[]{1};
        return new Pair((Object)inputDependencyLabels, (Object)outputDependencyLabels);
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return true;
    }
}

