/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.std;

import org.apache.hyracks.algebricks.data.IAWriter;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.SinkWriterRuntime;
import org.apache.hyracks.algebricks.runtime.writers.PrinterBasedWriterFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;

public class PrinterRuntimeFactory
implements IPushRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int[] printColumns;
    private final IPrinterFactory[] printerFactories;
    private final RecordDescriptor inputRecordDesc;

    public PrinterRuntimeFactory(int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputRecordDesc) {
        this.printColumns = printColumns;
        this.printerFactories = printerFactories;
        this.inputRecordDesc = inputRecordDesc;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("print [");
        for (int i = 0; i < this.printColumns.length; ++i) {
            if (i > 0) {
                buf.append("; ");
            }
            buf.append(this.printColumns[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public IPushRuntime[] createPushRuntime(IHyracksTaskContext ctx) {
        IAWriter w = PrinterBasedWriterFactory.INSTANCE.createWriter(this.printColumns, System.out, this.printerFactories, this.inputRecordDesc);
        return new IPushRuntime[]{new SinkWriterRuntime(w, System.out, this.inputRecordDesc)};
    }
}

