/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.group;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.preclustered.PreclusteredGroupWriter;

public class MicroPreClusteredGroupRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int[] groupFields;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IAggregatorDescriptorFactory aggregatorFactory;
    private final RecordDescriptor inRecordDesc;
    private final RecordDescriptor outRecordDesc;

    public MicroPreClusteredGroupRuntimeFactory(int[] groupFields, IBinaryComparatorFactory[] comparatorFactories, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDesc, int[] projectionList) {
        super(projectionList);
        if (projectionList != null) {
            throw new NotImplementedException("Cannot push projection into InMemorySortRuntime.");
        }
        this.groupFields = groupFields;
        this.comparatorFactories = comparatorFactories;
        this.aggregatorFactory = aggregatorFactory;
        this.inRecordDesc = inRecordDesc;
        this.outRecordDesc = outRecordDesc;
    }

    @Override
    public AbstractOneInputOneOutputPushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws HyracksDataException {
        final IBinaryComparator[] comparators = new IBinaryComparator[this.comparatorFactories.length];
        for (int i = 0; i < this.comparatorFactories.length; ++i) {
            comparators[i] = this.comparatorFactories[i].createBinaryComparator();
        }
        return new AbstractOneInputOneOutputPushRuntime(){
            private PreclusteredGroupWriter pgw;

            public void open() throws HyracksDataException {
                this.pgw = new PreclusteredGroupWriter(ctx, MicroPreClusteredGroupRuntimeFactory.this.groupFields, comparators, MicroPreClusteredGroupRuntimeFactory.this.aggregatorFactory, MicroPreClusteredGroupRuntimeFactory.this.inRecordDesc, MicroPreClusteredGroupRuntimeFactory.this.outRecordDesc, this.writer);
                this.pgw.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.pgw.nextFrame(buffer);
            }

            @Override
            public void fail() throws HyracksDataException {
                this.pgw.fail();
            }

            public void close() throws HyracksDataException {
                this.pgw.close();
            }

            public void flush() throws HyracksDataException {
                this.pgw.flush();
            }
        };
    }
}

