/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.base;

import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameAppender;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;

public abstract class AbstractOneInputOneOutputOneFramePushRuntime
extends AbstractOneInputOneOutputPushRuntime {
    protected IFrameAppender appender;
    protected IFrame frame;
    protected FrameTupleAccessor tAccess;
    protected FrameTupleReference tRef;

    protected final void initAccessAppend(IHyracksTaskContext ctx) throws HyracksDataException {
        this.frame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.appender = new FrameTupleAppender(this.frame);
        this.tAccess = new FrameTupleAccessor(this.inputRecordDesc);
    }

    protected final void initAccessAppendRef(IHyracksTaskContext ctx) throws HyracksDataException {
        this.initAccessAppend(ctx);
        this.tRef = new FrameTupleReference();
    }

    public void close() throws HyracksDataException {
        HyracksDataException closeException = null;
        try {
            this.flushIfNotFailed();
        }
        catch (Exception e) {
            closeException = HyracksDataException.create((Throwable)e);
            this.writer.fail();
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                if (closeException == null) {
                    closeException = HyracksDataException.create((Throwable)e);
                }
                closeException.addSuppressed((Throwable)e);
            }
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    protected void flushAndReset() throws HyracksDataException {
        if (this.appender.getTupleCount() > 0) {
            this.appender.write(this.writer, true);
        }
    }

    protected void flushIfNotFailed() throws HyracksDataException {
        if (!this.failed) {
            this.flushAndReset();
        }
    }

    protected IFrameTupleAppender getTupleAppender() {
        return (FrameTupleAppender)this.appender;
    }

    protected void appendToFrameFromTupleBuilder(ArrayTupleBuilder tb) throws HyracksDataException {
        this.appendToFrameFromTupleBuilder(tb, false);
    }

    protected void appendToFrameFromTupleBuilder(ArrayTupleBuilder tb, boolean flushFrame) throws HyracksDataException {
        FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.getTupleAppender(), (int[])tb.getFieldEndOffsets(), (byte[])tb.getByteArray(), (int)0, (int)tb.getSize());
        if (flushFrame) {
            this.flushAndReset();
        }
    }

    protected void appendProjectionToFrame(int tIndex, int[] projectionList) throws HyracksDataException {
        this.appendProjectionToFrame(tIndex, projectionList, false);
    }

    protected void appendProjectionToFrame(int tIndex, int[] projectionList, boolean flushFrame) throws HyracksDataException {
        FrameUtils.appendProjectionToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.getTupleAppender(), (IFrameTupleAccessor)this.tAccess, (int)tIndex, (int[])projectionList);
        if (flushFrame) {
            this.flushAndReset();
        }
    }

    protected void appendTupleToFrame(int tIndex) throws HyracksDataException {
        FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.getTupleAppender(), (IFrameTupleAccessor)this.tAccess, (int)tIndex);
    }

    protected void appendConcat(IFrameTupleAccessor accessor0, int tIndex0, IFrameTupleAccessor accessor1, int tIndex1) throws HyracksDataException {
        FrameUtils.appendConcatToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.getTupleAppender(), (IFrameTupleAccessor)accessor0, (int)tIndex0, (IFrameTupleAccessor)accessor1, (int)tIndex1);
    }
}

