/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.aggregators;

import java.io.IOException;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class TupleCountAggregateFunctionFactory
implements IAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public IAggregateEvaluator createAggregateEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        return new IAggregateEvaluator(){
            int cnt;

            @Override
            public void step(IFrameTupleReference tuple) throws HyracksDataException {
                ++this.cnt;
            }

            @Override
            public void init() throws HyracksDataException {
                this.cnt = 0;
            }

            @Override
            public void finish(IPointable result) throws HyracksDataException {
                try {
                    abvs.reset();
                    abvs.getDataOutput().writeInt(this.cnt);
                    result.set((IValueReference)abvs);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            @Override
            public void finishPartial(IPointable result) throws HyracksDataException {
                this.finish(result);
            }
        };
    }
}

