/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.common.constraints;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksCountPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class AlgebricksAbsolutePartitionConstraint
extends AlgebricksPartitionConstraint {
    private final String[] locations;

    public AlgebricksAbsolutePartitionConstraint(String[] locations) {
        this.locations = (String[])locations.clone();
        Arrays.sort(locations);
    }

    @Override
    public AlgebricksPartitionConstraint.PartitionConstraintType getPartitionConstraintType() {
        return AlgebricksPartitionConstraint.PartitionConstraintType.ABSOLUTE;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public String toString() {
        return this.getPartitionConstraintType().toString() + ':' + Arrays.toString(this.locations);
    }

    @Override
    public AlgebricksPartitionConstraint compose(AlgebricksPartitionConstraint that) throws AlgebricksException {
        switch (that.getPartitionConstraintType()) {
            case COUNT: {
                AlgebricksCountPartitionConstraint thatCount = (AlgebricksCountPartitionConstraint)that;
                if (this.locations.length > thatCount.getCount()) break;
                return this;
            }
            case ABSOLUTE: {
                AlgebricksAbsolutePartitionConstraint thatAbsolute = (AlgebricksAbsolutePartitionConstraint)that;
                if (!Arrays.equals(this.locations, thatAbsolute.locations)) break;
                return this;
            }
        }
        throw AlgebricksException.create(10001, new Serializable[]{this.toString(), that.toString()});
    }
}

