/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.util.concurrent.TimeUnit;
import org.apache.hyracks.util.ThrowingAction;

public class Span {
    private final long startNanos = System.nanoTime();
    private final long spanNanos;

    private Span(long span, TimeUnit unit) {
        this.spanNanos = unit.toNanos(span);
    }

    public static Span start(long span, TimeUnit unit) {
        return new Span(span, unit);
    }

    public boolean elapsed() {
        return this.elapsed(TimeUnit.NANOSECONDS) > this.spanNanos;
    }

    public long elapsed(TimeUnit unit) {
        return unit.convert(System.nanoTime() - this.startNanos, TimeUnit.NANOSECONDS);
    }

    public void sleep(long sleep, TimeUnit unit) throws InterruptedException {
        TimeUnit.NANOSECONDS.sleep(Math.min(this.elapsed(TimeUnit.NANOSECONDS), unit.toNanos(sleep)));
    }

    public long remaining(TimeUnit unit) {
        return unit.convert(Long.max(this.spanNanos - this.elapsed(TimeUnit.NANOSECONDS), 0L), TimeUnit.NANOSECONDS);
    }

    public void loopUntilExhausted(ThrowingAction action) throws Exception {
        this.loopUntilExhausted(action, 0L, TimeUnit.NANOSECONDS);
    }

    public void loopUntilExhausted(ThrowingAction action, long delay, TimeUnit delayUnit) throws Exception {
        while (!this.elapsed()) {
            action.run();
            if (this.elapsed(delayUnit) < delay) break;
            delayUnit.sleep(delay);
        }
    }
}

