/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExitUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int EC_NORMAL_TERMINATION = 0;
    public static final int EC_ABNORMAL_TERMINATION = 1;
    public static final int EC_FAILED_TO_STARTUP = 2;
    public static final int EC_FAILED_TO_RECOVER = 3;
    public static final int NC_FAILED_TO_ABORT_ALL_PREVIOUS_TASKS = 4;
    public static final int EC_UNHANDLED_EXCEPTION = 11;
    public static final int EC_IMMEDIATE_HALT = 33;
    public static final int EC_HALT_ABNORMAL_RESERVED_44 = 44;
    public static final int EC_HALT_ABNORMAL_RESERVED_55 = 55;
    public static final int EC_HALT_SHUTDOWN_TIMED_OUT = 66;
    public static final int EC_HALT_WATCHDOG_FAILED = 77;
    public static final int EC_HALT_ABNORMAL_RESERVED_88 = 88;
    public static final int EC_TERMINATE_NC_SERVICE_DIRECTIVE = 99;
    private static final ExitThread exitThread = new ExitThread();
    private static final ShutdownWatchdog watchdogThread = new ShutdownWatchdog();
    private static final MutableLong shutdownHaltDelay = new MutableLong(600000L);

    private ExitUtil() {
    }

    public static void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(int status) {
        ExitThread exitThread = ExitUtil.exitThread;
        synchronized (exitThread) {
            if (ExitUtil.exitThread.isAlive()) {
                LOGGER.warn("ignoring duplicate request to exit with status " + status + "; already exiting with status " + ExitUtil.exitThread.status + "...");
            } else {
                ExitUtil.exitThread.setStatus(status);
                ExitUtil.exitThread.start();
            }
        }
    }

    public static void exit(int status, long timeBeforeHalt, TimeUnit timeBeforeHaltUnit) {
        shutdownHaltDelay.setValue(timeBeforeHaltUnit.toMillis(timeBeforeHalt));
        ExitUtil.exit(status);
    }

    public static void halt(int status) {
        LOGGER.fatal("JVM halting with status " + status + "; bye!", new Throwable("halt stacktrace"));
        LogManager.shutdown();
        Runtime.getRuntime().halt(status);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(watchdogThread::start));
    }

    private static class ExitThread
    extends Thread {
        private int status;

        ExitThread() {
            super("JVM exit thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                LOGGER.info("JVM exiting with status " + this.status + "; bye!");
            }
            finally {
                Runtime.getRuntime().exit(this.status);
            }
        }

        public void setStatus(int status) {
            this.status = status;
        }
    }

    private static class ShutdownWatchdog
    extends Thread {
        private ShutdownWatchdog() {
            super("ShutdownWatchdog");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block5: {
                try {
                    exitThread.join(shutdownHaltDelay.getValue());
                    if (!exitThread.isAlive()) break block5;
                    try {
                        LOGGER.info("Watchdog is angry. Killing shutdown hook");
                    }
                    finally {
                        ExitUtil.halt(66);
                    }
                }
                catch (Throwable th) {
                    ExitUtil.halt(77);
                }
            }
        }
    }
}

