/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.InvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeTupleReference;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class FixedSizeElementInvertedListCursor
extends InvertedListCursor {
    private final IBufferCache bufferCache;
    private final int fileId;
    private final int elementSize;
    private int currentElementIxForScan;
    private int currentOffsetForScan;
    private int currentPageIxForScan;
    private int startPageId;
    private int endPageId;
    private int startOff;
    private int numElements;
    private int numPages;
    private int bufferStartPageId;
    private int bufferEndPageId;
    private int bufferStartElementIx;
    private int bufferEndElementIx;
    private int bufferNumLoadedPages;
    private final FixedSizeTupleReference tuple;
    private final FixedSizeTupleReference bufferEndElementTuple;
    private ICachedPage page;
    private int[] elementIndexes = new int[10];
    private final ISimpleFrameBufferManager bufferManagerForSearch;
    private ArrayList<ByteBuffer> buffers;
    private boolean moreBlocksToRead = true;
    private int lastRandomSearchedElementIx;

    public FixedSizeElementInvertedListCursor(IBufferCache bufferCache, int fileId, ITypeTraits[] invListFields, IHyracksTaskContext ctx) throws HyracksDataException {
        this.bufferCache = bufferCache;
        this.fileId = fileId;
        int tmpSize = 0;
        for (int i = 0; i < invListFields.length; ++i) {
            tmpSize += invListFields[i].getFixedLength();
        }
        this.elementSize = tmpSize;
        this.currentOffsetForScan = -this.elementSize;
        this.currentElementIxForScan = 0;
        this.currentPageIxForScan = 0;
        this.bufferStartPageId = 0;
        this.bufferEndPageId = 0;
        this.bufferStartElementIx = 0;
        this.bufferEndElementIx = 0;
        this.bufferNumLoadedPages = 0;
        this.lastRandomSearchedElementIx = 0;
        this.moreBlocksToRead = true;
        this.tuple = new FixedSizeTupleReference(invListFields);
        this.bufferEndElementTuple = new FixedSizeTupleReference(invListFields);
        this.buffers = new ArrayList();
        if (ctx == null) {
            throw HyracksDataException.create((int)110, (Serializable[])new Serializable[0]);
        }
        this.bufferManagerForSearch = (ISimpleFrameBufferManager)TaskUtil.get((String)"INVERTED_INDEX_SEARCH_FRAME_MANAGER", (IHyracksTaskContext)ctx);
        if (this.bufferManagerForSearch == null) {
            throw HyracksDataException.create((int)111, (Serializable[])new Serializable[0]);
        }
    }

    private void allocateBuffers() throws HyracksDataException {
        ByteBuffer tmpBuffer;
        while ((tmpBuffer = this.bufferManagerForSearch.acquireFrame(this.bufferCache.getPageSize())) != null) {
            Arrays.fill(tmpBuffer.array(), (byte)0);
            this.buffers.add(tmpBuffer);
            if (this.buffers.size() < this.numPages) continue;
        }
        if (this.buffers.isEmpty()) {
            throw HyracksDataException.create((int)109, (Serializable[])new Serializable[]{FixedSizeElementInvertedListCursor.class.getName()});
        }
    }

    private void deallocateBuffers() throws HyracksDataException {
        for (int i = 0; i < this.buffers.size(); ++i) {
            this.bufferManagerForSearch.releaseFrame(this.buffers.get(i));
            this.buffers.set(i, null);
        }
        this.buffers.clear();
    }

    private void clearBuffers() throws HyracksDataException {
        for (int i = 0; i < this.buffers.size(); ++i) {
            Arrays.fill(this.buffers.get(i).array(), (byte)0);
            this.buffers.get(i).clear();
        }
    }

    public boolean doHasNext() {
        return this.currentElementIxForScan < this.numElements;
    }

    public void doNext() throws HyracksDataException {
        if (this.currentOffsetForScan + 2 * this.elementSize > this.bufferCache.getPageSize()) {
            ++this.currentPageIxForScan;
            this.currentOffsetForScan = 0;
        } else {
            this.currentOffsetForScan += this.elementSize;
        }
        if (this.currentElementIxForScan > this.bufferEndElementIx && this.endPageId > this.bufferEndPageId) {
            this.loadPages();
            this.currentOffsetForScan = 0;
        }
        ++this.currentElementIxForScan;
        this.tuple.reset(this.buffers.get(this.currentPageIxForScan).array(), this.currentOffsetForScan);
    }

    @Override
    public void prepareLoadPages() throws HyracksDataException {
        this.clearBuffers();
        if (this.numPages > this.buffers.size()) {
            this.allocateBuffers();
        }
    }

    @Override
    public void loadPages() throws HyracksDataException {
        this.bufferStartPageId = this.bufferEndPageId + 1;
        if (this.bufferStartPageId > this.endPageId) {
            return;
        }
        int currentBufferIdx = 0;
        int i = this.bufferStartPageId;
        while (i <= this.endPageId) {
            this.page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)i), false);
            ByteBuffer tmpBuffer = this.page.getBuffer();
            tmpBuffer.rewind();
            this.buffers.get(currentBufferIdx).rewind();
            this.buffers.get(currentBufferIdx).put(tmpBuffer);
            this.bufferCache.unpin(this.page);
            this.bufferEndPageId = i++;
            if (++currentBufferIdx >= this.buffers.size()) break;
        }
        this.setBlockInfo();
    }

    private void setBlockInfo() {
        this.bufferNumLoadedPages = this.bufferEndPageId - this.bufferStartPageId + 1;
        this.lastRandomSearchedElementIx = this.bufferStartElementIx = this.bufferStartPageId == this.startPageId ? 0 : this.elementIndexes[this.bufferStartPageId - this.startPageId - 1] + 1;
        this.bufferEndElementIx = this.elementIndexes[this.bufferEndPageId - this.startPageId];
        this.getElementAtIndex(this.bufferEndElementIx, this.bufferEndElementTuple);
        this.currentPageIxForScan = 0;
        int n = this.currentOffsetForScan = this.bufferStartElementIx == 0 ? this.startOff - this.elementSize : -this.elementSize;
        if (this.bufferEndPageId == this.endPageId) {
            this.moreBlocksToRead = false;
        }
    }

    @Override
    public void unloadPages() throws HyracksDataException {
        this.deallocateBuffers();
    }

    private boolean needToReadNextBlock(ITupleReference searchTuple, MultiComparator invListCmp) throws HyracksDataException {
        return this.moreBlocksToRead && invListCmp.compare(searchTuple, (ITupleReference)this.bufferEndElementTuple) > 0;
    }

    private void getElementAtIndex(int elementIx, FixedSizeTupleReference tuple) {
        int currentOff;
        int currentPageIx = this.binarySearch(this.elementIndexes, this.bufferStartPageId - this.startPageId, this.bufferNumLoadedPages, elementIx);
        if (currentPageIx < 0) {
            throw new IndexOutOfBoundsException("Requested index: " + elementIx + " from array with numElements: " + this.numElements);
        }
        if (currentPageIx == 0) {
            currentOff = this.startOff + elementIx * this.elementSize;
        } else {
            int relativeElementIx = elementIx - this.elementIndexes[currentPageIx - 1] - 1;
            currentOff = relativeElementIx * this.elementSize;
        }
        int bufferIdx = currentPageIx % this.buffers.size();
        tuple.reset(this.buffers.get(bufferIdx).array(), currentOff);
    }

    @Override
    public boolean containsKey(ITupleReference searchTuple, MultiComparator invListCmp) throws HyracksDataException {
        if (this.needToReadNextBlock(searchTuple, invListCmp)) {
            this.loadPages();
        }
        int mid = -1;
        int begin = this.lastRandomSearchedElementIx;
        int end = this.bufferEndElementIx;
        while (begin <= end) {
            mid = (begin + end) / 2;
            this.getElementAtIndex(mid, this.tuple);
            int cmp = invListCmp.compare(searchTuple, (ITupleReference)this.tuple);
            if (cmp < 0) {
                end = mid - 1;
                continue;
            }
            if (cmp > 0) {
                begin = mid + 1;
                continue;
            }
            this.lastRandomSearchedElementIx = mid;
            return true;
        }
        this.lastRandomSearchedElementIx = mid;
        return false;
    }

    @Override
    protected void setInvListInfo(int startPageId, int endPageId, int startOff, int numElements) throws HyracksDataException {
        this.startPageId = startPageId;
        this.endPageId = endPageId;
        this.startOff = startOff;
        this.numElements = numElements;
        this.currentElementIxForScan = 0;
        this.currentPageIxForScan = 0;
        this.currentOffsetForScan = startOff - this.elementSize;
        this.bufferStartPageId = startPageId;
        this.bufferEndPageId = startPageId - 1;
        this.moreBlocksToRead = true;
        this.numPages = endPageId - startPageId + 1;
        if (this.numPages > this.elementIndexes.length) {
            this.elementIndexes = new int[this.numPages];
        }
        for (ByteBuffer buffer : this.buffers) {
            buffer.clear();
        }
        int cumulElements = (this.bufferCache.getPageSize() - startOff) / this.elementSize;
        this.elementIndexes[0] = cumulElements - 1;
        for (int i = 1; i < this.numPages - 1; ++i) {
            this.elementIndexes[i] = this.elementIndexes[i - 1] + this.bufferCache.getPageSize() / this.elementSize;
        }
        this.elementIndexes[this.numPages - 1] = numElements - 1;
    }

    @Override
    public String printInvList(ISerializerDeserializer[] serdes) throws HyracksDataException {
        int oldCurrentOff = this.currentOffsetForScan;
        int oldCurrentPageId = this.currentPageIxForScan;
        int oldCurrentElementIx = this.currentElementIxForScan;
        this.currentOffsetForScan = this.startOff - this.elementSize;
        this.currentPageIxForScan = 0;
        this.currentElementIxForScan = 0;
        StringBuilder strBuilder = new StringBuilder();
        while (this.hasNext()) {
            this.next();
            for (int i = 0; i < this.tuple.getFieldCount(); ++i) {
                ByteArrayInputStream inStream = new ByteArrayInputStream(this.tuple.getFieldData(i), this.tuple.getFieldStart(i), this.tuple.getFieldLength(i));
                DataInputStream dataIn = new DataInputStream(inStream);
                Object o = serdes[i].deserialize((DataInput)dataIn);
                strBuilder.append(o.toString());
                if (i + 1 >= this.tuple.getFieldCount()) continue;
                strBuilder.append(",");
            }
            strBuilder.append(" ");
        }
        this.currentOffsetForScan = oldCurrentOff;
        this.currentPageIxForScan = oldCurrentPageId;
        this.currentElementIxForScan = oldCurrentElementIx;
        return strBuilder.toString();
    }

    @Override
    public String printCurrentElement(ISerializerDeserializer[] serdes) throws HyracksDataException {
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < this.tuple.getFieldCount(); ++i) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(this.tuple.getFieldData(i), this.tuple.getFieldStart(i), this.tuple.getFieldLength(i));
            DataInputStream dataIn = new DataInputStream(inStream);
            Object o = serdes[i].deserialize((DataInput)dataIn);
            strBuilder.append(o.toString());
            if (i + 1 >= this.tuple.getFieldCount()) continue;
            strBuilder.append(",");
        }
        return strBuilder.toString();
    }

    private int binarySearch(int[] arr, int arrStart, int arrLength, int key) {
        int begin = arrStart;
        int end = arrStart + arrLength - 1;
        while (begin <= end) {
            int mid = (begin + end) / 2;
            int cmp = key - arr[mid];
            if (cmp < 0) {
                end = mid - 1;
                continue;
            }
            if (cmp > 0) {
                begin = mid + 1;
                continue;
            }
            return mid;
        }
        if (begin > arr.length - 1) {
            return -1;
        }
        if (key < arr[begin]) {
            return begin;
        }
        return -1;
    }

    @Override
    public int compareTo(InvertedListCursor invListCursor) {
        try {
            return this.numElements - invListCursor.size();
        }
        catch (HyracksDataException hde) {
            throw new IllegalStateException(hde);
        }
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public ITupleReference doGetTuple() {
        return this.tuple;
    }

    public void doClose() throws HyracksDataException {
        if (!this.buffers.isEmpty()) {
            this.unloadPages();
        }
    }

    public void doDestroy() throws HyracksDataException {
        if (!this.buffers.isEmpty()) {
            this.unloadPages();
        }
    }
}

