/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.ArrayList;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursorInitialState;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMInvertedIndexRangeSearchCursor
extends LSMIndexSearchCursor {
    private IIndexCursor[] deletedKeysBTreeCursors;
    protected BloomFilter[] bloomFilters;
    protected final long[] hashes = BloomFilter.createHashArray();
    protected ArrayList<IIndexAccessor> deletedKeysBTreeAccessors;
    protected PermutingTupleReference keysOnlyTuple;
    protected RangePredicate keySearchPred;

    public LSMInvertedIndexRangeSearchCursor(ILSMIndexOperationContext opCtx) {
        super(opCtx, false);
    }

    public void doOpen(ICursorInitialState initState, ISearchPredicate searchPred) throws HyracksDataException {
        int i;
        LSMInvertedIndexRangeSearchCursorInitialState lsmInitState = (LSMInvertedIndexRangeSearchCursorInitialState)initState;
        this.cmp = lsmInitState.getOriginalKeyComparator();
        int numComponents = lsmInitState.getNumComponents();
        this.rangeCursors = new IIndexCursor[numComponents];
        for (i = 0; i < numComponents; ++i) {
            IInvertedIndexAccessor invIndexAccessor = (IInvertedIndexAccessor)lsmInitState.getIndexAccessors().get(i);
            this.rangeCursors[i] = invIndexAccessor.createRangeSearchCursor();
            invIndexAccessor.rangeSearch(this.rangeCursors[i], lsmInitState.getSearchPredicate());
        }
        this.lsmHarness = lsmInitState.getLSMHarness();
        this.operationalComponents = lsmInitState.getOperationalComponents();
        this.includeMutableComponent = lsmInitState.getIncludeMemComponent();
        this.keysOnlyTuple = lsmInitState.getKeysOnlyTuple();
        this.deletedKeysBTreeAccessors = lsmInitState.getDeletedKeysBTreeAccessors();
        this.bloomFilters = new BloomFilter[this.deletedKeysBTreeAccessors.size()];
        if (!this.deletedKeysBTreeAccessors.isEmpty()) {
            this.deletedKeysBTreeCursors = new IIndexCursor[this.deletedKeysBTreeAccessors.size()];
            for (i = 0; i < this.operationalComponents.size(); ++i) {
                ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
                this.deletedKeysBTreeCursors[i] = this.deletedKeysBTreeAccessors.get(i).createSearchCursor(false);
                this.bloomFilters[i] = component.getType() == ILSMComponent.LSMComponentType.MEMORY ? null : ((LSMInvertedIndexDiskComponent)component).getBloomFilter();
            }
        }
        MultiComparator keyCmp = lsmInitState.getKeyComparator();
        this.keySearchPred = new RangePredicate((ITupleReference)this.keysOnlyTuple, (ITupleReference)this.keysOnlyTuple, true, true, keyCmp, keyCmp);
        this.setPriorityQueueComparator();
        this.initPriorityQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDeleted(LSMIndexSearchCursor.PriorityQueueElement checkElement) throws HyracksDataException {
        this.keysOnlyTuple.reset(checkElement.getTuple());
        int end = checkElement.getCursorIndex();
        for (int i = 0; i < end; ++i) {
            if (this.bloomFilters[i] != null && this.bloomFilters[i].contains((ITupleReference)this.keysOnlyTuple, this.hashes)) continue;
            this.deletedKeysBTreeCursors[i].close();
            this.deletedKeysBTreeAccessors.get(i).search(this.deletedKeysBTreeCursors[i], (ISearchPredicate)this.keySearchPred);
            try {
                if (!this.deletedKeysBTreeCursors[i].hasNext()) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                this.deletedKeysBTreeCursors[i].close();
            }
        }
        return false;
    }
}

